/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran;

import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranCompilerSupport;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataObject;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

class SurrogateNode
extends AbstractNode {
    private Node realNode;

    public SurrogateNode(Children ch, Node realNode) {
        super(ch);
        this.realNode = realNode;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Remote Compiler Settings");
        set.setDisplayName("Remote Compiler Settings");
        set.setShortDescription("Settings for remote operations on a remote host");
        DataObject dobj = (DataObject)this.realNode.getCookie(DataObject.class);
        if (dobj instanceof FortranDataObject) {
            ((FortranCompilerSupport)dobj.getCookie(FortranCompilerSupport.class)).addProperties(set);
            ((FortranCompilerSupport)dobj.getCookie(FortranCompilerSupport.class)).addMakefileProperty(set);
            ((FortranCompilerSupport)dobj.getCookie(FortranCompilerSupport.class)).addBuildOptionProperty(set);
        }
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        sheet.put(set);
        return sheet;
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("file_residence_mode", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createUseXtermProperty() {
        class UseXtermPropertySupport
        extends PropertySupport.ReadWrite {
            public UseXtermPropertySupport() {
                super("Use Xterm for Compile", Boolean.class, "Use Xterm for Compile", "Use the X terminal window to display the output");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("useXtermCompile");
                if (obj != null) {
                    return obj;
                }
                try {
                    AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem();
                    return new Boolean(nfs.getUseXtermCompile());
                }
                catch (FileStateInvalidException e) {
                    return new Boolean(DistributedSettings.getDefault().getUseXtermCompile());
                }
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("useXtermCompile", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new UseXtermPropertySupport();
    }

    private PropertySupport createRemoteArgumentsProperty() {
        class RemoteArgumentsPropertySupport
        extends PropertySupport.ReadWrite {
            public RemoteArgumentsPropertySupport() {
                super("Remote Arguments", String.class, "Remote Arguments", "Remote Arguments");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
                if (obj != null) {
                    return obj;
                }
                return "";
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("REMOTE_ARGUMENT", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new RemoteArgumentsPropertySupport();
    }
}

