/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.debugger.Field;
import com.hp.openvms.netbeans.debugsupport.debugger.InvalidExpressionException;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;

public class LocalVariableImpl
implements LocalVariable,
Field {
    private String name;
    private String shortname;
    private String previousValueText;
    private String currentValueText;
    private String type;
    private String className;
    private int dimCount;
    private RemoteDebugger debugger;
    private Field[] fields;
    private Field[] staticFields;
    private Field[] inheritedFields;

    public LocalVariableImpl(String name, String type, String value) {
        this.setName(name);
        this.currentValueText = value;
        this.previousValueText = value;
        this.type = type;
        this.dimCount = 1;
        this.debugger = null;
    }

    public String getName() {
        return this.shortname;
    }

    public void setName(String name) {
        this.name = name;
        this.shortname = name;
        int i = this.shortname.lastIndexOf(46);
        if (i >= 0) {
            if (++i < this.shortname.length()) {
                this.shortname = this.shortname.substring(i);
            }
            for (i = 0; i < name.length() && name.charAt(i) == '*'; ++i) {
                this.shortname = '*' + this.shortname;
            }
        }
    }

    public String getValue() {
        return this.currentValueText;
    }

    public void setValue(String expression) throws InvalidExpressionException {
        if (this.debugger == null) {
            return;
        }
        String value = expression;
        if (this.type.equals("char *")) {
            String oldstrValue;
            String strAddr = null;
            String strValue = null;
            int i = expression.indexOf(32);
            if (i >= 0) {
                strAddr = expression.substring(0, i);
                strValue = expression.substring(i + 1);
            } else if (expression.startsWith("0x")) {
                strAddr = expression;
            } else {
                strValue = expression;
            }
            String oldValue = this.getValue();
            if (strAddr != null && !oldValue.startsWith(strAddr)) {
                strAddr = expression;
                this.debugger.setVariableValue(this.name, strAddr);
            }
            if ((i = oldValue.indexOf(32)) >= 0 && !(oldstrValue = oldValue.substring(i + 1)).equals(strValue)) {
                for (int n = 0; n < strValue.length(); ++n) {
                    char c = strValue.charAt(n);
                    if (c == oldstrValue.charAt(n)) continue;
                    if (n < 2) break;
                    int k = n - 2;
                    this.debugger.setVariableValue(this.name + "[" + k + "]", "'" + c + "'");
                }
            }
            return;
        }
        this.debugger.setVariableValue(this.name, value);
    }

    public String getType() {
        if (this.type != null && !this.type.equals("")) {
            return this.type;
        }
        this.type = this.debugger.getVariableType(this.name);
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private boolean typeIsSimple() {
        String type = this.getType();
        if (type == null) {
            return false;
        }
        return type.equals("char") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("long long") || type.equals("double") || type.equals("long double") || type.equals("unsigned char") || type.equals("unsigned short") || type.equals("unsigned int") || type.equals("unsigned long") || type.equals("unsigned long long");
    }

    public String getDeclaredType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public boolean isStatic() {
        return false;
    }

    public int getDimCount() {
        return this.dimCount;
    }

    public void setDimCount(int dimCount) {
        this.dimCount = dimCount;
    }

    public void setDebugger(RemoteDebugger debugger) {
        this.debugger = debugger;
    }

    private void initFields() {
        this.fields = new Field[0];
        this.staticFields = new Field[0];
        this.inheritedFields = new Field[0];
    }

    public void addField(Field field) {
        if (this.fields == null) {
            this.initFields();
        }
        int n = this.fields.length;
        Field[] fv = new Field[n + 1];
        System.arraycopy(this.fields, 0, fv, 0, n);
        this.fields = fv;
        this.fields[n] = field;
    }

    public int getFieldsCount() {
        if (this.fields == null) {
            this.initFields();
        }
        return this.fields.length;
    }

    public Field getField(String name) {
        if (this.fields == null) {
            return null;
        }
        for (Field f : this.fields) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public Field[] getFields(int from, int to) {
        if (this.fields == null) {
            this.initFields();
        }
        if (to != 0) {
            to = Math.min(this.fields.length, to);
            from = Math.min(this.fields.length, from);
            Field[] fv = new Field[to - from];
            System.arraycopy(this.fields, from, fv, 0, to - from);
            return fv;
        }
        return this.fields;
    }
}

