/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.MyPropertiesAction;
import com.hp.openvms.netbeans.dclsupport.dcl.RemoteDCLRunTargetsAction;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.ExecAction;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.MMSDataObject;
import com.hp.openvms.netbeans.utils.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class MMSDataLoader
extends UniFileLoader {
    private static ResourceBundle bundle;
    public static final String REQUIRED_MIME = "text/x-hp+openvms+mms";

    public MMSDataLoader() {
        this(MMSDataObject.class);
    }

    public MMSDataLoader(Class recognizedObject) {
        super(recognizedObject);
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MMSDataLoader.class);
        }
        return bundle.getString(name);
    }

    protected String actionsContext() {
        return "Loaders/text/x-hp+openvms+mms/Actions";
    }

    protected String defaultDisplayName() {
        return "MMS Source Objects";
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensions = new ExtensionList();
        for (int i = 0; i < Constants.MMS_EXTENSIONS.length; ++i) {
            extensions.addExtension(Constants.MMS_EXTENSIONS[i]);
        }
        this.setExtensions(extensions);
        this.getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(FileSystemAction.class), null, SystemAction.get(RemoteDCLRunTargetsAction.class), SystemAction.get(ExecAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(SaveAsTemplateAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(MyPropertiesAction.class)};
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new MMSDataObject(primaryFile, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new MMSFileEntry(obj, primaryFile);
    }

    public class MMSFileEntry
    extends FileEntry.Format {
        static final long serialVersionUID = 8244159045498569316L;
        boolean disableInputStream;
        private Collection activeReaders;

        public MMSFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
            }
            FileObject fo = f.createData(name, ext);
            Format frm = this.createFormat(f, name, ext);
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock lock = fo.lock();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock)));
                    try {
                        String current;
                        while ((current = r.readLine()) != null) {
                            String line = frm.format(current);
                            w.write(line);
                            w.write(10);
                        }
                    }
                    finally {
                        w.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            finally {
                r.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            fo.setAttribute("template", null);
            return fo;
        }

        protected Format createFormat(FileObject target, String n, String e) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("NAME", n);
            map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            map.put("USER", System.getProperty("user.name"));
            MapFormat format = new MapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            return format;
        }
    }
}

