/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.editor.basic;

import com.hp.openvms.netbeans.basicsupport.editor.basic.BasicTokenContext;
import com.hp.openvms.netbeans.basicsupport.editor.basic.IndentInfo;
import com.hp.openvms.netbeans.basicsupport.editor.basic.StringLexerInput;
import com.hp.openvms.netbeans.basicsupport.editor.lang.BasicLanguage;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenCategory;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

public class BasicFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;
    private Language language;
    private LexerInput input;
    private Lexer lex;
    private boolean ansiformat;
    private int caserec = 0;
    private boolean iscomment = false;
    private FormatTokenPosition ContPos = null;

    public BasicFormatSupport(FormatWriter formatWriter) {
        super(formatWriter);
    }

    private int getNumericId(String image) {
        BasicLanguage language = BasicLanguage.get();
        StringLexerInput input = new StringLexerInput(image);
        Lexer lex = language.createLexer();
        lex.restart((LexerInput)input, null);
        Token tok = lex.nextToken();
        return tok.getId().getIntId();
    }

    private TokenId getLexerTokenId(TokenID tokenid) {
        BasicLanguage language = BasicLanguage.get();
        StringLexerInput input = new StringLexerInput(tokenid.getName());
        Lexer lex = language.createLexer();
        lex.restart((LexerInput)input, null);
        Token tok = lex.nextToken();
        return tok.getId();
    }

    public int getCaserec() {
        return this.caserec;
    }

    public void setCaserec(int x) {
        this.caserec = x;
    }

    public void setIsComment(boolean x) {
        this.iscomment = x;
    }

    public boolean getIsComment() {
        return this.iscomment;
    }

    public boolean isSingleLineComment(TokenItem token) {
        return token != null && token.getImage().startsWith("!");
    }

    public int getCommentPosition() {
        return 1;
    }

    public int getFormattedIndentPosition() {
        return 0;
    }

    public int getTokenIndent(TokenItem token) {
        FormatTokenPosition tp = this.getPosition(token, 0);
        FormatTokenPosition fnw = this.findLineFirstNonWhitespace(tp);
        if (fnw != null) {
            TokenItem t = fnw.getToken();
            Object object = fnw = t == null && t.getImage().length() > 0 ? null : this.getPosition(t, 0);
            if (fnw != null) {
                tp = fnw;
            }
        }
        return this.getVisualColumnOffset(tp);
    }

    public boolean isPreviousLineBlank(FormatTokenPosition current) {
        FormatTokenPosition lstartnw = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        prev = this.findPreviousEOL(current);
        lstart = this.findLineStart(prev);
        lstartnw = this.getInitialPosition(lstart);
        return lstartnw == null;
    }

    public FormatTokenPosition GetPreviousLinePosition(FormatTokenPosition current) {
        FormatTokenPosition tempPos = current;
        FormatTokenPosition lstartnw = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        prev = this.findPreviousEOL(current);
        lstart = this.findLineStart(prev);
        lstartnw = this.getInitialPosition(lstart);
        return lstartnw;
    }

    public FormatTokenPosition GetMostRecentELSEorIFStatement(FormatTokenPosition current) {
        FormatTokenPosition temppos = current;
        Object temp = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        FormatTokenPosition lstartnw = null;
        boolean flag = true;
        while (temppos != null) {
            prev = this.findPreviousEOL(temppos);
            lstart = this.findLineStart(prev);
            lstartnw = this.getInitialPosition(lstart);
            if (lstartnw.getToken().getImage() == "if" || lstartnw.getToken().getImage() == "else") {
                return lstartnw;
            }
            temppos = prev;
        }
        return temppos;
    }

    public FormatTokenPosition GetMostRecentIFStatement(FormatTokenPosition current) {
        FormatTokenPosition temppos = current;
        Object temp = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        FormatTokenPosition lstartnw = null;
        boolean flag = true;
        while (temppos != null) {
            prev = this.findPreviousEOL(temppos);
            lstart = this.findLineStart(prev);
            lstartnw = this.getInitialPosition(lstart);
            if (lstartnw.getToken().getImage() == "if") {
                return lstartnw;
            }
            temppos = prev;
        }
        return temppos;
    }

    public FormatTokenPosition getPreviousTokenPosition(FormatTokenPosition current, int depth) {
        FormatTokenPosition tempPos = current;
        Object lstartnw = null;
        FormatTokenPosition prev = null;
        Object prev1 = null;
        Object lstart = null;
        for (int i = 0; i < depth; ++i) {
            while (this.isPreviousLineBlank(current)) {
                tempPos = this.findPreviousEOL(current);
                current = prev = this.getPreviousPosition(tempPos);
            }
            current = prev = this.GetPreviousLinePosition(current);
        }
        return current;
    }

    public boolean isStartingWithElse(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 135) {
                    return true;
                }
                if (tok.getId().getIntId() == 1) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isStartingWithIf(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean ret = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 208) {
                    ret = true;
                    break;
                }
                if (tok.getId().getIntId() == 135) {
                    ret = false;
                    break;
                }
                if (tok.getId().getIntId() != 1) continue;
            }
            return ret;
        }
        return false;
    }

    public boolean isIfOnlyStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isifonly = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 194 || tok.getId().getIntId() == 196) {
                    return false;
                }
                if (tok.getId().getIntId() == 208) {
                    isifonly = true;
                    return isifonly;
                }
                isifonly = false;
            }
            return isifonly;
        }
        return false;
    }

    public boolean isIfThenStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isifthen = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 208) {
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 397) continue;
                        isifthen = true;
                        tok = lex.nextToken();
                        if (tok == null) {
                            isifthen = false;
                        }
                        return isifthen;
                    }
                    continue;
                }
                isifthen = false;
            }
            return isifthen;
        }
        return false;
    }

    public boolean isIfThenOnlyStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isifthen = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 208) {
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 397) continue;
                        isifthen = true;
                        tok = lex.nextToken();
                        if (tok == null) {
                            isifthen = true;
                        }
                        return isifthen;
                    }
                    continue;
                }
                isifthen = false;
            }
            return isifthen;
        }
        return false;
    }

    public boolean isBegin(FormatTokenPosition pos) {
        return false;
    }

    public boolean isEnd(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isend = false;
            Token tok = lex.nextToken();
            if (tok == null) {
                return isend;
            }
            if (tok.getId().getIntId() == 136) {
                isend = true;
                return isend;
            }
            tok = lex.nextToken();
            if (tok == null) {
                return isend;
            }
            if (tok.getId().getIntId() == 136) {
                isend = true;
                return isend;
            }
            isend = false;
            return isend;
        }
        return false;
    }

    public boolean isWhile(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean iswhile = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 431) {
                    iswhile = true;
                    return iswhile;
                }
                iswhile = false;
            }
            return iswhile;
        }
        return false;
    }

    public boolean isWith(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean iswith = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 434) {
                    iswith = true;
                    while ((tok = lex.nextToken()) != null) {
                        iswith = false;
                    }
                    continue;
                }
                iswith = false;
            }
            return iswith;
        }
        return false;
    }

    public boolean isForOnly(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isfor = false;
            boolean i = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 194 || tok.getId().getIntId() == 196) {
                    return false;
                }
                if (tok.getId().getIntId() == 178) {
                    return true;
                }
                isfor = false;
            }
            return isfor;
        }
        return false;
    }

    public int getCountOpenParen(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            int lp = 0;
            int rp = 0;
            Token tok = lex.nextToken();
            while (tok != null) {
                if (tok.getId().getIntId() == 446 || tok.getId().getIntId() == 447) {
                    ++lp;
                } else if (tok.getId().getIntId() == 448 || tok.getId().getIntId() == 449) {
                    ++rp;
                }
                tok = lex.nextToken();
            }
            if (lp > rp) {
                return lp - rp;
            }
            return 0;
        }
        return 0;
    }

    public int getCountClosedParen(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            int lp = 0;
            int rp = 0;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 446 || tok.getId().getIntId() == 447) {
                    ++lp;
                    continue;
                }
                if (tok.getId().getIntId() != 448 && tok.getId().getIntId() != 449) continue;
                ++rp;
            }
            if (rp > lp) {
                return rp - lp;
            }
            return 0;
        }
        return 0;
    }

    public boolean isLineClosedOnly(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            int lp = 0;
            int rp = 0;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 446 || tok.getId().getIntId() == 447) {
                    ++lp;
                    continue;
                }
                if (tok.getId().getIntId() != 448 && tok.getId().getIntId() != 449) continue;
                ++rp;
            }
            return rp > lp;
        }
        return false;
    }

    public int getLineOpenPos(FormatTokenPosition pos) {
        FormatTokenPosition tmpPos = this.getInitialPosition(pos);
        int iPos = 0;
        if (tmpPos != null) {
            String tmpStr = tmpPos.getToken().getImage().trim();
            iPos = tmpStr.indexOf("(");
            if (iPos < 0) {
                iPos = tmpStr.indexOf("[");
            }
            iPos = iPos >= 0 ? iPos + 1 + this.getVisualColumnOffset(tmpPos) : this.getVisualColumnOffset(tmpPos);
        }
        return iPos;
    }

    public boolean isCase(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean iscase = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 76) {
                    return true;
                }
                iscase = false;
            }
            return iscase;
        }
        return false;
    }

    public boolean isRepeat(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrep = false;
            return isrep;
        }
        return false;
    }

    public boolean isEndRecord(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 143) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 329) continue;
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isRecord(FormatTokenPosition pos) {
        if (this.isEndRecord(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (this.isReservedWord(tok.getId())) {
                    if (tok.getId().getIntId() == 329) {
                        isrec = true;
                        return isrec;
                    }
                    return false;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isArray(FormatTokenPosition pos) {
        return false;
    }

    public boolean isFileOnly(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isfile = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 165) continue;
                isfile = true;
                tok = lex.nextToken();
                if (tok != null) {
                    tok = lex.nextToken();
                }
                if (tok.getId().getIntId() == 287) {
                    tok = lex.nextToken();
                    if (tok != null) {
                        isfile = false;
                    }
                    return isfile;
                }
                isfile = false;
                return isfile;
            }
            return isfile;
        }
        return false;
    }

    public boolean isSet(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isset = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 356) {
                    isset = true;
                    tok = lex.nextToken();
                    if (tok.getId().getIntId() == 287) {
                        return isset;
                    }
                    isset = false;
                    return isset;
                }
                isset = false;
            }
            return isset;
        }
        return false;
    }

    public boolean isUntil(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isuntil = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 415) {
                    isuntil = true;
                    return isuntil;
                }
                isuntil = false;
            }
            return isuntil;
        }
        return false;
    }

    public boolean isVar(FormatTokenPosition pos) {
        return false;
    }

    public boolean isType(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean istype = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 408) continue;
                istype = true;
                break;
            }
            return istype;
        }
        return false;
    }

    public boolean isProgram(FormatTokenPosition pos) {
        if (this.isEndProgram(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isprog = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 316) {
                    isprog = true;
                    return isprog;
                }
                isprog = false;
            }
            return isprog;
        }
        return false;
    }

    public boolean isProcedure(FormatTokenPosition pos) {
        return false;
    }

    public boolean isFunction(FormatTokenPosition pos) {
        if (this.isEndFunction(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isfunc = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 185) continue;
                isfunc = true;
                return isfunc;
            }
            return isfunc;
        }
        return false;
    }

    public boolean isLabel(FormatTokenPosition pos) {
        return false;
    }

    public boolean isConst(FormatTokenPosition pos) {
        return false;
    }

    public boolean isBeginInSameLineAsEnd(FormatTokenPosition pos) {
        pos = this.getInitialPosition(pos);
        BasicLanguage language = BasicLanguage.get();
        StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
        Lexer lex = language.createLexer();
        lex.restart((LexerInput)input, null);
        Token tok = lex.nextToken();
        boolean ret = false;
        return ret;
    }

    public boolean isRepeatInSameLineAsUntil(FormatTokenPosition pos) {
        boolean ret = false;
        return ret;
    }

    public boolean isIfInSameLineAsElse(FormatTokenPosition pos) {
        if ((pos = this.getInitialPosition(pos)) == null) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
        Lexer lex = language.createLexer();
        lex.restart((LexerInput)input, null);
        Token tok = lex.nextToken();
        boolean ret = false;
        int i = 0;
        int e = 0;
        while (tok != null) {
            if (tok.getId().getIntId() == 208) {
                i = 1;
                Token tmp = lex.nextToken();
                while (tmp != null) {
                    if (tmp.getId().getIntId() == 135) {
                        ++e;
                    } else if (tmp.getId().getIntId() == 208) {
                        ++i;
                    }
                    tmp = lex.nextToken();
                }
                ret = i == e;
                return ret;
            }
            if (tok.getId().getIntId() != 1) {
                ret = false;
            }
            tok = lex.nextToken();
        }
        return ret;
    }

    public FormatTokenPosition getPreviousUnbalancedLine(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        FormatTokenPosition prev = this.getPreviousNonEmptyLine(pos);
        int i = 0;
        int j = 0;
        int k = 0;
        int rec = 0;
        while (prev != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            if (!this.isBeginInSameLineAsEnd(prev) && !this.isComment(prev)) {
                if (this.isEnd(prev)) {
                    ++i;
                } else if (this.isRecord(prev)) {
                    if (i > 0) {
                        --i;
                    } else if (rec > 0) {
                        --rec;
                    } else if (i == 0) {
                        return this.getNextNonEmptyLine(prev);
                    }
                } else if (this.isCase(prev)) {
                    if (k <= 0) {
                        if (k == 0 && i == 0) {
                            return this.getNextNonEmptyLine(prev);
                        }
                        if (k == 0 && i >= 1) {
                            --i;
                            ++rec;
                        }
                    }
                } else if (this.isBegin(prev)) {
                    if (i > 0) {
                        --i;
                    } else if (i == 0) {
                        return this.getNextNonEmptyLine(prev);
                    }
                } else {
                    if (this.isVar(prev) || this.isType(prev) || this.isProgram(prev) || this.isConst(prev)) {
                        return this.getNextNonEmptyLine(prev);
                    }
                    if ((this.isFunction(prev) || this.isProcedure(prev)) && !this.isEndingWithSemicolon(prev)) {
                        return this.getNextNonEmptyLine(prev);
                    }
                    if (this.isUntil(prev)) {
                        if (!this.isRepeatInSameLineAsUntil(prev)) {
                            ++j;
                        }
                    } else if (this.isRepeat(prev)) {
                        if (!this.isRepeatInSameLineAsUntil(prev)) {
                            if (j > 0) {
                                --j;
                            } else if (j == 0) {
                                return this.getNextNonEmptyLine(prev);
                            }
                        }
                    } else if (this.isLineClosedOnly(prev)) {
                        ++k;
                    }
                }
            }
            prev = this.getPreviousNonEmptyLine(prev);
        }
        return this.getPreviousNonEmptyLine(pos);
    }

    public int getIndentationInfo(FormatTokenPosition pos, IndentInfo idf) {
        int indent = 0;
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        if (firstNWS != null) {
            Token tok;
            BasicLanguage language = BasicLanguage.get();
            StringLexerInput input = new StringLexerInput(firstNWS.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            block5: while ((tok = lex.nextToken()) != null) {
                switch (tok.getId().getIntId()) {
                    case 1: {
                        continue block5;
                    }
                    case 208: {
                        boolean onlyIf = true;
                        indent = this.getVisualColumnOffset(firstNWS);
                        idf.setIndent(indent);
                        idf.setType(31);
                        while ((tok = lex.nextToken()) != null) {
                            if (tok.getId().getIntId() != 397) continue;
                            indent = this.getVisualColumnOffset(firstNWS);
                            idf.setIndent(indent);
                            idf.setType(5);
                            onlyIf = false;
                        }
                        break block5;
                    }
                    case 135: {
                        indent = this.getVisualColumnOffset(firstNWS);
                        idf.setIndent(indent);
                        idf.setType(30);
                        break block5;
                    }
                    default: {
                        indent = this.getVisualColumnOffset(firstNWS);
                        idf.setIndent(indent);
                        idf.setType(3);
                        break block5;
                    }
                }
            }
        }
        return indent;
    }

    public boolean getFreeFormat() {
        return true;
    }

    public int getIndent(FormatTokenPosition pos) {
        if (pos != null) {
            return this.getVisualColumnOffset(pos);
        }
        return 0;
    }

    public int getVisualPos(FormatTokenPosition pos, String strVal) {
        int tmpPos = pos.getToken().getImage().toLowerCase().indexOf(strVal);
        if (tmpPos < 0) {
            tmpPos = 0;
        }
        return tmpPos;
    }

    public FormatTokenPosition getInitialPosition(FormatTokenPosition pos) {
        if (pos == null) {
            return pos;
        }
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        return firstNWS;
    }

    public FormatTokenPosition getStatementPos(FormatTokenPosition pos) {
        TokenItem token;
        if (pos == null) {
            return pos;
        }
        FormatTokenPosition tmpPos = null;
        for (token = pos.getToken(); token != null && token.getTokenID() == BasicTokenContext.WHITESPACE; token = token.getNext()) {
        }
        while (token != null && (token.getTokenID() == BasicTokenContext.NUM_LITERAL_INT || token.getTokenID() == BasicTokenContext.SLASHCHAR)) {
            token = token.getNext();
        }
        while (token.getTokenID() == BasicTokenContext.WHITESPACE) {
            token = token.getNext();
        }
        if (token != null) {
            tmpPos = this.getPosition(token, 0);
        }
        return tmpPos;
    }

    public boolean isPreviousLineEmpty(FormatTokenPosition pos) {
        if (pos == null) {
            return false;
        }
        FormatTokenPosition temp = this.getPreviousLine(pos);
        if (temp == null) {
            return false;
        }
        return this.findLineFirstNonWhitespace(temp) == null;
    }

    public boolean isPreviousLineComment(FormatTokenPosition pos) {
        if (pos == null) {
            return false;
        }
        FormatTokenPosition temp = this.getPreviousLine(pos);
        if (temp == null) {
            return false;
        }
        if ((temp = this.getInitialPosition(temp)) == null) {
            return false;
        }
        if (this.isComment(temp)) {
            this.iscomment = false;
            return true;
        }
        if (this.isCommentPresent(temp, "}", "*)")) {
            if (this.isCommentPresent(temp, "{", "(*")) {
                return false;
            }
            this.iscomment = true;
            return true;
        }
        return this.iscomment;
    }

    public boolean isNextLineEmpty(FormatTokenPosition pos) {
        if (pos == null) {
            return false;
        }
        FormatTokenPosition temp = this.getNextLine(pos);
        if (temp == null) {
            return false;
        }
        return this.findLineFirstNonWhitespace(temp) == null;
    }

    public boolean isNextLineComment(FormatTokenPosition pos) {
        if (pos == null) {
            return false;
        }
        FormatTokenPosition temp = this.getNextLine(pos);
        if (temp == null) {
            return false;
        }
        return this.isComment(temp);
    }

    public FormatTokenPosition getPreviousLine(FormatTokenPosition current) {
        if (current == null) {
            return null;
        }
        FormatTokenPosition temp = this.findLineStart(current);
        if (temp == null) {
            return null;
        }
        FormatTokenPosition prev = this.getPreviousPosition(temp);
        if (prev == null) {
            return null;
        }
        return this.findLineStart(prev);
    }

    public FormatTokenPosition getPreviousNonEmptyLine(FormatTokenPosition current) {
        if (current == null) {
            return null;
        }
        FormatTokenPosition temp = current;
        while (this.isPreviousLineEmpty(current) || this.isPreviousLineComment(current) || this.isStatementLabel(current)) {
            current = this.getPreviousLine(current);
        }
        temp = this.getPreviousLine(current);
        if (this.isStatementLabel(temp)) {
            temp = this.getPreviousNonEmptyLine(temp);
        }
        if (temp != null && this.isWhite(temp)) {
            temp = this.getInitialPosition(temp);
        }
        return temp;
    }

    public FormatTokenPosition getNextLine(FormatTokenPosition current) {
        FormatTokenPosition temp = this.findLineEnd(current);
        FormatTokenPosition prev = this.getNextPosition(temp);
        if (prev == null) {
            return null;
        }
        return prev;
    }

    public FormatTokenPosition getNextNonEmptyLine(FormatTokenPosition current) {
        FormatTokenPosition temp = current;
        while (this.isNextLineEmpty(current) | this.isNextLineComment(current) | this.isStatementLabel(current)) {
            current = this.getNextLine(current);
        }
        return this.getNextLine(current);
    }

    public boolean isWhite(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = true;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 1) continue;
                status = false;
                break;
            }
        }
        return status;
    }

    public boolean isELSEStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 135) continue;
                status = true;
                tok = lex.nextToken();
                if (tok != null) continue;
                return false;
            }
        }
        return status;
    }

    public boolean isElseIfStatement(FormatTokenPosition pos) {
        if (this.isEndingWithSemicolon(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 135) continue;
                status = true;
                tok = lex.nextToken();
                status = tok == null ? false : tok.getId().getIntId() == 208;
                return status;
            }
        }
        return status;
    }

    public boolean isELSEOnlyStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 76) {
                    return false;
                }
                if (tok.getId().getIntId() == 135) {
                    status = true;
                    return status;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isReservedWord(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory reserveCategory = language.getCategory("Reserved Words");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            status = reserveCategory.isMember(tok.getId());
        }
        return status;
    }

    public boolean isReservedWord(TokenId tokId) {
        BasicLanguage language = BasicLanguage.get();
        TokenCategory reserveCategory = language.getCategory("Reserved Words");
        return reserveCategory.isMember(tokId);
    }

    public boolean isBasicWord(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory reserveCategory = language.getCategory("Basic Words");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            status = reserveCategory.isMember(tok.getId());
        }
        return status;
    }

    public boolean isIdentifiers(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory reserveCategory = language.getCategory("Identifiers");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            status = reserveCategory.isMember(tok.getId());
        }
        return status;
    }

    public boolean isIFStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 194 || tok.getId().getIntId() == 196) {
                    return false;
                }
                if (tok.getId().getIntId() != 208) continue;
                if (this.isContendExp(pos, "if")) {
                    return false;
                }
                return !this.isContinuedStatement(this.getPreviousNonEmptyLine(pos));
            }
        }
        return status;
    }

    public boolean isThenStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 397) {
                    status = true;
                    continue;
                }
                if (tok.getId().getIntId() == 208) {
                    return false;
                }
                if (tok.getId().getIntId() != 452) continue;
                status = false;
            }
        }
        return status;
    }

    public boolean isENDIFStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 141) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 208) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isEndingWithPeriod(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            String temp = pos.getToken().getImage();
            String trimmed = temp.trim();
            String sub = trimmed.trim().substring(trimmed.length() - 1);
            status = sub.equals(".");
        }
        return status;
    }

    public boolean isEndingWithSemicolon(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 452 || (tok = lex.nextToken()) != null) continue;
                return true;
            }
        }
        return status;
    }

    public boolean isEndingWithComma(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 453 || (tok = lex.nextToken()) != null) continue;
                return true;
            }
        }
        return status;
    }

    public boolean isContinuedStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            String stmStr = pos.getToken().getImage().trim();
            StringLexerInput input = new StringLexerInput(stmStr);
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 467) {
                    tok = lex.nextToken();
                    if (tok != null) continue;
                    return true;
                }
                if (!this.isComment(tok.getId()) || stmStr.indexOf("!") == -1) continue;
                return stmStr.endsWith("&");
            }
        }
        return status;
    }

    public boolean isComment(TokenId tokId) {
        BasicLanguage language = BasicLanguage.get();
        TokenCategory commentCategory = language.getCategory("Comments");
        return commentCategory.isMember(tokId);
    }

    public boolean isComment(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory commentCategory = language.getCategory("Comments");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            if (tok != null) {
                status = commentCategory.isMember(tok.getId());
            }
            if (status && this.isCommentPresent(pos, "!")) {
                return true;
            }
        }
        return status;
    }

    public String getCommentChar(FormatTokenPosition pos) {
        if (pos != null) {
            String temp = pos.getToken().getImage();
            if (temp.indexOf("!") != -1) {
                return "!";
            }
            if (temp.toLowerCase().indexOf(" rem ") != -1) {
                return "rem";
            }
        }
        return null;
    }

    public boolean isCommentPresent(FormatTokenPosition pos, String commCh1, String commCh2) {
        if (pos == null) {
            return false;
        }
        if (pos.getToken() == null) {
            return false;
        }
        String temp = pos.getToken().getImage();
        if (temp == null) {
            return false;
        }
        return temp.indexOf(commCh1) != -1 || temp.indexOf(commCh2) != -1;
    }

    public boolean isCommentPresent(FormatTokenPosition pos, String commCh1) {
        String temp = pos.getToken().getImage();
        return temp.indexOf(commCh1) != -1;
    }

    public boolean isContinueBooleanExp(FormatTokenPosition pos) {
        int i;
        if (pos == null) {
            return false;
        }
        if (pos.getToken() == null) {
            return false;
        }
        String tmpStr = pos.getToken().getImage();
        String[] arrayStr = new String[]{"and", "or", "not", "and_then", "or_else"};
        if (tmpStr == null) {
            return false;
        }
        tmpStr = tmpStr.toLowerCase().trim();
        for (i = 0; i < arrayStr.length; ++i) {
            if (!tmpStr.startsWith(arrayStr[i])) continue;
            return true;
        }
        for (i = 0; i < arrayStr.length; ++i) {
            if (!tmpStr.endsWith(arrayStr[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isPercentIncludeStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            if (tok == null) {
                return false;
            }
            if (tok.getId().getIntId() == 25) {
                status = true;
            }
        }
        return status;
    }

    public boolean isPercentIFStatement(FormatTokenPosition pos) {
        if (this.isPercentEndIFStatement(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            do {
                if ((tok = lex.nextToken()) != null) continue;
                return false;
            } while (tok.getId().getIntId() != 24);
            tok = lex.nextToken();
            return tok != null;
        }
        return status;
    }

    public boolean isPercentThenStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            do {
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() != 34) continue;
                return true;
            } while (tok.getId().getIntId() != 24);
            return false;
        }
        return status;
    }

    public boolean isPercentElseStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            do {
                if ((tok = lex.nextToken()) != null) continue;
                return false;
            } while (tok.getId().getIntId() != 19);
            return true;
        }
        return status;
    }

    public boolean isPercentEndIFStatement(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 21) {
                    return true;
                }
                if (tok.getId().getIntId() == 20) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 24) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isGroup(FormatTokenPosition pos) {
        if (this.isEndGroup(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 200) {
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndGroup(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 139) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 200) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isHandler(FormatTokenPosition pos) {
        if (this.isEndHandler(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 203) {
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndHandler(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 140) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 203) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isDef(FormatTokenPosition pos) {
        if (this.isEndDef(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 116) {
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndDef(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 137) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 116) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isFNEnd(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 175) {
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isVariant(FormatTokenPosition pos) {
        if (this.isEndVariant(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 423) {
                    tok = lex.nextToken();
                    return tok == null;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndVariant(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 146) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 423) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isSelect(FormatTokenPosition pos) {
        if (this.isEndSelect(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 354) {
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndSelect(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 144) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        status = false;
                        continue;
                    }
                    if (tok.getId().getIntId() != 354) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isSub(FormatTokenPosition pos) {
        if (this.isEndSub(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (this.isReservedWord(tok.getId())) {
                    if (tok.getId().getIntId() == 384) {
                        isrec = true;
                        return isrec;
                    }
                    return false;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndSub(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 145) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 384) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isWhen(FormatTokenPosition pos) {
        if (this.isEndWhen(pos)) {
            return false;
        }
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 430) {
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isNext(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 267) {
                    return true;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndWhen(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 147) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 430) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isUse(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isrec = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 417) {
                    tok = lex.nextToken();
                    return tok == null;
                }
                isrec = false;
            }
            return isrec;
        }
        return false;
    }

    public boolean isEndProgram(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 142) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 316) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public boolean isEndFunction(FormatTokenPosition pos) {
        BasicLanguage language = BasicLanguage.get();
        boolean status = false;
        if (pos != null) {
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while (true) {
                Token tok;
                if ((tok = lex.nextToken()) == null) {
                    return false;
                }
                if (tok.getId().getIntId() == 138 || tok.getId().getIntId() == 186) {
                    return true;
                }
                if (tok.getId().getIntId() == 136) {
                    tok = lex.nextToken();
                    if (tok == null) {
                        return false;
                    }
                    if (tok.getId().getIntId() != 185) continue;
                    return true;
                }
                status = false;
            }
        }
        return status;
    }

    public void setStartingContinuePos(FormatTokenPosition pos) {
        this.ContPos = pos;
    }

    public FormatTokenPosition getStartingContinuePos() {
        return this.ContPos;
    }

    public boolean isStatementLabel(FormatTokenPosition pos) {
        if (pos == null) {
            return false;
        }
        FormatTokenPosition tmpPos = this.findLineFirstNonWhitespace(pos);
        if (tmpPos == null) {
            return false;
        }
        if (this.isComment(tmpPos)) {
            return false;
        }
        TokenItem token = tmpPos.getToken();
        if (token != null) {
            String tmpStr = token.getImage();
            int lenStr = 0;
            if (tmpStr == null) {
                return false;
            }
            lenStr = (tmpStr = tmpStr.trim()).indexOf(":");
            if (lenStr == -1) {
                return false;
            }
            if (tmpStr.indexOf("::") != -1) {
                return false;
            }
            int squoLoc = tmpStr.indexOf("'");
            int dquoLoc = tmpStr.indexOf("\"");
            int commentLoc = tmpStr.indexOf("!");
            if (squoLoc != -1 && squoLoc < lenStr) {
                return false;
            }
            if (dquoLoc != -1 && dquoLoc < lenStr) {
                return false;
            }
            if (commentLoc != -1 && commentLoc < lenStr) {
                return false;
            }
            if (lenStr <= 31 && lenStr >= 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isContendExp(FormatTokenPosition pos) {
        FormatTokenPosition tmpPos = this.findLineFirstNonWhitespace(pos);
        if (tmpPos == null) {
            return false;
        }
        TokenItem token = tmpPos.getToken();
        if (token != null) {
            String tmpStr = token.getImage();
            int lenStr = 0;
            if (tmpStr == null) {
                return false;
            }
            String[] expLst = new String[]{"=", "<", ">", "<>"};
            tmpStr = tmpStr.trim();
            for (int i = 0; i < expLst.length; ++i) {
                lenStr = tmpStr.indexOf(expLst[i]);
                if (lenStr == -1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContendExp(FormatTokenPosition pos, String verb) {
        FormatTokenPosition tmpPos = this.findLineFirstNonWhitespace(pos);
        if (tmpPos == null) {
            return false;
        }
        TokenItem token = tmpPos.getToken();
        if (token != null) {
            String tmpStr = token.getImage();
            if (tmpStr == null) {
                return false;
            }
            String[] expLst = new String[]{"=", "<", ">", "<>", "goto", "gosub", "iterate", "print"};
            tmpStr = tmpStr.trim().toLowerCase();
            int lenStr = 0;
            int verbLoc = tmpStr.indexOf(verb);
            if (verbLoc == -1) {
                return false;
            }
            for (int i = 0; i < expLst.length; ++i) {
                lenStr = tmpStr.indexOf(expLst[i]);
                if (lenStr == -1 || verbLoc <= lenStr) continue;
                return true;
            }
        }
        return false;
    }
}

