/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;
import org.openide.compiler.DependencyException;
import org.openide.compiler.IdSet;
import org.openide.util.enum.QueueEnumeration;

final class Graph {
    private HashMap vertex = new HashMap(31);
    private List levels;

    public Graph(Compilable compilable) {
        Enumeration enumeration = Graph.compilables(compilable);
        while (enumeration.hasMoreElements()) {
            Compilable compilable2 = (Compilable)enumeration.nextElement();
            Vertex vertex = (Vertex)this.vertex.get(compilable2);
            if (vertex == null) {
                vertex = new Vertex();
                this.vertex.put(compilable2, vertex);
            }
            vertex.add(compilable2);
        }
        this.addDeps();
    }

    public boolean isUpToDate(Date date) {
        Iterator iterator = this.vertex.values().iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            if (vertex.isUpToDate(date)) continue;
            return false;
        }
        return true;
    }

    public synchronized List getLevels() throws DependencyException {
        Compilable[] compilableArray;
        if (this.levels != null) {
            return this.levels;
        }
        List list = this.depth();
        if (list == null) {
            return this.levels;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            compilableArray = (Compilable[])listIterator.next();
            listIterator.set(compilableArray.compilables.iterator().next());
        }
        compilableArray = new Compilable[list.size()];
        list.toArray(compilableArray);
        throw new DependencyException(compilableArray);
    }

    private void addDeps() {
        Iterator iterator = this.vertex.values().iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            this.addDeps(vertex);
        }
    }

    private void addDeps(Vertex vertex) {
        Iterator iterator = vertex.compilables.iterator();
        while (iterator.hasNext()) {
            Compilable compilable = (Compilable)iterator.next();
            Iterator iterator2 = compilable.dependsOn().iterator();
            while (iterator2.hasNext()) {
                Compilable compilable2 = (Compilable)iterator2.next();
                this.addCompilerDep(null, compilable.compilers(), compilable2.compilers());
            }
            this.addCompilerDep(vertex, compilable.compilers(), null);
        }
    }

    private void addCompilerDep(Vertex vertex, Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Compiler compiler = (Compiler)iterator.next();
            Vertex vertex2 = (Vertex)this.vertex.get(compiler);
            if (collection2 != null) {
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    Vertex vertex3 = (Vertex)this.vertex.get(iterator2.next());
                    if (vertex3 == vertex2) continue;
                    vertex2.addDep(vertex3);
                }
            }
            if (vertex == null || vertex == vertex2) continue;
            vertex.addDep(vertex2);
        }
    }

    private List depth() {
        Object object;
        Object object2;
        Iterator iterator = this.vertex.values().iterator();
        int n = -1;
        while (iterator.hasNext()) {
            object2 = (Vertex)iterator.next();
            if (object2.depth > 0) continue;
            object = Graph.computeDepth((Vertex)object2);
            if (object != null) {
                return object;
            }
            if (object2.depth <= n) continue;
            n = object2.depth;
        }
        object2 = new Set[n];
        iterator = this.vertex.values().iterator();
        while (iterator.hasNext()) {
            object = (Vertex)iterator.next();
            int n2 = ((Vertex)object).depth - 1;
            if (object2[n2] == null) {
                object2[n2] = new IdSet();
            }
            Graph.addCompilersFrom(object2[n2], ((Vertex)object).compilables);
        }
        this.levels = Arrays.asList(object2);
        return null;
    }

    private static void addCompilersFrom(Collection collection, Collection collection2) {
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Compiler)) continue;
            collection.add(e);
        }
    }

    private static LinkedList computeDepth(Vertex vertex) {
        if (vertex.dependsOn == null) {
            vertex.depth = 1;
            return null;
        }
        if (vertex.depth == -1) {
            LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
            linkedList.add(vertex);
            return linkedList;
        }
        vertex.depth = -1;
        int n = -1;
        Iterator iterator = vertex.dependsOn.iterator();
        while (iterator.hasNext()) {
            Vertex vertex2 = (Vertex)iterator.next();
            LinkedList linkedList = Graph.computeDepth(vertex2);
            if (linkedList != null) {
                if (linkedList.size() == 1 || linkedList.getFirst() != linkedList.getLast()) {
                    linkedList.add(vertex);
                }
                return linkedList;
            }
            if (vertex2.depth <= n) continue;
            n = vertex2.depth;
        }
        vertex.depth = n == -1 || vertex.anyCompiler() != null ? n + 1 : n;
        return null;
    }

    private static Enumeration compilables(Compilable compilable) {
        QueueEnumeration queueEnumeration = new QueueEnumeration(){
            private IdSet set = new IdSet();

            public void process(Object object) {
                Compilable compilable = (Compilable)object;
                this.set.add(compilable);
                LinkedList linkedList = new LinkedList(compilable.compilers());
                linkedList.addAll(compilable.dependsOn());
                linkedList.removeAll(this.set);
                this.put(linkedList.toArray());
            }
        };
        queueEnumeration.put((Object)compilable);
        return queueEnumeration;
    }

    private static final class Vertex {
        public Collection compilables = new IdSet();
        public Collection dependsOn;
        public int depth;
        private static int count;
        private int cnt = ++count;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Vertex ");
            stringBuffer.append(this.cnt);
            stringBuffer.append(" (");
            stringBuffer.append(this.compilables);
            stringBuffer.append(", ");
            if (this.dependsOn == null) {
                stringBuffer.append("null, ");
            } else {
                stringBuffer.append("{");
                Iterator iterator = this.dependsOn.iterator();
                Vertex vertex = (Vertex)iterator.next();
                stringBuffer.append(vertex.cnt);
                while (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    Vertex vertex2 = (Vertex)iterator.next();
                    stringBuffer.append(vertex2.cnt);
                }
                stringBuffer.append("}, ");
            }
            stringBuffer.append(this.depth);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public void add(Compilable compilable) {
            this.compilables.add(compilable);
        }

        public void addDep(Vertex vertex) {
            if (this.dependsOn == null) {
                this.dependsOn = new IdSet();
            }
            this.dependsOn.add(vertex);
        }

        public Compiler anyCompiler() {
            Iterator iterator = this.compilables.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Compiler)) continue;
                return (Compiler)e;
            }
            return null;
        }

        public boolean isUpToDate(Date date) {
            Iterator iterator = this.compilables.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Compiler)) continue;
                Compiler compiler = (Compiler)e;
                if (!compiler.isUpToDate()) {
                    return false;
                }
                if (date == null || compiler.getTimeStamp() != null && compiler.getTimeStamp().compareTo(date) <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

