/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.util;

import org.netbeans.api.lexer.Language;
import org.netbeans.spi.lexer.util.LexerUtilities;

public abstract class LexerTestDescription {
    public abstract Language getLanguage();

    public abstract TestRound[] getTestRounds();

    public TestChar[] getTestChars() {
        return null;
    }

    public TestCharInterval[] getTestCharIntervals() {
        return null;
    }

    public TestString[] getTestStrings() {
        return null;
    }

    public int getMaxDocumentLength() {
        return 5000;
    }

    public int getDebugLevel() {
        return 0;
    }

    public class TestRound {
        private int operationCount;
        private double insertRatio;
        private int maxInsertLength;
        private double removeRatio;
        private int maxRemoveLength;

        public TestRound(int n, double d, int n2, double d2, int n3) {
            this.operationCount = n;
            this.insertRatio = d;
            this.maxInsertLength = n2;
            this.removeRatio = d2;
            this.maxRemoveLength = n3;
        }

        public int getOperationCount() {
            return this.operationCount;
        }

        public double getInsertRatio() {
            return this.insertRatio;
        }

        public int getMaxInsertLength() {
            return this.maxInsertLength;
        }

        public double getRemoveRatio() {
            return this.removeRatio;
        }

        public int getMaxRemoveLength() {
            return this.maxRemoveLength;
        }

        public String toString() {
            return "operationCount=" + this.getOperationCount() + ", insertRatio=" + this.getInsertRatio() + ", maxInsertLength=" + this.getMaxInsertLength() + ", removeRatio=" + this.getRemoveRatio() + ", maxRemoveLength=" + this.getMaxRemoveLength();
        }
    }

    public class TestString
    extends InsertTest {
        private final String s;

        public TestString(String string, double d) {
            super(d);
            this.s = string;
        }

        public String getString() {
            return this.s;
        }

        public String toString() {
            return "testString=\"" + LexerUtilities.toSource(this.getString()) + "\", " + super.toString();
        }
    }

    public class TestCharInterval
    extends TestChar {
        private final char lastChar;

        public TestCharInterval(char c, char c2, double d) {
            super(c, d);
            this.lastChar = c2;
        }

        public char getLastChar() {
            return this.lastChar;
        }

        public String toString() {
            return "<'" + LexerUtilities.toSource(this.getChar()) + "', '" + LexerUtilities.toSource(this.getLastChar()) + "'>, insertRatio=" + this.getInsertRatio();
        }
    }

    public class TestChar
    extends InsertTest {
        private final char c;

        public TestChar(char c, double d) {
            super(d);
            this.c = c;
        }

        public char getChar() {
            return this.c;
        }

        public String toString() {
            return "testChar='" + LexerUtilities.toSource(this.getChar()) + "', " + super.toString();
        }
    }

    private abstract class InsertTest {
        private final double insertRatio;

        InsertTest(double d) {
            this.insertRatio = d;
        }

        public double getInsertRatio() {
            return this.insertRatio;
        }

        public String toString() {
            return "insertRatio=" + this.getInsertRatio();
        }
    }
}

