/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remoteproject.panels.FTPPanelListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class FTPFSCreatePanel
extends JPanel {
    private final FTPPanelListener listener;
    private boolean autoSync = true;
    private boolean readOnly = false;
    private RemoteRuntimeType remoteRuntime = null;
    private boolean nonWizard = false;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;
    private JTextArea jTextArea4;
    private JTextArea jTextArea5;
    private JTextArea jTextArea6;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;

    public FTPFSCreatePanel(FTPPanelListener listener, RemoteRuntimeType remoteRuntime) {
        this.listener = listener;
        this.remoteRuntime = remoteRuntime;
        this.initComponents();
        this.setName(NbBundle.getMessage(FTPFSCreatePanel.class, (String)"TITLE_RemoteFTPSelectVisualPanel"));
    }

    public void disableAutoSync() {
        this.jCheckBox2.setEnabled(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextArea3 = new JTextArea();
        this.jPanel6 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextArea6 = new JTextArea();
        this.jTextField3 = new JTextField();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jTextArea4 = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jTextField4 = new JTextField();
        this.jCheckBox3 = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.jTextField5 = new JTextField();
        this.jCheckBox4 = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jTextArea2 = new JTextArea();
        this.jCheckBox2 = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jTextArea5 = new JTextArea();
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(500, 500));
        this.setPreferredSize(new Dimension(500, 500));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder(""));
        this.jPanel1.setPreferredSize(new Dimension(374, 30));
        this.jTextField1.setPreferredSize(new Dimension(200, 20));
        this.jTextField1.setAutoscrolls(false);
        this.jTextField1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                FTPFSCreatePanel.this.jTextField1KeyTyped(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FTPFSCreatePanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel3.setFont(new Font("MS Sans Serif", 1, 12));
        this.jLabel3.setText("Remote FTP Directory Root");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea3.setText("Choose a directory on the OpenVMS machine which the FTP Server will use as the root directory");
        this.jTextArea3.setBackground(new Color(236, 233, 216));
        this.jTextArea3.setLineWrap(true);
        this.jTextArea3.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jTextArea3, gridBagConstraints);
        this.add(this.jPanel1);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(new TitledBorder(""));
        this.jPanel6.setPreferredSize(new Dimension(374, 30));
        this.jLabel7.setFont(new Font("MS Sans Serif", 1, 12));
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("Local FTP Directory Root");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextArea6.setEditable(false);
        this.jTextArea6.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea6.setText("Choose a local storage directory for the remote files");
        this.jTextArea6.setBackground(new Color(236, 233, 216));
        this.jTextArea6.setLineWrap(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 5, 0);
        this.jPanel6.add((Component)this.jTextArea6, gridBagConstraints);
        this.jTextField3.setPreferredSize(new Dimension(200, 20));
        this.jTextField3.setAutoscrolls(false);
        this.jTextField3.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                FTPFSCreatePanel.this.jTextField3KeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 17, 0, 0);
        this.jPanel6.add((Component)this.jTextField3, gridBagConstraints);
        this.jButton2.setText("...");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FTPFSCreatePanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel6.add((Component)this.jButton2, gridBagConstraints);
        this.add(this.jPanel6);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder(""));
        this.jPanel2.setPreferredSize(new Dimension(294, 20));
        this.jCheckBox1.setFont(new Font("MS Sans Serif", 1, 12));
        this.jCheckBox1.setAlignmentY(0.0f);
        this.jCheckBox1.setHorizontalTextPosition(10);
        this.jCheckBox1.setIconTextGap(73);
        this.jCheckBox1.setLabel("Read-Only");
        this.jCheckBox1.setMargin(new Insets(2, 0, 2, 2));
        this.jCheckBox1.setVerifyInputWhenFocusTarget(false);
        this.jCheckBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FTPFSCreatePanel.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.jPanel2.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jTextArea4.setBackground(new Color(236, 233, 216));
        this.jTextArea4.setEditable(false);
        this.jTextArea4.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea4.setLineWrap(true);
        this.jTextArea4.setText("If this will be a read-only filesystem, check this box");
        this.jTextArea4.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 5, 0);
        this.jPanel2.add((Component)this.jTextArea4, gridBagConstraints);
        this.add(this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(new EtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(294, 20));
        this.jTextArea1.setBackground(new Color(236, 233, 216));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText("The default FTP TCP/IP port is 21. To use a different port for communications,  specify it here");
        this.jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(19, 4, 0, 0);
        this.jPanel3.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextField2.setText("21");
        this.jTextField2.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(4, 80, 23, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.jPanel3.add((Component)this.jTextField2, gridBagConstraints);
        this.jLabel4.setFont(new Font("MS Sans Serif", 1, 12));
        this.jLabel4.setText(" FTP Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 3, 22, 0);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.add(this.jPanel3);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel7.setBorder(new EtchedBorder());
        this.jPanel7.setPreferredSize(new Dimension(294, 20));
        this.jPanel7.setMinimumSize(new Dimension(294, 20));
        this.jTextField4.setBackground(new Color(236, 233, 216));
        this.jTextField4.setFont(new Font("SansSerif", 0, 12));
        this.jTextField4.setText("If the FTP port chosen is forwarded to an SSH tunnel, specify it here");
        this.jTextField4.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.jPanel7.add((Component)this.jTextField4, gridBagConstraints);
        this.jCheckBox3.setFont(new Font("SansSerif", 1, 12));
        this.jCheckBox3.setText("FTP Port Forwarded");
        this.jCheckBox3.setIconTextGap(16);
        this.jCheckBox3.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.jPanel7.add((Component)this.jCheckBox3, gridBagConstraints);
        this.add(this.jPanel7);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(new EtchedBorder());
        this.jPanel8.setPreferredSize(new Dimension(486, 15));
        this.jPanel8.setMinimumSize(new Dimension(106, 15));
        this.jTextField5.setFont(new Font("SansSerif", 0, 12));
        this.jTextField5.setText("If passive FTP mode should be used, specify it here (recommended)");
        this.jTextField5.setBackground(new Color(236, 233, 216));
        this.jTextField5.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.jPanel8.add((Component)this.jTextField5, gridBagConstraints);
        this.jCheckBox4.setFont(new Font("SansSerif", 1, 12));
        this.jCheckBox4.setSelected(true);
        this.jCheckBox4.setText("Passive FTP");
        this.jCheckBox4.setIconTextGap(58);
        this.jCheckBox4.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 0, 0);
        this.jPanel8.add((Component)this.jCheckBox4, gridBagConstraints);
        this.add(this.jPanel8);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder(""));
        this.jPanel4.setPreferredSize(new Dimension(284, 20));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea2.setText("Auto Sync will automatically keep files on the client and server synchronized");
        this.jTextArea2.setBackground(new Color(236, 233, 216));
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 3, 0);
        this.jPanel4.add((Component)this.jTextArea2, gridBagConstraints);
        this.jCheckBox2.setFont(new Font("MS Sans Serif", 1, 12));
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("Auto Sync");
        this.jCheckBox2.setHorizontalTextPosition(10);
        this.jCheckBox2.setIconTextGap(70);
        this.jCheckBox2.setMargin(new Insets(2, 0, 2, 2));
        this.jCheckBox2.setVerifyInputWhenFocusTarget(false);
        this.jCheckBox2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FTPFSCreatePanel.this.jCheckBox2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.jPanel4.add((Component)this.jCheckBox2, gridBagConstraints);
        this.add(this.jPanel4);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new TitledBorder(""));
        this.jPanel5.setPreferredSize(new Dimension(284, 20));
        this.jTextArea5.setBackground(new Color(236, 233, 216));
        this.jTextArea5.setEditable(false);
        this.jTextArea5.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea5.setLineWrap(true);
        this.jTextArea5.setText("Once the filesystem is mounted, you can change the above properties (along with other properties) by right mouse clicking on the file system node on NetBeans Filesystems Explorer");
        this.jTextArea5.setWrapStyleWord(true);
        this.jTextArea5.setPreferredSize(new Dimension(400, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.jPanel5.add((Component)this.jTextArea5, gridBagConstraints);
        this.add(this.jPanel5);
    }

    private void jTextField3KeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FTPFSCreatePanel.this.listener.fireChangeState();
            }
        });
    }

    private void jTextField1KeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FTPFSCreatePanel.this.listener.fireChangeState();
            }
        });
    }

    private void jCheckBox2ItemStateChanged(ItemEvent evt) {
        this.autoSync = evt.getStateChange() == 1;
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        this.readOnly = evt.getStateChange() == 1;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        JFileChooser jChooser = FileEditor.createHackedFileChooser();
        jChooser.setFileSelectionMode(1);
        jChooser.setDialogTitle("Local FTP Directory Root");
        if (jChooser.showDialog(WindowManager.getDefault().getMainWindow(), "Select") == 0) {
            this.jTextField3.setText(jChooser.getSelectedFile().getAbsolutePath());
            if (!this.listener.isValidLocal()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The selected FTP local root directory does not exist or is already being used\nas the local root directory for another FTP file system.\nPlease choose a different FTP local root directory or\nunmount the filesystem that is using the selected directory", 2));
            } else if (jChooser.getSelectedFile().list().length > 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The selected FTP local root folder is not empty.  If you select this folder,\nthe files and subfolders in this folder will be copied to\nyour remote directory on the OpenVMS machine.", 2));
            }
        }
        this.listener.fireChangeState();
    }

    public int getFTPPort() {
        try {
            return Integer.parseInt(this.jTextField2.getText());
        }
        catch (NumberFormatException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)e, (Object)("FTP Port Number is Invalid: " + e.getMessage())));
            return -1;
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        FileEditor.RemoteFileSystemView rfv = new FileEditor.RemoteFileSystemView(this.remoteRuntime);
        JFileChooser jChooser = FileEditor.createHackedFileChooser(rfv);
        jChooser.setFileSelectionMode(1);
        jChooser.setDialogTitle("Remote FTP Directory Root");
        if (jChooser.showDialog(WindowManager.getDefault().getMainWindow(), "Select") == 0) {
            this.jTextField1.setText(jChooser.getSelectedFile().getName());
            this.listener.fireChangeState();
        }
    }

    public String getRemoteFTPRoot() {
        return this.jTextField1.getText();
    }

    public String getLocalCacheRoot() {
        return this.jTextField3.getText();
    }

    public Boolean getAutoSync() {
        return new Boolean(this.autoSync);
    }

    public Boolean getReadOnly() {
        return new Boolean(this.readOnly);
    }

    public Integer getFTPPortValue() {
        return new Integer(this.getFTPPort());
    }

    public Boolean getUsePassiveMode() {
        return new Boolean(this.jCheckBox4.isSelected());
    }

    public Boolean getUseSSHForwarding() {
        return new Boolean(this.jCheckBox3.isSelected());
    }
}

