/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootJPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootVisualPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import patchsources.OpenProjectList_Dist;

public class RemoteMultipleRootPanel
extends RemoteRootPanel
implements WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    protected ArrayList rootsHistory;
    private String projectDirectory;
    private String remoteDirectory;
    protected int panelIndex;
    private boolean editable;
    public static final String WIZARD_KEY_TARGET_FOLDER = "targetFolder";
    public static final String WIZARD_KEY_TARGET_NAME = "targetName";

    public RemoteMultipleRootPanel(String projectDirectory, String title, int panelIndex, boolean editable) {
        this.panelIndex = panelIndex;
        this.projectDirectory = projectDirectory;
        this.editable = editable;
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteRootVisualPanel(this, false, this.editable);
        }
        return this.component;
    }

    public boolean hideFS() {
        return ((RemoteRootJPanel)this.component).isHideChecked();
    }

    public boolean isValid() {
        if (!((RemoteRootVisualPanel)this.getComponent()).getLocalDirectory().equals("") && !((RemoteRootVisualPanel)this.getComponent()).getRemoteDirectory().equals("")) {
            Enumeration fse = Repository.getDefault().getFileSystems();
            while (fse.hasMoreElements()) {
                String lroot;
                FileSystem fs = (FileSystem)fse.nextElement();
                if (!(fs instanceof LocalFileSystem) || fs instanceof NetworkFileSystem || !(lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(((RemoteRootVisualPanel)this.getComponent()).getLocalDirectory())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void readSettings(Object settings) {
        super.readSettings(settings);
        WizardDescriptor wiz = (WizardDescriptor)settings;
        if (!this.editable) {
            this.remoteDirectory = this.getRemoteDirectory(this.projectDirectory);
            ((RemoteRootVisualPanel)this.component).getFileChooser().setCurrentDirectory(new File(this.projectDirectory));
            ((RemoteRootVisualPanel)this.component).getTextField().setText(this.remoteDirectory);
            this.fireChangeState();
        }
        this.rootsHistory = (ArrayList)wiz.getProperty("remotefs_list");
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("remote_directory", ((RemoteRootVisualPanel)this.component).getRemoteDirectory());
        map.put("local_directory", ((RemoteRootVisualPanel)this.component).getLocalDirectory());
        if (this.isValid()) {
            ArrayList<HashMap<String, String>> list = (ArrayList<HashMap<String, String>>)wiz.getProperty("remotefs_list");
            if (list == null) {
                list = new ArrayList<HashMap<String, String>>();
                list.add(this.panelIndex, map);
                wiz.putProperty("remotefs_list", list);
                ProjectChooser.setProjectsFolder((File)new File(((RemoteRootVisualPanel)this.component).getLocalDirectory()));
            } else {
                if (this.panelIndex < list.size() && list.get(this.panelIndex) != null) {
                    list.remove(this.panelIndex);
                }
                list.add(this.panelIndex, map);
                wiz.putProperty("remotefs_list", list);
            }
        }
    }

    public boolean isValidLocal() {
        String localCache = ((RemoteRootVisualPanel)this.component).getLocalDirectory();
        if (localCache == null || localCache.length() == 0) {
            return false;
        }
        if (!new File(localCache).exists()) {
            return false;
        }
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            String lroot;
            if (!(fs instanceof LocalFileSystem && !(fs instanceof AbstractNetworkFileSystem) ? (lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(localCache) : fs instanceof AbstractNetworkFileSystem && (lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(localCache))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidLocal(String r1, String r2) {
        if (r1.equalsIgnoreCase(r2)) {
            return false;
        }
        if (r1.length() < r2.length()) {
            if (r1.charAt(r1.length() - 1) == File.separatorChar) {
                r1 = r1.substring(0, r1.length() - 1);
            }
            if (r2.toUpperCase().indexOf(r1.toUpperCase()) == 0 && r2.charAt(r1.length()) == File.separatorChar) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidRemote(String r1, String r2) {
        if (r1.equalsIgnoreCase(r2)) {
            return false;
        }
        if (r1.length() < r2.length()) {
            if (r1.indexOf(93) != -1) {
                r1 = r1.substring(0, r1.indexOf(93));
            }
            if (r2.toUpperCase().indexOf(r1.toUpperCase()) == 0 && (r2.charAt(r1.length()) == '.' || r2.charAt(r1.length()) == ']')) {
                return false;
            }
        }
        return true;
    }

    public boolean isInRootsHistory(String r, String l) {
        if (this.rootsHistory != null) {
            for (int i = 0; i < this.rootsHistory.size(); ++i) {
                if (i == this.panelIndex) continue;
                Map map = (Map)this.rootsHistory.get(i);
                String rRoot = ((String)map.get("remote_directory")).toUpperCase();
                String lRoot = ((String)map.get("local_directory")).toUpperCase();
                if (rRoot.trim().length() == 0 || lRoot.trim().length() == 0 || this.isValidRemote(rRoot, r) && this.isValidRemote(r, rRoot) && this.isValidLocal(lRoot, l) && this.isValidLocal(l, lRoot)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidPath() throws WizardValidationException {
        String localCache = ((RemoteRootVisualPanel)this.component).getLocalDirectory();
        String remoteRoot = ((RemoteRootVisualPanel)this.component).getRemoteDirectory();
        if (localCache == null || localCache.length() == 0 || remoteRoot == null || remoteRoot.length() == 0) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"));
        }
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            String lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot().toUpperCase();
            String rroot = ((AbstractNetworkFileSystem)fs).getRemoteRoot().toUpperCase();
            if (this.isValidLocal(lroot, localCache.toUpperCase()) && this.isValidRemote(rroot, remoteRoot.toUpperCase())) continue;
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_PROJECT"));
        }
        if (this.isInRootsHistory(remoteRoot.toUpperCase(), localCache.toUpperCase())) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_PROJECT"));
        }
        return true;
    }

    public void validate() throws WizardValidationException {
        this.isValidPath();
    }

    public boolean isFinishPanel() {
        return this.editable;
    }
}

