/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class ConnectAction
extends NodeAction {
    static final long serialVersionUID = -7910677883191530621L;
    private RemoteFileSystem fs = null;

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        DataFolder df = (DataFolder)nodes[0].getCookie(DataFolder.class);
        if (df != null && nodes.length == 1) {
            FileObject fo = df.getPrimaryFile();
            return fo.isRoot();
        }
        return false;
    }

    protected void performAction(Node[] nodes) {
        DataFolder df = (DataFolder)nodes[0].getCookie(DataFolder.class);
        if (df != null) {
            FileObject fo = df.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                FTPClient.removeFromFailedAttempts(((FTPFileSystem)fs).getServer(), ((FTPFileSystem)fs).getUsername());
                if (fs instanceof RemoteFileSystem) {
                    if (!((RemoteFileSystem)fs).isConnected()) {
                        ((RemoteFileSystem)fs).connectOnBackground();
                    } else {
                        ((RemoteFileSystem)fs).disconnectOnBackground();
                    }
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void setFS(RemoteFileSystem fs) {
        this.fs = fs;
    }

    public String getName() {
        if (this.fs == null) {
            return "Connect/Disconnect";
        }
        if (this.fs.isConnected()) {
            return "Go Offline";
        }
        return "Go Online";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }
}

