/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.exesupport.ExeDataLoader;
import com.hp.openvms.netbeans.exesupport.ExeDataNode;
import com.hp.openvms.netbeans.exesupport.RemotePropertiesAction;
import com.hp.openvms.netbeans.exesupport.RemoteWatchListCookie;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.distributed.common.cookies.RemotePropertyCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;

public class ExeDataObject
extends MultiDataObject {
    private static final String WATCH_LIST = "WATCH_LIST";
    PropertyChangeListener listener;
    private List remoteWatchList;
    Map remoteWatchValue;

    public ExeDataObject(FileObject pf, ExeDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)new RemotePropertyCookie(){

            public void operations(Node[] activatedNodes) {
                RemotePropertiesAction.doAction(activatedNodes);
            }
        });
        cookies.add((Node.Cookie)new RemoteWatchListCookie(){
            RemoteDebugger debug;

            public List getRemoteWatchList() {
                return ExeDataObject.this.remoteWatchList;
            }

            public List updateWatchList() {
                ExeDataObject.this.remoteWatchList = Collections.synchronizedList(new WatchList());
                return ExeDataObject.this.remoteWatchList;
            }

            public List addToRemoteWatchList(String watch) {
                ExeDataObject.this.remoteWatchList.add(watch);
                ExeDataObject.this.remoteWatchValue.put(watch, "");
                if (this.debug != null && this.debug.getState() != "state_none") {
                    this.debug.setWatch(watch);
                }
                ExeDataObject.this.fireRemoteWatchChange(this.debug);
                return ExeDataObject.this.remoteWatchList;
            }

            public void deleteFromRemoteWatchList(String watch) {
                ExeDataObject.this.remoteWatchList.remove(watch);
                ExeDataObject.this.remoteWatchValue.remove(watch);
                ExeDataObject.this.fireRemoteWatchChange(null);
            }

            public Map getExprWatchMap() {
                return ExeDataObject.this.remoteWatchValue;
            }

            public void updateRemoteWatchModel(RemoteDebugger remoteDebugger) {
                ExeDataObject.this.fireRemoteWatchChange(remoteDebugger);
                this.debug = remoteDebugger;
            }
        });
        this.remoteWatchList = Collections.synchronizedList(new WatchList());
    }

    public void addViewModelListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    private void fireRemoteWatchChange(RemoteDebugger remoteDebugger) {
        if (this.listener != null) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, "REMOTE_WATCH_CHANGE", remoteDebugger, null);
            this.listener.propertyChange(pe);
        }
    }

    protected Node createNodeDelegate() {
        return new ExeDataNode(this);
    }

    class WatchList
    extends LinkedList {
        public WatchList() {
            FileObject fobj = ExeDataObject.this.getPrimaryFile();
            ExeDataObject.this.remoteWatchValue = new HashMap();
            List remoteWatchList = (List)fobj.getAttribute(ExeDataObject.WATCH_LIST);
            if (remoteWatchList == null) {
                return;
            }
            for (String remoteWatchExpression : remoteWatchList) {
                super.add(remoteWatchExpression);
                ExeDataObject.this.remoteWatchValue.put(remoteWatchExpression, "");
            }
        }

        public boolean add(Object o) {
            try {
                boolean ret = false;
                if (!super.contains(o)) {
                    ret = super.add(o);
                    FileObject fobj = ExeDataObject.this.getPrimaryFile();
                    fobj.setAttribute(ExeDataObject.WATCH_LIST, (Object)this);
                }
                return ret;
            }
            catch (IOException e) {
                return false;
            }
        }

        public void add(int index, Object o) {
            try {
                boolean ret = false;
                if (!super.contains(o)) {
                    super.add(index, o);
                    FileObject fobj = ExeDataObject.this.getPrimaryFile();
                    fobj.setAttribute(ExeDataObject.WATCH_LIST, (Object)this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean remove(Object o) {
            try {
                boolean ret = false;
                if (super.contains(o)) {
                    ret = super.remove(o);
                    FileObject fobj = ExeDataObject.this.getPrimaryFile();
                    fobj.setAttribute(ExeDataObject.WATCH_LIST, (Object)this);
                }
                return ret;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

