/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.basic.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.MyPropertiesAction;
import com.hp.openvms.netbeans.baseclasses.dataloaders.AlphaVMSDataLoader;
import com.hp.openvms.netbeans.basicsupport.BasicConstants;
import com.hp.openvms.netbeans.basicsupport.basic.datasys.BasicDataObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.openide.actions.BuildAction;
import org.openide.actions.CompileAction;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class BasicDataLoader
extends AlphaVMSDataLoader {
    private static final int EXTERNALIZED_VERSION = 1;
    public static final String PROP_BASIC_EXTENSIONS = "basicExtensions";
    public static final String PROP_PERFECT_RECOGNITION = "perfectRecognition";
    public static final String REQUIRED_MIME = "text/x-hp+openvms+bas";
    private static ResourceBundle bundle;

    public BasicDataLoader() {
        super("com.hp.openvms.netbeans.basicsupport.basic.datasys.BasicDataObject");
    }

    public BasicDataLoader(String recognizedObject) {
        super(recognizedObject);
    }

    public BasicDataLoader(Class recognizedObject) {
        super(recognizedObject);
    }

    protected String actionsContext() {
        return "Loaders/text/x-hp+openvms+bas/Actions";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(BasicDataLoader.class, (String)"LBL_loaderName");
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(BasicDataLoader.class);
        }
        return bundle.getString(name);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(EditAction.class), SystemAction.get(FileSystemAction.class), null, SystemAction.get(CompileAction.class), SystemAction.get(BuildAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(SaveAsTemplateAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(MyPropertiesAction.class)};
    }

    public ExtensionList getBasicExtensions() {
        ExtensionList extensions = (ExtensionList)this.getProperty(PROP_BASIC_EXTENSIONS);
        if (extensions == null) {
            extensions = new ExtensionList();
            for (int i = 0; i < BasicConstants.BASIC_EXTENSIONS.length; ++i) {
                extensions.addExtension(BasicConstants.BASIC_EXTENSIONS[i]);
            }
            this.putProperty(PROP_BASIC_EXTENSIONS, extensions, false);
        }
        return extensions;
    }

    public void setBasicExtensions(ExtensionList ext) {
        this.putProperty(PROP_BASIC_EXTENSIONS, ext, true);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
        out.writeObject(this.getProperty(PROP_BASIC_EXTENSIONS));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.available() > 0) {
            int v = in.readInt();
            this.putProperty(PROP_BASIC_EXTENSIONS, in.readObject(), false);
        }
    }

    private FileObject findBrotherCaseInsensitive(FileObject fo, String ext) {
        if (fo == null) {
            return null;
        }
        FileObject parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        FileObject[] fobjs = parent.getChildren();
        for (int i = 0; i < fobjs.length; ++i) {
            if (fobjs[i].getExt() == null) continue;
            StringBuffer sb = new StringBuffer(fo.getName().length() + 1 + (ext == null ? 0 : ext.length()));
            sb.append(fo.getName()).append(".").append(ext);
            if (!fobjs[i].getNameExt().equalsIgnoreCase(sb.toString())) continue;
            return fobjs[i];
        }
        return null;
    }

    private FileObject findBrother(Enumeration itr, FileObject fo) {
        while (itr.hasMoreElements()) {
            String ext = (String)itr.nextElement();
            FileObject foBro = this.findBrotherCaseInsensitive(fo, ext);
            if (foBro == null) continue;
            return foBro;
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (this.getObjExtensions().isRegistered(fo)) {
            Enumeration itr = this.getBasicExtensions().extensions();
            FileObject fobj = null;
            fobj = this.findBrother(itr, fo);
            if (fobj != null) {
                return fobj;
            }
            return null;
        }
        if (this.getBasicExtensions().isRegistered(fo)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        String extension = primaryFile.getExt();
        if (this.getBasicExtensions().isRegistered(extension)) {
            return new BasicDataObject(primaryFile, this);
        }
        return null;
    }
}

