/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import com.hp.openvms.netbeans.basicsupport.basic.BasicCompilerType;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.cc.CCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.cpp.CppCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.DCLCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.MMSCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.SHCompilerType;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompilerType;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remoteproject.RemoteProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import patchsources.OpenProjectList_Dist;

public class RemoteProjectSettingsImpl
implements RemoteProjectSettings {
    private Map settings;
    private final String[] executors = new String[]{"cpp", "c", "basic", "cobol", "fortran", "pascal", "dcl", "mms", "sh", "ant"};
    private boolean executorsValid = false;
    private Project project;

    public RemoteProjectSettingsImpl(Project project) {
        this.project = project;
        this.settings = new HashMap();
    }

    public Object getCompilerSettings(String cType) {
        return this.settings.get(cType);
    }

    public void refresh(String cType) {
        if (this.settings != null) {
            this.settings.remove(cType);
        }
        FileObject pdir = this.project.getProjectDirectory();
        if (cType.equals("cpp")) {
            this.settings.put("cpp", new CppCompilerType(pdir));
        } else if (cType.equals("c")) {
            this.settings.put("c", new CCompilerType(pdir));
        } else if (cType.equals("basic")) {
            this.settings.put("basic", new BasicCompilerType(pdir));
        } else if (cType.equals("cobol")) {
            this.settings.put("cobol", new CobolCompilerType(pdir));
        } else if (cType.equals("fortran")) {
            this.settings.put("fortran", new FortranCompilerType(pdir));
        } else if (cType.equals("pascal")) {
            this.settings.put("pascal", new PascalCompilerType(pdir));
        } else if (cType.equals("dcl")) {
            this.settings.put("dcl", new DCLCompilerType(pdir));
        } else if (cType.equals("sh")) {
            this.settings.put("sh", new SHCompilerType(pdir));
        } else if (cType.equals("mms")) {
            this.settings.put("mms", new MMSCompilerType(pdir));
        } else if (cType.equals("ant")) {
            this.settings.put("ant", new RemoteAntExecutor(pdir));
        } else if (cType.equals("remote_fs")) {
            List list = OpenProjectList_Dist.filterURL(FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath());
            this.settings.put("remote_fs", list);
        }
    }

    public void flush(String cType) throws IOException {
        if (cType.equals("cpp")) {
            ((CppCompilerType)((Object)this.settings.get("cpp"))).flushSettings();
        } else if (cType.equals("c")) {
            ((CCompilerType)((Object)this.settings.get("c"))).flushSettings();
        } else if (cType.equals("basic")) {
            ((BasicCompilerType)((Object)this.settings.get("basic"))).flushSettings();
        } else if (cType.equals("cobol")) {
            ((CobolCompilerType)((Object)this.settings.get("cobol"))).flushSettings();
        } else if (cType.equals("fortran")) {
            ((FortranCompilerType)((Object)this.settings.get("fortran"))).flushSettings();
        } else if (cType.equals("pascal")) {
            ((PascalCompilerType)((Object)this.settings.get("pascal"))).flushSettings();
        } else if (cType.equals("dcl")) {
            ((DCLCompilerType)((Object)this.settings.get("dcl"))).flushSettings();
        } else if (cType.equals("sh")) {
            ((SHCompilerType)((Object)this.settings.get("sh"))).flushSettings();
        } else if (cType.equals("mms")) {
            ((MMSCompilerType)((Object)this.settings.get("mms"))).flushSettings();
        } else if (cType.equals("ant")) {
            ((RemoteAntExecutor)this.settings.get("ant")).flushSettings();
        } else if (cType.equals("remote_fs")) {
            List fss = (List)this.settings.get("remote_fs");
            List rfss = null;
            rfss = this.project instanceof RemoteProject ? ((RemoteProject)this.project).getRoots() : Utils.findProjectRoots(this.project);
            for (int i = 0; i < fss.size(); ++i) {
                Utils.writeFSto3GLXML((FileSystem)fss.get(i), this.project);
                String pRoot = FileUtil.toFile((FileObject)((FileSystem)fss.get(i)).getRoot()).getAbsolutePath();
                for (int j = 0; j < rfss.size(); ++j) {
                    AbstractNetworkFileSystem tf;
                    AbstractNetworkFileSystem sf;
                    String root;
                    if (rfss.get(j) instanceof FTPFileSystem) {
                        root = FileUtil.toFile((FileObject)((FileSystem)rfss.get(j)).getRoot()).getAbsolutePath();
                        if (!pRoot.equalsIgnoreCase(root)) continue;
                        sf = (FTPFileSystem)fss.get(i);
                        tf = (FTPFileSystem)rfss.get(j);
                        ((FTPFileSystem)tf).copyReadableProps((FTPFileSystem)sf);
                        continue;
                    }
                    root = FileUtil.toFile((FileObject)((FileSystem)rfss.get(j)).getRoot()).getAbsolutePath();
                    if (!pRoot.equalsIgnoreCase(root)) continue;
                    sf = (NetworkFileSystem)fss.get(i);
                    tf = (NetworkFileSystem)rfss.get(j);
                    ((NetworkFileSystem)tf).copyReadableProps((NetworkFileSystem)sf);
                }
            }
        }
    }

    public void refreshAll() {
        if (this.executorsValid) {
            return;
        }
        for (int i = 0; i < this.executors.length; ++i) {
            this.refresh(this.executors[i]);
        }
        this.executorsValid = true;
    }
}

