/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.utils;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteJarFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkJarFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public final class FileUtilityLang
extends FileUtility {
    public static String __winPathToOpenVMSPath(String winPath, boolean isDir) {
        int fsIndex = 0;
        FileObject[] fobjs = FileUtil.fromFile((File)new File(winPath));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof AbstractNetworkFileSystem)) continue;
                fsIndex = i;
                break;
            }
            catch (FileStateInvalidException fse) {
                // empty catch block
            }
        }
        if (fobjs.length > 0) {
            return FileUtilityLang._winPathToOpenVMSPath(winPath, isDir, fobjs[fsIndex]);
        }
        return winPath;
    }

    public static String _winPathToOpenVMSPath(String winPath, boolean isDir, FileObject fobj) {
        String vmsPath = winPath;
        try {
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fobj.getFileSystem();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("REMOTE_ROOT", nfs.getRemoteRoot());
            map.put("LCOAL_ROOT", nfs.getLocalRoot());
            vmsPath = FileUtility.winPathToOpenVMSPath(winPath, isDir, map);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vmsPath;
    }

    public static String __unixPathToOpenVMSPath(String unixPath, boolean isDir) {
        FileObject[] fobjs = FileUtil.fromFile((File)new File(unixPath));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof AbstractNetworkFileSystem) && !(fobjs[i].getFileSystem() instanceof NetworkJarFileSystem)) continue;
                return FileUtilityLang.unixPathToOpenVMSPath(unixPath, isDir, fobjs[i]);
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        Enumeration jarFs = Repository.getDefault().getFileSystems();
        while (jarFs.hasMoreElements()) {
            NetworkJarFileSystem njfs;
            Object obj = jarFs.nextElement();
            if (!(obj instanceof NetworkJarFileSystem) || !unixPath.equals((njfs = (NetworkJarFileSystem)obj).getJarFile().getAbsolutePath())) continue;
            return FileUtilityLang.unixPathToOpenVMSPath(unixPath, false, njfs.getRoot());
        }
        return unixPath;
    }

    public static String unixPathToOpenVMSPath(String unixPath, boolean isDir, FileObject fobj) {
        String vmsPath = unixPath;
        try {
            String localRelPath;
            String unixRoot;
            AbstractNetworkFileSystem nfs;
            HashMap map = new HashMap();
            if (fobj.getFileSystem() instanceof AbstractNetworkFileSystem) {
                nfs = (AbstractNetworkFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(nfs.getRemoteRoot(), true);
                localRelPath = vmsPath.substring(nfs.getLocalRoot().length());
            } else {
                nfs = (NetworkJarFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(((RemoteJarFileSystem)nfs).getRemoteJarRoot().getRemoteJarRoot(), true);
                localRelPath = vmsPath.substring(nfs.getJarFile().getAbsolutePath().length());
            }
            String tmpPath = unixRoot + (localRelPath.indexOf(47) == 0 ? "" : "/") + localRelPath;
            vmsPath = FileUtility.unixPathToOpenVMSPath(tmpPath, isDir);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vmsPath;
    }
}

