/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.MyPropertiesAction;
import com.hp.openvms.netbeans.baseclasses.dataloaders.AlphaVMSDataLoader;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataObject;
import com.hp.openvms.netbeans.utils.Constants;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.openide.actions.BuildAction;
import org.openide.actions.CompileAction;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class FortranDataLoader
extends AlphaVMSDataLoader {
    private static final int EXTERNALIZED_VERSION = 1;
    public static final String PROP_FORTRAN_EXTENSIONS = "fortranExtensions";
    public static final String REQUIRED_MIME = "text/x-hp+openvms+for";
    private static ResourceBundle bundle;

    public FortranDataLoader() {
        super("com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataObject");
    }

    public FortranDataLoader(Class recognizedObject) {
        super(recognizedObject);
    }

    protected String actionsContext() {
        return "Loaders/text/x-hp+openvms+for/Actions";
    }

    protected void initialize() {
        super.initialize();
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(FortranDataLoader.class, (String)"LBL_loaderName");
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(FortranDataLoader.class);
        }
        return bundle.getString(name);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(EditAction.class), SystemAction.get(FileSystemAction.class), null, SystemAction.get(CompileAction.class), SystemAction.get(BuildAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(SaveAsTemplateAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(MyPropertiesAction.class)};
    }

    public ExtensionList getFortranExtensions() {
        ExtensionList extensions = (ExtensionList)this.getProperty(PROP_FORTRAN_EXTENSIONS);
        if (extensions == null) {
            extensions = new ExtensionList();
            for (int i = 0; i < Constants.FORTRAN_EXTENSIONS.length; ++i) {
                extensions.addExtension(Constants.FORTRAN_EXTENSIONS[i]);
            }
            this.putProperty(PROP_FORTRAN_EXTENSIONS, extensions, false);
        }
        return extensions;
    }

    public void setFortranExtensions(ExtensionList ext) {
        this.putProperty(PROP_FORTRAN_EXTENSIONS, ext, true);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
        out.writeObject(this.getProperty(PROP_FORTRAN_EXTENSIONS));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.available() > 0) {
            int v = in.readInt();
            this.putProperty(PROP_FORTRAN_EXTENSIONS, in.readObject(), false);
        }
    }

    private FileObject findBrother(Enumeration itr, FileObject fo) {
        while (itr.hasMoreElements()) {
            String ext = (String)itr.nextElement();
            FileObject foBro = FileUtil.findBrother((FileObject)fo, (String)ext);
            if (foBro == null) continue;
            return foBro;
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (this.getFortranExtensions().isRegistered(fo)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        String extension = primaryFile.getExt();
        if (this.getFortranExtensions().isRegistered(extension)) {
            return new FortranDataObject(primaryFile, this);
        }
        return null;
    }
}

