/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.exesupport.RemoteWatchListCookie;
import com.hp.openvms.netbeans.exesupport.WatchPanel;
import java.awt.Dialog;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;

public final class RemoteWatchAction
extends CookieAction {
    private static String watchHistory = "";
    RemoteDebugger remoteDebugger;

    protected void performAction(Node[] activatedNodes) {
        final Node[] nodes = activatedNodes;
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RemoteDebugger.showWatchesView(nodes);
                RemoteWatchAction.doExecuteAction(nodes);
            }
        });
    }

    public static void doExecuteAction(Node[] activatedNodes) {
        ResourceBundle bundle = NbBundle.getBundle(RemoteWatchAction.class);
        WatchPanel wp = new WatchPanel(watchHistory);
        JComponent panel = wp.getPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, "New Watch", true, 2, null, 0, new HelpCtx("debug.add.watch"), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        try {
            dialog.setVisible(true);
        }
        catch (IllegalStateException i) {
            System.out.println("Illigal state exception");
        }
        dialog.dispose();
        if (dd.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        String watch = wp.getExpression();
        if (watch == null || watch.trim().length() == 0) {
            return;
        }
        String s = watch;
        watchHistory = watch;
        DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        RemoteWatchListCookie rwl = (RemoteWatchListCookie)dobj.getCookie(RemoteWatchListCookie.class);
        rwl.addToRemoteWatchList(s);
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return "Add Remote Watch";
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isEnable(Node[] node) {
        return true;
    }

    protected boolean enable(Node[] node) {
        return RemoteWatchAction.isEnable(node);
    }
}

