/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;

public abstract class RemoteBreakpoint
extends Breakpoint {
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final String PROP_BREAKPOINT_STATE = "breakpointState";
    public static final int MIN_GDB_ID = 500;
    public static final int UNVALIDATED = 0;
    public static final int VALIDATION_PENDING = 1;
    public static final int VALIDATED = 2;
    public static final int DELETION_PENDING = 3;
    public Object annotation = null;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend = 0;
    private int breakpointNumber;
    private String printText;
    private HashSet breakpointListeners = new HashSet();
    private int state = 0;
    private static Map pending = Collections.synchronizedMap(new HashMap());
    private static Map bplist = Collections.synchronizedMap(new HashMap());
    private RemoteDebugger debugger;
    private Object LOCK = new Object();
    private int id;
    private static int nextid = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setID() {
        Object object = this.LOCK;
        synchronized (object) {
            this.id = ++nextid;
        }
    }

    public int getID() {
        return this.id;
    }

    public static RemoteBreakpoint get(String breakpointNumber) {
        return (RemoteBreakpoint)((Object)bplist.get(breakpointNumber));
    }

    public static RemoteBreakpoint getPending(int id) {
        return (RemoteBreakpoint)((Object)pending.get(id));
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        if (state != this.state && (state == 0 || state == 1 || state == 2 || state == 3)) {
            this.state = state;
            if (state == 0) {
                this.breakpointNumber = -1;
            }
        }
    }

    public void setPending() {
        this.setState(1);
        pending.put(this.id, this);
    }

    public void setValidationResult(int id, String breakpointNumber) {
        assert (id == this.getID());
        if (breakpointNumber != null) {
            this.breakpointNumber = Integer.parseInt(breakpointNumber);
            this.setState(2);
            if (!this.isEnabled()) {
                this.debugger.break_disable(this.breakpointNumber);
            }
        } else {
            this.setState(0);
        }
        bplist.put(breakpointNumber, this);
        pending.remove(id);
        if (pending.size() == 0 && this.debugger.getState() == "state_loading") {
            this.debugger.setRunning();
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        if (s == this.suspend) {
            return;
        }
        int old = this.suspend;
        this.suspend = s;
        this.firePropertyChange(PROP_SUSPEND, new Integer(old), new Integer(s));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        if (h == this.hidden) {
            return;
        }
        boolean old = this.hidden;
        this.hidden = h;
        this.firePropertyChange(PROP_HIDDEN, old, h);
    }

    public int getBreakpointNumber() {
        return this.breakpointNumber;
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        if (this.printText == printText) {
            return;
        }
        String old = this.printText;
        this.printText = printText;
        this.firePropertyChange(PROP_PRINT_TEXT, old, printText);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized void addRemoteBreakpointListener(RemoteBreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public synchronized void removeRemoteBreakpointListener(RemoteBreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    public void fireRemoteBreakpointChange(RemoteBreakpointEvent event) {
        Iterator i = ((HashSet)this.breakpointListeners.clone()).iterator();
        while (i.hasNext()) {
            ((RemoteBreakpointListener)i.next()).breakpointReached(event);
        }
    }

    protected void setDebugger(RemoteDebugger debugger) {
        this.debugger = debugger;
    }

    public RemoteDebugger getDebugger() {
        return this.debugger;
    }
}

