/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import org.netbeans.api.debugger.Properties;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{RemoteBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        RemoteBreakpoint b = null;
        if (typeID.equals(LineBreakpoint.class.getName()) || typeID.equals(LineBreakpoint.class.getName() + "$LineBreakpointComparable")) {
            LineBreakpoint lb = LineBreakpoint.create(properties.getString("url", null), properties.getInt("lineNumber", 1));
            lb.setCondition(properties.getString("condition", ""));
            b = lb;
        }
        if (typeID.equals(FunctionBreakpoint.class.getName()) || typeID.equals(FunctionBreakpoint.class.getName() + "$FunctionBreakpointComparable")) {
            FunctionBreakpoint fb = FunctionBreakpoint.create("");
            fb.setFunctionName(properties.getString("functionName", ""));
            fb.setCondition(properties.getString("condition", ""));
            fb.setBreakpointType(properties.getInt("breakpointType", 1));
            b = fb;
        }
        assert (b != null) : "Unknown breakpoint type: \"" + typeID + "\"";
        b.setPrintText(properties.getString("printText", ""));
        b.setGroupName(properties.getString("groupName", ""));
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        RemoteBreakpoint b = (RemoteBreakpoint)((Object)object);
        properties.setString("printText", b.getPrintText());
        properties.setString("groupName", b.getGroupName());
        properties.setInt("suspend", b.getSuspend());
        properties.setBoolean("enabled", b.isEnabled());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)((Object)object);
            properties.setString("url", lb.getURL());
            properties.setInt("lineNumber", lb.getLineNumber());
            properties.setString("condition", lb.getCondition());
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint fb = (FunctionBreakpoint)((Object)object);
            properties.setString("functionName", fb.getFunctionName());
            properties.setString("condition", fb.getCondition());
            properties.setInt("breakpointType", fb.getBreakpointType());
        }
    }
}

