/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openide.util.Utilities;

public class AlphaVMSListQualifier
implements Serializable {
    private String[] items;
    private static final long serialVersionUID = -3168038106222542273L;

    public AlphaVMSListQualifier() {
    }

    public AlphaVMSListQualifier(String[] arr) {
        this.items = arr;
    }

    public AlphaVMSListQualifier(String qualifierList) {
        if (qualifierList == null || qualifierList.equals("")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(qualifierList.trim(), ",");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.startsWith("(")) {
                s = s.substring(1);
            }
            if (s.endsWith(")")) {
                s = s.substring(0, s.length() - 1);
            }
            list.add(s.trim());
        }
        this.items = list.toArray(new String[list.size()]);
    }

    public boolean equals(Object obj_) {
        if (obj_ == null) {
            return false;
        }
        if (!(obj_ instanceof AlphaVMSListQualifier)) {
            return false;
        }
        AlphaVMSListQualifier obj = (AlphaVMSListQualifier)obj_;
        if (this.items == null && obj.items == null) {
            return true;
        }
        if (this.items == null || obj.items == null) {
            return false;
        }
        if (this.items.length != obj.items.length) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].equalsIgnoreCase(obj.items[i])) continue;
            return false;
        }
        return true;
    }

    public String getFileList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].startsWith("/")) {
                sb.append(FileUtilityLang.unixPathToOpenVMSPath(this.items[i], true));
            } else {
                sb.append(this.items[i]);
            }
            if (i + 1 >= this.items.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getRemoteFileList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].startsWith("/")) {
                sb.append(FileUtilityLang.__unixPathToOpenVMSPath(this.items[i], true));
            } else if (Utilities.isWindows() && this.items[i].length() > 3 && this.items[i].substring(1, 3).equals(":\\")) {
                sb.append(FileUtilityLang.__winPathToOpenVMSPath(this.items[i], true));
            } else {
                sb.append(this.items[i]);
            }
            if (i + 1 >= this.items.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getPlainList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            sb.append(this.items[i]);
            if (i + 1 >= this.items.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.getPlainList();
    }
}

