/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifier;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.distributed.common.util.FileUtility;

public class AlphaVMSCompilationQualifier
implements Serializable {
    private String[] items;
    public File list;
    public File diagnostic;
    public File analysis;
    public File object;
    public AlphaVMSListQualifier include;
    public String others;
    public boolean isList;
    public boolean isDiagnostic;
    public boolean isAnalysis;
    public boolean isObject;
    public boolean isInclude;
    private static final long serialVersionUID = 4593344416428137836L;

    public AlphaVMSCompilationQualifier(String[] arr) {
        this.items = arr;
    }

    public AlphaVMSCompilationQualifier(File list, File diagnostic, File analysis, File object, AlphaVMSListQualifier include, String others) {
        this.list = list;
        this.diagnostic = diagnostic;
        this.analysis = analysis;
        this.object = object;
        this.include = include;
        this.others = others;
    }

    public AlphaVMSCompilationQualifier() {
        this.list = null;
        this.diagnostic = null;
        this.analysis = null;
        this.object = null;
        this.include = null;
        this.others = null;
        this.isList = false;
        this.isDiagnostic = false;
        this.isAnalysis = false;
        this.isObject = false;
        this.isInclude = false;
    }

    public AlphaVMSCompilationQualifier(String qualifierList) {
        if (qualifierList == null || qualifierList.equals("")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(qualifierList.trim(), ",");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.startsWith("(")) {
                s = s.substring(1);
            }
            if (s.endsWith(")")) {
                s = s.substring(0, s.length() - 1);
            }
            list.add(s.trim());
        }
        this.items = list.toArray(new String[list.size()]);
    }

    public File getList() {
        if (this.list != null) {
            return this.list;
        }
        return new File("");
    }

    public void setList(File newList) {
        this.list = newList;
        this.isList = true;
    }

    public File getDiagnostic() {
        if (this.diagnostic != null) {
            return this.diagnostic;
        }
        return new File("");
    }

    public void setDiagnostic(File newDiagnostic) {
        this.diagnostic = newDiagnostic;
        this.isDiagnostic = true;
    }

    public File getAnalysis() {
        if (this.analysis != null) {
            return this.analysis;
        }
        return new File("");
    }

    public void setAnalysis(File newAnalysis) {
        this.analysis = newAnalysis;
        this.isAnalysis = true;
    }

    public File getObject() {
        if (this.object != null) {
            return this.object;
        }
        return new File("");
    }

    public void setObject(File newObject) {
        this.object = newObject;
        this.isObject = true;
    }

    public AlphaVMSListQualifier getInclude() {
        if (this.include != null) {
            return this.include;
        }
        return null;
    }

    public void setInclude(AlphaVMSListQualifier newInclude) {
        this.include = newInclude;
        this.isInclude = true;
    }

    public String getOthers() {
        if (this.others == null) {
            return "";
        }
        return this.others;
    }

    public void setOthers(String newOthers) {
        this.others = newOthers;
    }

    public boolean equals(Object obj_) {
        if (!(obj_ instanceof AlphaVMSCompilationQualifier)) {
            return false;
        }
        AlphaVMSCompilationQualifier obj = (AlphaVMSCompilationQualifier)obj_;
        if (this.items == null && obj.items == null) {
            return true;
        }
        if (this.items == null || obj.items == null) {
            return false;
        }
        if (this.items.length != obj.items.length) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].equalsIgnoreCase(obj.items[i])) continue;
            return false;
        }
        return true;
    }

    public String getFileList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].startsWith("/")) {
                sb.append(FileUtility.unixPathToOpenVMSPath(this.items[i], true));
            } else {
                sb.append(this.items[i]);
            }
            if (i + 1 >= this.items.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getPlainList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            sb.append(this.items[i]);
            if (i + 1 >= this.items.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

