/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.rmi.protocol.debug;

import java.io.Serializable;

public class BreakpointPacket
implements Serializable {
    private short typeTag = 0;
    private int toggleState = 0;
    private int lineIndex = 0;
    private int instToggleIndex = 0;
    private int eventTag = 0;
    private long addrTag = 0L;
    private String expression = "";
    private String condition = "";
    private String action = "";
    public static final int K_TG_ANNOTATE_OFF = 0;
    public static final int K_TG_ANNOTATE_ON = 1;
    public static final int K_TG_ANNNOTATE_OFF_COND = 2;
    public static final int K_TG_ANNOTATE_ON_COND = 3;
    public static final int K_TG_ANNOTATE_HIDDEN = 4;
    public static final int K_TY_DELETE_BREAK = 0;
    public static final int K_TY_DEACTIVATE_BREAK = 1;
    public static final int K_TY_ACTIVATE_BREAK = 2;

    public void setTypeTag(short n) {
        this.typeTag = n;
    }

    public void setToggleState(int n) {
        this.toggleState = n;
    }

    public void setLineIndex(int n) {
        this.lineIndex = n;
    }

    public void setInstToggleIndex(int n) {
        this.instToggleIndex = n;
    }

    public void setEventTag(int n) {
        this.eventTag = n;
    }

    public void setAddrTag(long n) {
        this.addrTag = n;
    }

    public void setExpression(String str) {
        this.expression = str;
    }

    public void setCondition(String str) {
        this.condition = str;
    }

    public void setAction(String str) {
        this.action = str;
    }

    public int getTypeTag() {
        return this.typeTag;
    }

    public int getToggleState() {
        return this.toggleState;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public int getInstToggleIndex() {
        return this.instToggleIndex;
    }

    public int getEventTag() {
        return this.eventTag;
    }

    public long getAddrTag() {
        return this.addrTag;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getAction() {
        return this.action;
    }

    public String getEventTagName() {
        switch (this.typeTag) {
            case 0: {
                return "     DELETE BREAK";
            }
            case 1: {
                return "     DEACTIVATE BREAK ";
            }
            case 2: {
                return "     ACTIVATE BREAK";
            }
        }
        return "    <_?typeTag?_>";
    }

    public String toString() {
        String typeName;
        String breakstate;
        String msg = "";
        switch (this.toggleState) {
            case 0: {
                breakstate = "   ANNOTATE OFF";
                break;
            }
            case 1: {
                breakstate = "   ANNOTATE ON ";
                break;
            }
            case 2: {
                breakstate = "   ANNOTATE OFF COND";
                break;
            }
            case 3: {
                breakstate = "   ANNOTATE ON COND";
                break;
            }
            case 4: {
                breakstate = "   ANNOTATE HIDDEN";
                break;
            }
            default: {
                breakstate = "  <_?toggle?_>";
            }
        }
        switch (this.typeTag) {
            case 0: {
                typeName = "   DELETE BREAK";
                break;
            }
            case 1: {
                typeName = "   DEACTIVATE BREAK ";
                break;
            }
            case 2: {
                typeName = "   ACTIVATE BREAK";
                break;
            }
            default: {
                typeName = "  <_?typeTag?_>";
            }
        }
        msg = msg + "\n      typeName         = " + this.typeTag + typeName + '\n';
        msg = msg + "      toggleState      = " + this.toggleState + breakstate + '\n';
        msg = msg + "      lineIndex        = " + this.lineIndex + '\n';
        msg = msg + "      instToggleIndex  = " + this.instToggleIndex + '\n';
        msg = msg + "      eventTag         = " + this.eventTag + '\n';
        msg = msg + "      addrTag          = " + this.addrTag + '\n';
        msg = msg + "      expression       = " + this.expression + '\n';
        msg = msg + "      condition        = " + this.condition + '\n';
        msg = msg + "      action           = " + this.action + '\n';
        return msg;
    }
}

