/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.smb;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FileStatusInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteExecuteAction;
import org.netbeans.modules.distributed.remotefs.smb.ConfirmDeleteDialog;
import org.netbeans.modules.distributed.remotefs.smb.ExLocalFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.property.RemoteRootProperty;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import patchsources.OpenProjectList_Dist;

public class NetworkFileSystem
extends ExLocalFileSystem
implements AbstractNetworkFileSystem,
LookupListener,
FileStatusListener,
FileSystem.HtmlStatus {
    private static final long serialVersionUID = -8339230545913502376L;
    private static final String nl2 = "\n\n";
    private static final String cvtline1 = "The RMS record format of";
    private static final String cvtline2 = "is not STREAM_LF.";
    private static final String cvtline3 = "Editing this file in its current format from within NetBeans will cause the file to become corrupted.";
    private static final String cvtline4 = "Click OK to convert the file on the OpenVMS machine to STREAM_LF record format.";
    private static final String cvtline5 = "Click CANCEL to skip the conversion (file will not be opened).";
    private static final String NON_STMLF_MSG1 = "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\n";
    private static final String NON_STMLF_MSG2 = "Distributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files.";
    private static final String MOUNT_READONLY_MSG = "The remote filesystem is being mounted as a read-only filesystem.";
    public static final String NON_STMLF_MSG = "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\nDistributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files.";
    public static final String NOT_WRITABLE_MSG1 = "The selected SMB share {0} is not writable.";
    public static final String NOT_WRITABLE_MSG = "The selected SMB share {0} is not writable.\n\nThe remote filesystem is being mounted as a read-only filesystem.";
    public static final int NON_STREAMLF = 0;
    public static final int STREAMLF = 1;
    public static final int NOT_WRITABLE = 2;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 1;
    private static RequestProcessor statusRequestProcessor;
    private static final Object STATUS_REQUEST_PROCESSOR_LOCK;
    private RemoteRootProperty remoteRoot;
    private RemoteRuntimeType remoteRuntimeType;
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private Integer xDisplayNumber = new Integer(-1);
    private int refCount;
    private transient boolean readOnce = false;
    private transient Lookup.Result annotationProviders;
    private transient Collection previousProviders;

    private static String createRemoteDirectory(String remoteRootTmp, String localDirectory, String localRoot) {
        StringBuffer localDir = new StringBuffer(localDirectory);
        StringBuffer remoteDir = new StringBuffer(remoteRootTmp);
        String relRemoteDir = null;
        if (Utilities.isWindows()) {
            if (localDirectory.length() == 3) {
                return remoteRootTmp;
            }
            if (localDirectory.endsWith("\\")) {
                localDir.deleteCharAt(localDirectory.length() - 1);
            }
            localDir.delete(0, 2);
            relRemoteDir = localDir.toString().replace('\\', '.');
        } else {
            if (localDirectory.length() == localRoot.length()) {
                return remoteRootTmp;
            }
            if (localDirectory.endsWith("/")) {
                localDir.deleteCharAt(localDirectory.length() - 1);
            }
            localDir.delete(0, localRoot.length());
            relRemoteDir = localDir.toString().replace('/', '.');
        }
        if (remoteRootTmp.endsWith("]")) {
            remoteDir.deleteCharAt(remoteRootTmp.length() - 1);
        } else {
            remoteDir.append('[');
        }
        remoteDir.append(relRemoteDir);
        remoteDir.append("]");
        return remoteDir.toString();
    }

    public static String getRemoteDirectoryShare(RemoteRuntimeType rrt, String localDirectory) {
        String shareInfo = FileUtility.getShareName(localDirectory);
        String shareName = "";
        String localRoot = "";
        if (shareInfo.length() > 0) {
            if (Utilities.isWindows()) {
                shareName = shareInfo;
            } else {
                shareName = shareInfo.substring(0, shareInfo.indexOf(10));
                localRoot = shareInfo.substring(shareInfo.indexOf(10) + 1, shareInfo.length());
            }
            try {
                String remoteRootTmp = rrt.getNetworkShareRoot(shareName);
                if (remoteRootTmp != null) {
                    return NetworkFileSystem.createRemoteDirectory(remoteRootTmp, localDirectory, localRoot);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return "";
    }

    public NetworkFileSystem() {
        this.addedFS((FileSystem)this);
    }

    public NetworkFileSystem(RemoteRuntimeType remoteRuntime) {
        this.remoteRuntimeType = remoteRuntime;
        this.addedFS((FileSystem)this);
    }

    public void addedFS(FileSystem fs) {
        if (fs == this) {
            this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    public void resultChanged(LookupEvent ev) {
        HashSet add;
        HashSet now = this.annotationProviders.allInstances();
        if (this.previousProviders != null) {
            add = new HashSet(now);
            add.removeAll(this.previousProviders);
            HashSet toRemove = new HashSet(this.previousProviders);
            toRemove.removeAll(now);
            for (AnnotationProvider ap : toRemove) {
                if (ap.getInterceptionListener() instanceof FileChangeListener) {
                    this.removeFileChangeListener((FileChangeListener)ap.getInterceptionListener());
                }
                ap.removeFileStatusListener((FileStatusListener)this);
            }
        } else {
            add = now;
        }
        for (AnnotationProvider ap : add) {
            if (ap.getInterceptionListener() instanceof FileChangeListener) {
                this.addFileChangeListener((FileChangeListener)ap.getInterceptionListener());
            }
            try {
                ap.addFileStatusListener((FileStatusListener)this);
            }
            catch (TooManyListenersException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        this.previousProviders = now;
    }

    public Date lastModified(String name) {
        return super.lastModified(name);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
        this.annotationProviders.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public SystemAction[] getActions() {
        SystemAction[] defaultActions = super.getActions();
        SystemAction[] allActions = new SystemAction[defaultActions.length + 2];
        System.arraycopy(defaultActions, 0, allActions, 0, defaultActions.length);
        SystemAction[] newActions = new SystemAction[]{SystemAction.get(RemoteCompileAction.class), SystemAction.get(RemoteExecuteAction.class)};
        System.arraycopy(newActions, 0, allActions, defaultActions.length, 2);
        return allActions;
    }

    public SystemAction[] getActions(Set foSet) {
        Action[] retVal = null;
        Iterator it = this.annotationProviders.allInstances().iterator();
        while (retVal == null && it.hasNext()) {
            AnnotationProvider ap = (AnnotationProvider)it.next();
            retVal = ap.actions(foSet);
        }
        if (retVal == null) {
            retVal = new Action[]{};
        }
        SystemAction[] ret = new SystemAction[retVal.length];
        for (int i = 0; i < retVal.length; ++i) {
            ret[i] = (SystemAction)retVal[i];
        }
        SystemAction[] defaultActions = super.getActions();
        SystemAction[] allActions = new SystemAction[defaultActions.length + ret.length + 2];
        System.arraycopy(defaultActions, 0, allActions, 0, defaultActions.length);
        SystemAction[] newActions = new SystemAction[]{SystemAction.get(RemoteCompileAction.class), SystemAction.get(RemoteExecuteAction.class)};
        System.arraycopy(newActions, 0, allActions, defaultActions.length, 2);
        System.arraycopy(ret, 0, allActions, defaultActions.length + 2, ret.length);
        return allActions;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType ret = DistributedSettings.getDefault().findRemoteRuntime(this.remoteRuntimeType.getHostName(), this.remoteRuntimeType.getUserName());
        return ret;
    }

    public String getServer() {
        return this.getRemoteRuntimeType().getHostName();
    }

    public void setRemoteRuntimeType(RemoteRuntimeType rt) {
        this.remoteRuntimeType = rt;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public void setUseXtermCompile(boolean useX) {
        this.useXtermCompile = new Boolean(useX);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean useX) {
        this.useXtermExecution = new Boolean(useX);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public int getXDisplayDeviceNumber() {
        if (this.xDisplayNumber == -1) {
            return DistributedSettings.getDefault().getXDisplayDeviceNumber();
        }
        return this.xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        this.xDisplayNumber = new Integer(n);
        this.firePropertyChange("xDisplayNumber", null, this.xDisplayNumber);
    }

    public String getRemoteRoot() {
        return this.remoteRoot.getRemoteRoot();
    }

    public String getLocalRoot() {
        return this.getRootDirectory().getAbsolutePath();
    }

    public void setRemoteRoot(RemoteRootProperty rt) {
        try {
            this.remoteRoot = rt;
            this.setRootDirectory(new File(rt.getLocalRoot()));
        }
        catch (PropertyVetoException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        if (Utilities.isWindows()) {
            String rootDir = this.getRootDirectory().getAbsolutePath();
            rootDir = rootDir.substring(0, 2);
            String shareName = FileSystemView.getFileSystemView().getSystemDisplayName(new File(rootDir));
            if (shareName.lastIndexOf(40) > 0) {
                shareName = shareName.substring(0, shareName.lastIndexOf(40) - 1);
            }
            return " " + super.getDisplayName();
        }
        return " " + super.getDisplayName();
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(super.getRootDirectory().toString());
    }

    public void annotationChanged(FileStatusEvent ev) {
        this.fireFileStatusChanged(ev);
    }

    private static String getSearchRoot(String remoteRootName, NetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        String searchRootName = remoteRootName;
        if (RemoteFSUtils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            searchRootName = remoteRootName.endsWith(":") ? remoteRootName : remoteRootName.substring(0, remoteRootName.length() - 1);
        }
        return searchRootName;
    }

    private static String getClientPath(String fileName, String remoteRootName, NetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        if (RemoteFSUtils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath(fileName, false, nfs.getRootDirectory().getAbsolutePath(), remoteRootName);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
            if (Utilities.getOperatingSystem() == 16384) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
        }
        return fileName;
    }

    public static void refreshParent(String fileName, String root, char sep, FileSystem fs) {
        String parent = fileName.substring(root.length() + 1);
        parent = parent.lastIndexOf(sep) > 0 ? parent.substring(0, parent.lastIndexOf(sep)).replace(sep, '/') : "";
        FileObject pfo = fs.findResource(parent);
        if (pfo != null) {
            pfo.refresh();
        }
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void addNotify() {
        super.addNotify();
        this.incRefCount();
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void removeNotify() {
        super.removeNotify();
        this.decRefCount();
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    public static FileObject[] fromFile(String fileName) {
        Iterator en = OpenProjectList_Dist.getFsSet().iterator();
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        while (en.hasNext()) {
            FileSystem fs = (FileSystem)en.next();
            if (!(fs instanceof NetworkFileSystem)) continue;
            try {
                File file2Fo;
                FileObject fo;
                String res;
                NetworkFileSystem nfs = (NetworkFileSystem)fs;
                File root = NetworkFileSystem.toFile(fs.getRoot());
                if (root == null) continue;
                String rootName = root.getCanonicalPath();
                String remoteRootName = nfs.getRemoteRoot();
                String searchRootName = NetworkFileSystem.getSearchRoot(remoteRootName, nfs);
                if (fileName.toLowerCase().indexOf(searchRootName.toLowerCase()) == 0 && (fileName.charAt(remoteRootName.length() - 1) == '.' || fileName.charAt(remoteRootName.length() - 1) == ']')) {
                    fileName = NetworkFileSystem.getClientPath(fileName, remoteRootName, nfs);
                    res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                    NetworkFileSystem.refreshParent(fileName, rootName, File.separatorChar, fs);
                    fo = fs.findResource(res);
                    File file = file2Fo = fo != null ? NetworkFileSystem.toFile(fo) : null;
                    if (fo == null || file2Fo == null) continue;
                    list.add(fo);
                    continue;
                }
                if (!RemoteFSUtils.getServerOS(nfs.getRemoteRuntimeType()).equals(Utils.OS_VMS)) continue;
                remoteRootName = FileUtility.openVMSPathToUnixPath(remoteRootName, true);
                if (fileName.toLowerCase().indexOf(remoteRootName.toLowerCase()) != 0 || fileName.charAt(remoteRootName.length()) != '/') continue;
                res = fileName.substring(remoteRootName.length() + 1);
                NetworkFileSystem.refreshParent(fileName, remoteRootName, '/', fs);
                fo = fs.findResource(res);
                File file = file2Fo = fo != null ? NetworkFileSystem.toFile(fo) : null;
                if (fo == null || file2Fo == null) continue;
                list.add(fo);
            }
            catch (IOException iexc) {}
        }
        FileObject[] results = new FileObject[list.size()];
        list.toArray(results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkIfFSStreamLF(String localDir, String remoteDir, RemoteRuntimeType rrt) {
        File f = null;
        try {
            f = File.createTempFile("distnbstmlftest", ".txt", new File(localDir));
            if (rrt.isFileSTRMLF(remoteDir + f.getName())) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            int n = 2;
            return n;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessible(String localDir, String remoteDir, RemoteRuntimeType rrt) {
        File f = null;
        try {
            f = File.createTempFile("distnbstmlftest", ".txt", new File(localDir));
            if (rrt != null && rrt.getRemoteRuntime() != null) {
                boolean bl = rrt.fileExists(remoteDir + f.getName());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public void doSTRMLFConversion(final FileObject fobj) throws IOException {
        File file = FileUtil.toFile((FileObject)fobj);
        String vmsPath = null;
        if (Utilities.isWindows()) {
            vmsPath = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            vmsPath = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        }
        final String finalVmsPath = vmsPath;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!Utils.isEditorFile(fobj.getPath())) {
                    return;
                }
                try {
                    DataObject dobj = null;
                    CloseCookie cc = null;
                    try {
                        dobj = DataObject.find((FileObject)fobj);
                        if (dobj != null) {
                            cc = (CloseCookie)dobj.getCookie(CloseCookie.class);
                        }
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    if (dobj == null) {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Error Opening " + finalVmsPath + ". Please close it now. The file can be corrupted if continue using"), -1, 2));
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText("Connecting to the remote server:" + NetworkFileSystem.this.getRemoteRuntimeType().getHostName() + ":" + NetworkFileSystem.this.getRemoteRuntimeType().getUserName());
                    RemoteRuntime rt = NetworkFileSystem.this.getRemoteRuntimeType().getRemoteRuntime();
                    if (rt == null) {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Can't determine the file type of " + finalVmsPath + "\nbecause Remote IDE Server is not connected.\n"), -1, 2));
                        if (cc != null) {
                            cc.close();
                        } else {
                            Utils.closeEditorFile(fobj.getPath());
                        }
                        return;
                    }
                    if (!rt.getRemoteFileService().isFileSTRMLF(finalVmsPath)) {
                        if (cc != null) {
                            cc.close();
                        } else {
                            Utils.closeEditorFile(fobj.getPath());
                        }
                        String message = "The RMS record format of\n\n         " + finalVmsPath + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline2 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline3 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline4 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline5;
                        String title = "File Format Not STREAM_LF";
                        ConfirmDeleteDialog d = new ConfirmDeleteDialog(message, title, "xxx");
                        d.openChooseDialog();
                        if (!d.isCancel()) {
                            rt.getRemoteFileService().changeTxtFileToSTRMLF(finalVmsPath, finalVmsPath);
                            OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
                            if (oc == null) {
                                EditCookie ec = (EditCookie)dobj.getCookie(EditCookie.class);
                                ec.edit();
                            } else {
                                oc.open();
                            }
                        } else if (cc != null) {
                            cc.close();
                        } else {
                            Utils.closeEditorFile(fobj.getPath());
                        }
                    }
                }
                catch (RemoteException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        InputStream is = super.inputStream(name);
        if (!name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) && !name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            try {
                this.doSTRMLFConversion(this.findResource(name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }

    private static String htmlEncode(String name) {
        Pattern lt = Pattern.compile("<");
        Pattern gt = Pattern.compile(">");
        String retval = name;
        if (retval.indexOf(60) != -1) {
            retval = lt.matcher(retval).replaceAll("&lt;");
        }
        if (retval.indexOf(62) != -1) {
            retval = gt.matcher(retval).replaceAll("&gt;");
        }
        return retval;
    }

    public String annotateNameHtml(String name, Set files) {
        System.out.println("name -" + name);
        name = NetworkFileSystem.htmlEncode(name);
        name = this.annotateName(name, files);
        String retVal = null;
        Iterator it = this.annotationProviders.allInstances().iterator();
        while (retVal == null && it.hasNext()) {
            AnnotationProvider ap = (AnnotationProvider)it.next();
            retVal = ap.annotateNameHtml(name, files);
        }
        if (retVal == null) {
            return name;
        }
        return retVal;
    }

    public String annotateName(String name, Set files) {
        return name;
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        Object[] oo = files.toArray();
        int len = oo.length;
        Image img = null;
        if (len == 0) {
            return icon;
        }
        ArrayList importantFiles = new ArrayList(files);
        len = importantFiles.size();
        FileObject fullName = (FileObject)importantFiles.get(0);
        Image tmpIcon = null;
        if (this.annotationProviders != null) {
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (tmpIcon == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                tmpIcon = ap.annotateIcon(icon, iconType, files);
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        try {
            if ("".equals(fullName.getName()) && fullName.isFolder()) {
                img = FileStatusInfo.REMOTE_PRJ.getIcon();
                icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)1);
                return icon;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (((FileObject)importantFiles.get(0)).isFolder()) {
            return icon;
        }
        if (img != null) {
            icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)1);
        }
        return icon;
    }

    public void copyReadableProps(NetworkFileSystem sf) {
        try {
            this.setReadOnly(sf.isReadOnly());
            this.setIgnoredFiles(sf.getIgnoredFiles());
            this.setBackupExtensions(sf.getBackupExtensions());
            this.setRefreshTime2(sf.getRefreshTime2());
            this.setXDisplayDeviceNumber(sf.getXDisplayDeviceNumber());
            this.setUseXtermCompile(sf.getUseXtermCompile());
            this.setUseXtermExecution(sf.getUseXtermExecution());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor getStatusChangeRequestProcessor() {
        Object object = STATUS_REQUEST_PROCESSOR_LOCK;
        synchronized (object) {
            if (statusRequestProcessor == null) {
                statusRequestProcessor = new RequestProcessor("SMB FS Status Update Request Processor");
            }
        }
        return statusRequestProcessor;
    }

    public FileObject findExistingResource(String name) {
        Enumeration en = this.existingFileObjects(this.getRoot());
        FileObject fo = null;
        while (en.hasMoreElements()) {
            FileObject obj = (FileObject)en.nextElement();
            if (!name.equalsIgnoreCase(obj.getPath())) continue;
            fo = obj;
            break;
        }
        return fo;
    }

    public void statusChanged(final String path, final boolean recursively) {
        NetworkFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fo = NetworkFileSystem.this.findExistingResource(path);
                if (fo == null) {
                    return;
                }
                Enumeration en = NetworkFileSystem.this.existingFileObjects(fo);
                HashSet hs = new HashSet();
                if (en.hasMoreElements()) {
                    hs.add(en.nextElement());
                }
                while (en.hasMoreElements()) {
                    FileObject chfo = (FileObject)en.nextElement();
                    if (!recursively && !fo.equals(chfo.getParent())) break;
                    hs.add(chfo);
                }
                Set s = Collections.synchronizedSet(hs);
                NetworkFileSystem.this.fireFileStatusChanged(new FileStatusEvent((FileSystem)NetworkFileSystem.this, s, true, true));
            }
        });
    }

    static {
        STATUS_REQUEST_PROCESSOR_LOCK = new Object();
    }
}

