/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.propertyeditor;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.property.RemoteJarRootProperty;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteJarRootCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Utilities;

public class RemoteJarRootEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private FeatureDescriptor fd;
    private RemoteJarRootProperty remoteJarRoot;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public String getRemoteJarFile(String localJarFile) {
        RemoteRuntimeType rrt = this.getRemoteRuntimeType();
        return RemoteFSUtils.getRemoteJarShare(rrt, localJarFile);
    }

    private String createRemoteJarFile(String remoteRootTmp, String localJarFile, String localRoot) {
        StringBuffer localDir = new StringBuffer(localJarFile);
        StringBuffer remoteDir = new StringBuffer(remoteRootTmp);
        String jarFileName = null;
        String relRemoteDir = null;
        if (Utilities.isWindows()) {
            jarFileName = localJarFile.substring(localJarFile.lastIndexOf(92) + 1);
            localDir.delete(localJarFile.lastIndexOf(92), localJarFile.length());
            localDir.delete(0, 2);
            relRemoteDir = localDir.toString().replace('\\', '.');
        } else {
            jarFileName = localJarFile.substring(localJarFile.lastIndexOf(47) + 1);
            localDir.delete(localJarFile.lastIndexOf(47), localJarFile.length());
            if (localRoot.length() > 0) {
                localDir.delete(0, localRoot.length());
            }
            relRemoteDir = localDir.toString().replace('/', '.');
        }
        if (remoteRootTmp.endsWith("]")) {
            remoteDir.deleteCharAt(remoteRootTmp.length() - 1);
        } else {
            remoteDir.append('[');
        }
        remoteDir.append(relRemoteDir);
        remoteDir.append("]");
        remoteDir.append(jarFileName);
        return remoteDir.toString();
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.remoteJarRoot.getRemoteRuntimeType();
    }

    public String getAsText() {
        return this.remoteJarRoot.getRemoteJarRoot();
    }

    public void setAsText(String remoteJarRoot) {
    }

    public Object getValue() {
        return this.remoteJarRoot;
    }

    public void setValue(Object obj) {
        RemoteJarRootProperty old = this.remoteJarRoot;
        this.remoteJarRoot = (RemoteJarRootProperty)obj;
        this.support.firePropertyChange("remoteJarRoot", old, this.remoteJarRoot);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new RemoteJarRootCustomEditor(this);
    }

    public void attachEnv(PropertyEnv env) {
        this.fd = env.getFeatureDescriptor();
    }

    public String getHelpID() {
        return (String)this.fd.getValue("helpID");
    }
}

