/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.model.View;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ViewActions
extends AbstractAction {
    private String viewName;

    private ViewActions(String viewName) {
        this.viewName = viewName;
    }

    public Object getValue(String key) {
        if (key == "Name") {
            return NbBundle.getMessage(ViewActions.class, (String)((String)super.getValue(key)));
        }
        Object value = super.getValue(key);
        return value;
    }

    public void actionPerformed(ActionEvent evt) {
        DataObject[] dobjs;
        if (evt.getSource() instanceof Node[]) {
            Node[] nodes = (Node[])evt.getSource();
            dobjs = new DataObject[nodes.length];
            for (int i = 0; i < dobjs.length; ++i) {
                dobjs[i] = (DataObject)nodes[i].getCookie(DataObject.class);
            }
        } else {
            dobjs = new DataObject[]{};
        }
        ViewActions.openComponent(this.viewName, true, dobjs);
    }

    static void openComponent(String viewName, boolean activate, DataObject[] dobjs) {
        TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
        if (view == null) {
            throw new IllegalArgumentException(viewName);
        }
        if (view instanceof View) {
            ((View)view).setDataObjects(dobjs);
        }
        view.close();
        view.open();
        if (activate) {
            view.requestActive();
        }
    }

    public static Action createRemoteWatchesViewAction() {
        ViewActions action = new ViewActions("RemoteWatchesView");
        action.putValue("Name", "CTL_WatchesAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/watchesView/Watch");
        return action;
    }
}

