/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import java.awt.Color;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BoldVariablesTableModelFilterFirst
implements TableModelFilter,
Constants {
    private Map variableToValueType = new WeakHashMap();
    private Map variableToValueValue = new WeakHashMap();
    private Map variableToValueToString = new WeakHashMap();

    public Object getValueAt(TableModel original, Object row, String columnID) throws UnknownTypeException {
        Object result = original.getValueAt(row, columnID);
        if (columnID.equals("LocalsType") || columnID.equals("WatchType")) {
            return this.bold(row, (String)result, this.variableToValueType);
        }
        if (columnID.equals("LocalsValue") || columnID.equals("WatchValue")) {
            return this.bold(row, (String)result, this.variableToValueValue);
        }
        if (columnID.equals("LocalsToString") || columnID.equals("WatchToString")) {
            return this.bold(row, (String)result, this.variableToValueToString);
        }
        return result;
    }

    public boolean isReadOnly(TableModel original, Object row, String columnID) throws UnknownTypeException {
        return original.isReadOnly(row, columnID);
    }

    public void setValueAt(TableModel original, Object row, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(row, columnID, value);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private String bold(Object variable, String value, Map map) {
        if (map.containsKey(variable)) {
            String oldValue = (String)map.get(variable);
            if (oldValue == value || oldValue != null && oldValue.equals(value)) {
                return BoldVariablesTableModelFilterFirst.toHTML(value, false, false, null);
            }
            map.put(variable, value);
            return BoldVariablesTableModelFilterFirst.toHTML(value, true, false, null);
        }
        map.put(variable, value);
        return BoldVariablesTableModelFilterFirst.toHTML(value, false, false, null);
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color != null) {
            sb.append("<font color=");
            sb.append(Integer.toHexString(color.getRGB() & 0xFFFFFF));
            sb.append(">");
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        sb.append(text);
        if (color != null) {
            sb.append("</font>");
        }
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

