/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointListener;
import com.hp.openvms.netbeans.debugsupport.model.BreakpointsNodeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
RemoteBreakpointListener,
PropertyChangeListener {
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final Pattern threadNamePattern = Pattern.compile("\\{threadName\\}");
    private static final Pattern fileNamePattern = Pattern.compile("\\{fileName\\}");
    private static final Pattern functionNamePattern = Pattern.compile("\\{functionName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private RemoteDebugger debugger;
    private ContextProvider contextProvider;
    private Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (RemoteDebugger)contextProvider.lookupFirst(null, RemoteDebugger.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(RemoteBreakpointEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getDebugger() != this.debugger) {
                return;
            }
        }
        if (event.getConditionResult() == 2) {
            return;
        }
        RemoteBreakpoint breakpoint = (RemoteBreakpoint)((Object)event.getSource());
        this.getBreakpointsNodeModel().setCurrentBreakpoint(breakpoint);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            Object object = this.lock;
            synchronized (object) {
                block5: {
                    if (this.debugger == null) break block5;
                    if (evt.getPropertyName() != "state") break block5;
                    if (this.debugger.getState() == "state_running") break block6;
                }
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
    }

    private String substitute(String printText, RemoteBreakpointEvent event) {
        Object o = event.getSource();
        if (o instanceof LineBreakpoint) {
            LineBreakpoint lpb = (LineBreakpoint)((Object)o);
            String name = this.basename(lpb.getURL());
            String lnum = Integer.toString(lpb.getLineNumber());
            printText = fileNamePattern.matcher(printText).replaceAll(name);
            printText = lineNumberPattern.matcher(printText).replaceAll(lnum);
        } else {
            printText = fileNamePattern.matcher(printText).replaceAll("?");
            printText = lineNumberPattern.matcher(printText).replaceAll("-1");
        }
        Throwable thr = event.getConditionException();
        if (thr != null) {
            printText = printText + "\n***\n" + thr.getLocalizedMessage() + "\n***\n";
        }
        return printText;
    }

    private String basename(String url) {
        int idx = url.lastIndexOf(File.separatorChar);
        String name = idx > 0 ? url.substring(idx + 1) : url.substring(5);
        return name;
    }

    private void hookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.hookBreakpoint(bpt);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.unhookBreakpoint(bpt);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof RemoteBreakpoint) {
            RemoteBreakpoint remoteBreakpoint = (RemoteBreakpoint)breakpoint;
            remoteBreakpoint.addRemoteBreakpointListener(this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof RemoteBreakpoint) {
            RemoteBreakpoint remoteBreakpoint = (RemoteBreakpoint)breakpoint;
            remoteBreakpoint.removeRemoteBreakpointListener(this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List l = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nm : l) {
                if (!(nm instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nm;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

