/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.actions;

import com.hp.openvms.netbeans.debugsupport.actions.RemoteDebuggerActionProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class StepActionProvider
extends RemoteDebuggerActionProvider {
    public StepActionProvider(ContextProvider lookupProvider) {
        super(lookupProvider);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_CONTINUE));
    }

    public void doAction(Object action) {
        this.runAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object action) {
        if (this.getDebuggerImpl() != null) {
            Object object = this.getDebuggerImpl().LOCK;
            synchronized (object) {
                if (action == ActionsManager.ACTION_STEP_INTO) {
                    this.getDebuggerImpl().stepInto();
                    return;
                }
                if (action == ActionsManager.ACTION_STEP_OUT) {
                    this.getDebuggerImpl().stepOut();
                    return;
                }
                if (action == ActionsManager.ACTION_STEP_OVER) {
                    this.getDebuggerImpl().stepOver();
                    return;
                }
                if (action == ActionsManager.ACTION_CONTINUE) {
                    this.getDebuggerImpl().resume();
                    return;
                }
            }
        }
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepActionProvider.this.doAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    protected void checkEnabled(String debuggerState) {
        for (Object e : this.getActions()) {
            this.getDebuggerImpl();
            this.setEnabled(e, debuggerState == "state_stopped");
        }
    }
}

