/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.distributed.common.propertyeditors.ExtensionListEditor;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;

public class ExtensionListCustomEditor
extends JPanel {
    ExtensionList value;
    ExtensionListEditor editor;
    static final long serialVersionUID = -4347656479280614636L;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JButton changeButton;
    private JPanel editPanel;
    private JTextField itemField;
    private JLabel itemLabel;
    private JList itemList;
    private JLabel itemListLabel;
    private JScrollPane itemListScroll;
    private JPanel jPanel1;
    private JButton removeButton;

    private String[] getStrings() {
        ArrayList arrayList = new ArrayList();
        if (this.value == null) {
            return new String[0];
        }
        Enumeration enumeration = this.value.extensions();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        enumeration = this.value.mimeTypes();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ExtensionListCustomEditor(ExtensionListEditor extensionListEditor) {
        this.editor = extensionListEditor;
        this.value = (ExtensionList)((ExtensionList)this.editor.getValue()).clone();
        this.initComponents();
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemList.setSelectionMode(0);
        this.itemList.setListData(this.getStrings());
        this.setBorder(new EmptyBorder(new Insets(16, 8, 8, 0)));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)ExtensionListCustomEditor.class);
        this.itemLabel.setText(resourceBundle.getString("CTL_ELCE_Item"));
        this.itemListLabel.setText(resourceBundle.getString("CTL_ELCE_ItemList"));
        this.addButton.setText(resourceBundle.getString("CTL_ELCE_Add"));
        this.changeButton.setText(resourceBundle.getString("CTL_ELCE_Change"));
        this.removeButton.setText(resourceBundle.getString("CTL_ELCE_Remove"));
        this.itemLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_ELCE_Item_Mnemonic").charAt(0));
        this.itemListLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_ELCE_ItemList_Mnemonic").charAt(0));
        this.addButton.setMnemonic(resourceBundle.getString("CTL_ELCE_Add_Mnemonic").charAt(0));
        this.changeButton.setMnemonic(resourceBundle.getString("CTL_ELCE_Change_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(resourceBundle.getString("CTL_ELCE_Remove_Mnemonic").charAt(0));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE"));
        this.itemField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Item"));
        this.itemList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_ItemList"));
        this.addButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Add"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Change"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ELCE_Remove"));
        if (!this.editor.isEditable()) {
            this.itemField.setEnabled(false);
            this.addButton.setEnabled(false);
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.updateButtons();
        this.itemField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = ExtensionListCustomEditor.this.containsCurrent();
                String string = ExtensionListCustomEditor.this.itemField.getText().trim();
                boolean bl2 = ExtensionListCustomEditor.this.itemField.isEnabled() && string.length() > 0 && !bl;
                ExtensionListCustomEditor.this.addButton.setEnabled(bl2);
                ExtensionListCustomEditor.this.changeButton.setEnabled(bl2 && ExtensionListCustomEditor.this.itemList.getSelectedIndex() != -1);
                if (bl) {
                    ExtensionListCustomEditor.this.itemList.setSelectedIndex(ExtensionListCustomEditor.this.idxOfCurrent());
                }
            }
        });
        this.itemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExtensionListCustomEditor.this.addButton.isEnabled()) {
                    ExtensionListCustomEditor.this.doAdd();
                }
            }
        });
        this.addButton.setEnabled(false);
        this.changeButton.setEnabled(false);
        this.setMinimumSize(new Dimension(200, 400));
    }

    private boolean containsCurrent() {
        return this.idxOfCurrent() != -1;
    }

    private int idxOfCurrent() {
        String string = this.itemField.getText().trim();
        if (string.length() > 0) {
            int n = this.itemList.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(this.itemList.getModel().getElementAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private void initComponents() {
        this.editPanel = new JPanel();
        this.itemListScroll = new JScrollPane();
        this.itemList = new JList();
        this.itemLabel = new JLabel();
        this.itemField = new JTextField();
        this.itemListLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(new GridBagLayout());
        this.itemListScroll.setPreferredSize(new Dimension(300, 130));
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExtensionListCustomEditor.this.itemListValueChanged(listSelectionEvent);
            }
        });
        this.itemListScroll.setViewportView(this.itemList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editPanel.add((Component)this.itemListScroll, gridBagConstraints);
        this.itemLabel.setLabelFor(this.itemField);
        this.itemLabel.setText("item");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 12);
        this.editPanel.add((Component)this.itemLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.editPanel.add((Component)this.itemField, gridBagConstraints);
        this.itemListLabel.setLabelFor(this.itemList);
        this.itemListLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.editPanel.add((Component)this.itemListLabel, gridBagConstraints);
        this.add((Component)this.editPanel, "Center");
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionListCustomEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionListCustomEditor.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionListCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonsPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.add((Component)this.buttonsPanel, "East");
    }

    private String addTexts() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.itemField.getText(), ",. \n\t");
        String string = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.indexOf(47) >= 0) {
                this.value.addMimeType(string);
                continue;
            }
            this.value.addExtension(string);
        }
        return string;
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        String string = (String)this.itemList.getModel().getElementAt(n);
        if (string.indexOf(47) >= 0) {
            this.value.removeMimeType(string);
        } else {
            this.value.removeExtension(string);
        }
        this.doAdd();
    }

    private int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        String string = (String)this.itemList.getModel().getElementAt(n);
        if (string.indexOf(47) >= 0) {
            this.value.removeMimeType(string);
        } else {
            this.value.removeExtension(string);
        }
        this.itemList.setListData(this.getStrings());
        int n2 = this.itemList.getModel().getSize();
        if (n2 != 0) {
            if (n >= n2) {
                n = n2 - 1;
            }
            this.itemList.setSelectedIndex(n);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
        int n = this.itemList.getSelectedIndex();
        if (n != -1) {
            this.itemField.setText((String)this.itemList.getModel().getElementAt(n));
            this.changeButton.setEnabled(false);
        }
    }

    private void doAdd() {
        String string = this.addTexts();
        String[] stringArray = this.getStrings();
        int n = this.indexOf(stringArray, string);
        this.itemList.setListData(stringArray);
        if (n >= 0) {
            this.itemList.setSelectedIndex(n);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.doAdd();
    }

    private void updateButtons() {
        int n = this.itemList.getSelectedIndex();
        if (n == -1 || !this.editor.isEditable()) {
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
        }
    }

    private void updateValue() {
        this.editor.setValue(this.value);
    }

    static class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        static final long serialVersionUID = 487512296465844339L;

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof String)) {
                return this;
            }
            String string = (String)object;
            if ("".equals(string)) {
                string = NbBundle.getMessage((Class)(class$org$netbeans$modules$distributed$common$propertyeditors$ExtensionListCustomEditor == null ? (class$org$netbeans$modules$distributed$common$propertyeditors$ExtensionListCustomEditor = ExtensionListCustomEditor.class$("org.netbeans.modules.distributed.common.propertyeditors.ExtensionListCustomEditor")) : class$org$netbeans$modules$distributed$common$propertyeditors$ExtensionListCustomEditor), (String)"CTL_ELCE_Empty");
            }
            this.setText(string);
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

