/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootVisualPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;

public class RemoteRootPanel
implements WizardDescriptor.Panel {
    protected Component component;
    protected Component errorComponent;
    private RemoteRuntimeType rrt;
    private ArrayList listeners = new ArrayList();
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private boolean firstTime = true;

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public String getRemoteDirectory(String string) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeType();
        return NetworkFileSystem.getRemoteDirectoryShare(remoteRuntimeType, string);
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteRootVisualPanel(this, this.fsv);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (!(this.getComponent() instanceof RemoteRootVisualPanel)) {
            return false;
        }
        if (!((RemoteRootVisualPanel)this.getComponent()).getLocalDirectory().equals("") && !((RemoteRootVisualPanel)this.getComponent()).getRemoteDirectory().equals("")) {
            Enumeration enumeration = Repository.getDefault().getFileSystems();
            while (enumeration.hasMoreElements()) {
                String string;
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                if (!(fileSystem instanceof LocalFileSystem) || !(string = ((LocalFileSystem)fileSystem).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(((RemoteRootVisualPanel)this.component).getLocalDirectory())) continue;
                return fileSystem instanceof NetworkFileSystem && fileSystem.isHidden();
            }
            return true;
        }
        return false;
    }

    public final void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((ChangeListener)arrayList.get(i)).stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        this.rrt = (RemoteRuntimeType)wizardDescriptor.getProperty("remote_runtime");
        this.firstTime = true;
        this.fsv = FileSystemView.getFileSystemView();
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        if (!(this.component instanceof RemoteRootVisualPanel)) {
            return;
        }
        wizardDescriptor.putProperty("local_directory", (Object)((RemoteRootVisualPanel)this.component).getLocalDirectory());
        wizardDescriptor.putProperty("remote_directory", (Object)((RemoteRootVisualPanel)this.component).getRemoteDirectory());
    }
}

