/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.smb;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ExLocalFileSystem
extends LocalFileSystem
implements Runnable {
    private static final long serialVersionUID = -6117993653210115798L;
    private static final ExtensionList DEFAULT_EXTENSIONS = new ExtensionList();
    private static final String BACKUP_EXT = System.getProperty("org.netbeans.core.ExLocalFileSystem.BACKUP_EXT", "~");
    private ExtensionList backupExtensions;
    private String ignoredFiles = "";
    private transient Pattern ignoredRE = null;
    private static final Object ignoredRELock = new String("org.netbeans.core.ExLocalFileSystem.ignoredRELock");
    private String relativeName;
    private boolean relativeFlag = false;

    public OutputStream outputStream(String string) throws IOException {
        this.backupIfNecessary(string);
        return super.outputStream(string);
    }

    boolean isLastModifiedCacheEnabled() {
        return false;
    }

    protected void delete(String string) throws IOException {
        this.backupIfNecessary(string);
        super.delete(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupIfNecessary(String string) throws IOException {
        ExtensionList extensionList;
        ExtensionList extensionList2 = extensionList = this.backupExtensions == null ? DEFAULT_EXTENSIONS : this.backupExtensions;
        if (extensionList.isRegistered(string)) {
            InputStream inputStream = null;
            try {
                inputStream = super.inputStream(string);
                OutputStream outputStream = super.outputStream(string + BACKUP_EXT);
                try {
                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] children(String string) {
        String[] stringArray = super.children(string);
        if (stringArray == null) {
            return null;
        }
        Object object = ignoredRELock;
        synchronized (object) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (Utilities.getOperatingSystem() == 16384 && stringArray[i].endsWith(".java_")) {
                    try {
                        String string2 = stringArray[i].substring(0, stringArray[i].length() - 1) + BACKUP_EXT;
                        super.rename(string + "/" + stringArray[i], string + "/" + string2);
                        stringArray[i] = string2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!stringArray[i].endsWith(BACKUP_EXT) && (this.ignoredRE == null || !this.ignoredRE.matcher(stringArray[i]).matches())) continue;
                stringArray[i] = null;
            }
        }
        return stringArray;
    }

    public void setRefreshTime2(int n) {
        int n2 = super.getRefreshTime();
        super.setRefreshTime(n);
        if (n2 != n) {
            this.firePropertyChange("refreshTime", new Integer(n2), new Integer(n));
        }
    }

    public int getRefreshTime2() {
        return super.getRefreshTime();
    }

    public void setSystemName2(String string) throws PropertyVetoException {
        try {
            super.setSystemName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().annotate((Throwable)propertyVetoException, propertyVetoException.getMessage());
            throw propertyVetoException;
        }
    }

    public void setBackupExtensions(ExtensionList extensionList) {
        this.backupExtensions = extensionList;
        this.firePropertyChange("backupExtensions", null, null);
    }

    public ExtensionList getBackupExtensions() {
        if (this.backupExtensions == null) {
            return (ExtensionList)DEFAULT_EXTENSIONS.clone();
        }
        return this.backupExtensions;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIgnoredFiles(String string) throws IllegalArgumentException {
        if (!string.equals(this.ignoredFiles)) {
            block7: {
                if (string.length() > 0) {
                    try {
                        Object object = ignoredRELock;
                        synchronized (object) {
                            this.ignoredRE = Pattern.compile(string);
                            break block7;
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)ExLocalFileSystem.class, (String)"EXC_InvalidRegularExpressionForIgnoredFiles", (Object)patternSyntaxException.getLocalizedMessage()), (Throwable)patternSyntaxException, new Date());
                        throw illegalArgumentException;
                    }
                }
                this.ignoredRE = null;
            }
            this.ignoredFiles = string;
            this.firePropertyChange("ignoredFiles", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public void run() {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (!fileObject.isFolder()) continue;
            fileObject.refresh(true);
        }
    }

    public void setRelativeDirectory(String string) throws PropertyVetoException, IOException {
        String string2 = this.relativeName;
        try {
            this.relativeName = string;
            this.relativeFlag = true;
            String string3 = System.getProperty("netbeans.user") + File.separatorChar + string;
            File file = new File(string3);
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setRootDirectory(file);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.relativeName = string2;
            throw propertyVetoException;
        }
        catch (IOException iOException) {
            this.relativeName = string2;
            throw iOException;
        }
        finally {
            this.relativeFlag = false;
        }
    }

    public String getRelativeDirectory() {
        return this.relativeName;
    }

    protected String computeSystemName(File file) {
        if (this.relativeName != null) {
            return "{netbeans.user}/" + this.relativeName;
        }
        return super.computeSystemName(file);
    }

    public synchronized void setRootDirectory(File file) throws PropertyVetoException, IOException {
        String string = this.relativeName;
        if (!this.relativeFlag) {
            this.relativeName = null;
        }
        try {
            super.setRootDirectory(file);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.relativeName = string;
            throw propertyVetoException;
        }
        catch (IOException iOException) {
            this.relativeName = string;
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ignoredFiles == null) {
            this.ignoredFiles = "";
        } else if (this.ignoredFiles.length() > 0) {
            try {
                this.ignoredRE = Pattern.compile(this.ignoredFiles);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ErrorManager.getDefault().notify((Throwable)patternSyntaxException);
            }
        }
        if (this.relativeName != null) {
            try {
                this.setRelativeDirectory(this.relativeName);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

