/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.propertyeditor;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSNode;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileInfoExt;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.openide.util.Utilities;

public class RemoteFSFile
extends File {
    static final long serialVersionUID = -6784375681189513452L;
    private boolean canRead;
    private boolean canWrite;
    private boolean isDir;
    private boolean isHidden;
    private boolean isExist;
    private String absName;
    private String name;
    private String parent;
    private File parentFile;
    private long lastModified;
    private long size;
    private RemoteRuntimeType rrt;
    private RemoteFileService rfs;
    private boolean isVMSFileSpec;

    private RemoteFSFile() {
        super("", "");
    }

    public RemoteFSFile(String string) {
        super(string);
        this.name = string;
        this.absName = string;
        this.isVMSFileSpec = false;
    }

    public RemoteFSFile(String string, boolean bl) {
        this(string);
        this.isVMSFileSpec = bl;
    }

    public RemoteFSFile(String string, String string2, boolean bl, RemoteRuntimeType remoteRuntimeType) {
        this(string2, null, string, remoteRuntimeType);
        this.isVMSFileSpec = bl;
    }

    public boolean getIsVMSFileSpec() {
        return this.isVMSFileSpec;
    }

    public RemoteFSFile(String string, File file, String string2, RemoteRuntimeType remoteRuntimeType, boolean bl, long l, long l2) {
        super(string, string2);
        this.rrt = remoteRuntimeType;
        this.parent = string;
        this.parentFile = file;
        this.name = string2;
        this.canWrite = true;
        this.canRead = true;
        this.isDir = bl;
        this.isHidden = false;
        this.absName = (string == null || string.startsWith("(") ? "" : string + "/") + string2;
        this.lastModified = l;
        this.size = l2;
        this.isExist = true;
        try {
            this.rfs = remoteRuntimeType.getRemoteFileService();
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public RemoteFSFile(String string, File file, String string2, RemoteRuntimeType remoteRuntimeType) {
        super(string, string2);
        this.rrt = remoteRuntimeType;
        this.parent = string;
        this.parentFile = file;
        this.name = string2;
        RemoteFileInfoExt remoteFileInfoExt = null;
        try {
            this.rfs = remoteRuntimeType.getRemoteFileService();
            if (string != null && string2.indexOf(string) == 0 && string2.length() > string.length()) {
                if ((string2 = string2.substring(string.length(), string2.length())).startsWith("/")) {
                    string2 = string2.substring(1, string2.length());
                }
                remoteFileInfoExt = this.rfs.findFileDate((string == null || string.startsWith("(") ? "" : string + "/") + string2);
            }
            String string3 = string2;
            if (Utilities.getOperatingSystem() != 4096 && remoteFileInfoExt == null && string2 != null && !string2.startsWith("/")) {
                string3 = FileUtility.openVMSPathToUnixPath((String)string2, (string2.endsWith("]") || string2.endsWith(":") ? 1 : 0) != 0);
                remoteFileInfoExt = this.rfs.findFileDate(string3);
            } else {
                remoteFileInfoExt = this.rfs.findFileDate((string == null || string.startsWith("(") ? "" : string + "/") + string3);
            }
        }
        catch (RemoteException remoteException) {
            return;
        }
        if (remoteFileInfoExt != null) {
            this.canWrite = true;
            this.canRead = true;
            this.isDir = remoteFileInfoExt.isDirectory();
            this.isHidden = false;
            this.absName = (string == null || string.startsWith("(") ? "" : string + "/") + string2;
            this.lastModified = remoteFileInfoExt.lastModified();
            this.size = remoteFileInfoExt.getSize();
            this.isExist = true;
        } else {
            this.absName = (string == null ? "" : string + "/") + string2;
            this.isDir = true;
        }
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public int compareTo(File file) {
        return this.absName.compareTo(file.getAbsolutePath());
    }

    public int compareTo(Object object) {
        return this.absName.compareTo(object.toString());
    }

    public boolean createNewFile() {
        return false;
    }

    public static File createTempFile(String string, String string2) {
        return null;
    }

    public static File createTempFile(String string, String string2, File file) {
        return null;
    }

    public boolean delete() {
        try {
            this.rfs.delete(this.absName);
        }
        catch (RemoteException remoteException) {
            return false;
        }
        return true;
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object object) {
        if (this.toString() == null || object == null || object.toString() == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public boolean exists() {
        return this.isExist;
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getAbsolutePath() {
        if (this.absName == null) {
            return this.parent;
        }
        return this.absName;
    }

    public File getCanonicalFile() {
        return this.getAbsoluteFile();
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public File getParentFile() {
        if (this.parent != null && this.parent.length() > 0) {
            if (this.parent.startsWith("(")) {
                return new RemoteFSNode(this.rrt);
            }
            if (this.parent.lastIndexOf(47) > 0) {
                return this.parentFile;
            }
            return new RemoteFSNode(this.rrt);
        }
        return null;
    }

    public String getPath() {
        if (this.isVMSFileSpec) {
            return this.getAbsolutePath();
        }
        return FileUtility.unixPathToOpenVMSPath((String)this.getAbsolutePath(), (boolean)this.isDirectory());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAbsolute() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.size;
    }

    public String[] list() {
        ArrayList arrayList = null;
        try {
            arrayList = this.rfs.findFilesDates(this.parent, "*.*");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String[] stringArray = new String[arrayList == null ? 0 : arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (this.parent == null ? "" : this.parent + "/") + ((RemoteFileInfoExt)arrayList.get(i)).getFileName();
        }
        return stringArray;
    }

    public String[] list(FilenameFilter filenameFilter) {
        return null;
    }

    public File[] listFiles() {
        ArrayList arrayList = null;
        if (!this.isDirectory()) {
            return null;
        }
        try {
            arrayList = this.rfs.findFilesDates(this.parent == null ? this.name : this.absName, "(.*)");
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace(System.err);
        }
        ArrayList<RemoteFSFile> arrayList2 = new ArrayList<RemoteFSFile>();
        for (int i = 0; i < (arrayList == null ? 0 : arrayList.size()); ++i) {
            RemoteFSFile remoteFSFile = new RemoteFSFile(this.parent == null ? this.name : this.absName, this, ((RemoteFileInfoExt)arrayList.get(i)).getFileName(), this.rrt, ((RemoteFileInfoExt)arrayList.get(i)).isDirectory(), ((RemoteFileInfoExt)arrayList.get(i)).lastModified(), ((RemoteFileInfoExt)arrayList.get(i)).getSize());
            arrayList2.add(remoteFSFile);
        }
        return arrayList2.toArray(new File[0]);
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        return null;
    }

    public static File[] listRoots() {
        return null;
    }

    public boolean mkdir() {
        try {
            this.rfs.mkdirs(this.absName);
        }
        catch (RemoteException remoteException) {
            return false;
        }
        this.isExist = true;
        return true;
    }

    public boolean mkdirs() {
        return this.mkdir();
    }

    public boolean renameTo(File file) {
        try {
            this.rfs.renameTo(this.absName, file.getAbsolutePath());
        }
        catch (RemoteException remoteException) {
            return false;
        }
        return true;
    }

    public boolean setLastModified(long l) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public String toString() {
        return this.absName;
    }

    public URI toURI() {
        return null;
    }

    public URL toURL() {
        return null;
    }
}

