/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.exesupport.ExeDataLoader;
import com.hp.openvms.netbeans.exesupport.ExeDataNode;
import com.hp.openvms.netbeans.exesupport.RemotePropertiesAction;
import com.hp.openvms.netbeans.exesupport.RemoteWatchListCookie;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.distributed.common.cookies.RemotePropertyCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;

public class ExeDataObject
extends MultiDataObject {
    private static final String WATCH_LIST = "WATCH_LIST";
    PropertyChangeListener listener;
    private List remoteWatchList;
    Map remoteWatchValue;

    public ExeDataObject(FileObject fileObject, ExeDataLoader exeDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)exeDataLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)new RemotePropertyCookie(){

            public void operations(Node[] nodeArray) {
                RemotePropertiesAction.doAction(nodeArray);
            }
        });
        cookieSet.add((Node.Cookie)new RemoteWatchListCookie(){
            RemoteDebugger debug;

            public List getRemoteWatchList() {
                return ExeDataObject.this.remoteWatchList;
            }

            public List updateWatchList() {
                ExeDataObject.this.remoteWatchList = Collections.synchronizedList(new WatchList());
                return ExeDataObject.this.remoteWatchList;
            }

            public List addToRemoteWatchList(String string) {
                ExeDataObject.this.remoteWatchList.add(string);
                ExeDataObject.this.remoteWatchValue.put(string, "");
                if (this.debug != null && this.debug.getState() != "state_none") {
                    this.debug.setWatch(string);
                }
                ExeDataObject.this.fireRemoteWatchChange(this.debug);
                return ExeDataObject.this.remoteWatchList;
            }

            public void deleteFromRemoteWatchList(String string) {
                ExeDataObject.this.remoteWatchList.remove(string);
                ExeDataObject.this.remoteWatchValue.remove(string);
                ExeDataObject.this.fireRemoteWatchChange(null);
            }

            public Map getExprWatchMap() {
                return ExeDataObject.this.remoteWatchValue;
            }

            public void updateRemoteWatchModel(RemoteDebugger remoteDebugger) {
                ExeDataObject.this.fireRemoteWatchChange(remoteDebugger);
                this.debug = remoteDebugger;
            }
        });
        this.remoteWatchList = Collections.synchronizedList(new WatchList());
    }

    public void addViewModelListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    private void fireRemoteWatchChange(RemoteDebugger remoteDebugger) {
        if (this.listener != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, "REMOTE_WATCH_CHANGE", remoteDebugger, null);
            this.listener.propertyChange(propertyChangeEvent);
        }
    }

    protected Node createNodeDelegate() {
        return new ExeDataNode(this);
    }

    class WatchList
    extends LinkedList {
        public WatchList() {
            FileObject fileObject = ExeDataObject.this.getPrimaryFile();
            ExeDataObject.this.remoteWatchValue = new HashMap();
            List list = (List)fileObject.getAttribute(ExeDataObject.WATCH_LIST);
            if (list == null) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                super.add(string);
                ExeDataObject.this.remoteWatchValue.put(string, "");
            }
        }

        public boolean add(Object object) {
            try {
                boolean bl = false;
                if (!super.contains(object)) {
                    bl = super.add(object);
                    FileObject fileObject = ExeDataObject.this.getPrimaryFile();
                    fileObject.setAttribute(ExeDataObject.WATCH_LIST, (Object)this);
                }
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public void add(int n, Object object) {
            try {
                boolean bl = false;
                if (!super.contains(object)) {
                    super.add(n, object);
                    FileObject fileObject = ExeDataObject.this.getPrimaryFile();
                    fileObject.setAttribute(ExeDataObject.WATCH_LIST, (Object)this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean remove(Object object) {
            try {
                boolean bl = false;
                if (super.contains(object)) {
                    bl = super.remove(object);
                    FileObject fileObject = ExeDataObject.this.getPrimaryFile();
                    fileObject.setAttribute(ExeDataObject.WATCH_LIST, (Object)this);
                }
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

