/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.exesupport.ExeDataObject;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public class ExeDataNode
extends DataNode {
    private static final String IMAGE_ICON_BASE = "com/hp/openvms/netbeans/exesupport/resources/ExeIcon";
    static /* synthetic */ Class class$java$lang$String;

    public ExeDataNode(ExeDataObject exeDataObject) {
        super((DataObject)exeDataObject, Children.LEAF);
        this.setIconBase(IMAGE_ICON_BASE);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        this.addRemoteProperties(set);
        return sheet;
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.getDataObject().getPrimaryFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", class$java$lang$String == null ? (class$java$lang$String = ExeDataNode.class$("java.lang.String")) : class$java$lang$String, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                Object object;
                FileObject fileObject = ExeDataNode.this.getDataObject().getPrimaryFile();
                Object object2 = fileObject.getAttribute("file_residence_mode");
                try {
                    object = (RemoteFileSystem)fileObject.getFileSystem();
                    if (object.getServerOnlyFileExts().isRegistered(fileObject.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
                if (object2 != null) {
                    object = (Integer)object2;
                    String string = "Make Client and Server";
                    switch ((Integer)object) {
                        case 1: {
                            string = "Client Only";
                            break;
                        }
                        case 0: {
                            string = "Server Only";
                            break;
                        }
                        case 2: {
                            string = "Client and Server";
                        }
                    }
                    return string;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", class$java$lang$String == null ? (class$java$lang$String = ExeDataNode.class$("java.lang.String")) : class$java$lang$String, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fileObject = ExeDataNode.this.getDataObject().getPrimaryFile();
                Object object = fileObject.getAttribute("REMOTE_FILEPATH");
                if (object != null) {
                    return object;
                }
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    FileObject fileObject = ExeDataNode.this.getDataObject().getPrimaryFile();
                    fileObject.setAttribute("REMOTE_FILEPATH", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fileObject = ExeDataNode.this.getDataObject().getPrimaryFile();
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                    this.setValue(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }
}

