/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.Field;
import com.hp.openvms.netbeans.debugsupport.debugger.InvalidExpressionException;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private RemoteDebugger debugger;
    private ContextProvider lookupProvider;

    public VariablesTableModel(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (RemoteDebugger)contextProvider.lookupFirst(null, RemoteDebugger.class);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (string.equals("LocalsToString") || string.equals("WatchToString")) {
            if (object instanceof Variable) {
                return ((Variable)object).getValue();
            }
        } else if (string.equals("LocalsType") || string.equals("WatchType")) {
            if (object instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)object).getType());
            }
        } else if ((string.equals("LocalsValue") || string.equals("WatchValue")) && object instanceof Variable) {
            return ((Variable)object).getValue();
        }
        if (object.toString().startsWith("No current thread")) {
            return NbBundle.getMessage((Class)VariablesTableModel.class, (String)"NoCurrentThreadVar");
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Variable) {
            if (string.equals("LocalsToString") || string.equals("WatchToString") || string.equals("LocalsType") || string.equals("WatchType")) {
                return true;
            }
            if (string.equals("LocalsValue") || string.equals("WatchValue")) {
                return !(object instanceof LocalVariable) && !(object instanceof Field);
            }
        }
        if (object.toString().startsWith("No current thread")) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof LocalVariable && string.equals("LocalsValue")) {
            try {
                ((LocalVariable)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    static String getShort(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }
}

