/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.RemoteDebuggerEngineProvider;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrameImpl;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import com.hp.openvms.netbeans.debugsupport.model.LocalsTreeModel;
import com.hp.openvms.netbeans.exesupport.RemoteWatchListCookie;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.rmi.protocol.RemoteData;
import org.netbeans.modules.distributed.rmi.protocol.RemoteDebuggerInterruptAPI;
import org.netbeans.modules.distributed.rmi.protocol.RemoteErrorStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteInputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteProcess;
import org.netbeans.modules.distributed.rmi.protocol.debug.DebugInfo;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.netbeans.modules.distributed.rmi.protocol.debug.MonitorPacket;
import org.netbeans.modules.distributed.rmi.protocol.debug.SourceDisplayInfo;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class RemoteDebugger
implements PropertyChangeListener {
    public static final String ENGINE_ID = "RemoteDebugSession/C";
    public static final String SESSION_ID = "RemoteDebugSession";
    public static final String SESSION_PROVIDER_ID = "RemoteDebugSessionProvider";
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_SUSPEND = "suspend";
    public static final String STATE_NONE = "state_none";
    public static final String STATE_STARTING = "state_starting";
    public static final String STATE_LOADING = "state_loading";
    public static final String STATE_RUNNING = "state_running";
    public static final String STATE_STOPPED = "state_stopped";
    public static final String STATE_EXITED = "state_exited";
    public static final String REMOTE_DEBUG_TAG = "Remote Debug Server";
    private String bindingFileSpec;
    private DataObject dobj;
    private boolean userSpecifiedBinding = true;
    private boolean rpcConnected = false;
    private boolean dbgConnected = false;
    private String state = "state_none";
    private PropertyChangeSupport pcs;
    private RemoteDebuggerEngineProvider remoteDebuggerEngineProvider;
    private ArrayList callstack = new ArrayList();
    private CallStackFrame currentCallStackFrame;
    public final Object LOCK = new Object();
    private ContextProvider lookupProvider;
    private RemoteDebuggerInterruptAPI interruptRemoteDebugAPI;
    private ArrayList breakpointCache = new ArrayList();
    private String vmsPath = null;
    public ModelListener watchesViewListener = null;
    public DebuggerManagerListener debuggerManagerListener = null;
    public ModelListener localsViewListener = null;
    private LocalsTreeModel currentLocalsModel = null;
    private List currentLocals = new ArrayList();
    private DebugInfo currentDebugInfo = null;
    public static String remoteArguments;
    private Boolean boutputSwitch;
    private Boolean bRunAsForeignCommand;
    private Boolean bPromptForArguments;
    private LocalsTreeModel localsTreeModel;
    private static final String WAIT_DISPLAY = "Waiting for response from OpenVMS debug server...";
    private static final String DEFAULT_DISPLAY = "";
    private static StatusDisplayer statusDisplay;

    private LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    public RemoteDebugger(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.addPropertyChangeListener(this);
        this.dobj = (DataObject)contextProvider.lookupFirst(null, DataObject.class);
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof RemoteDebuggerEngineProvider)) continue;
            this.remoteDebuggerEngineProvider = (RemoteDebuggerEngineProvider)((Object)list.get(i));
        }
        if (this.remoteDebuggerEngineProvider == null) {
            throw new IllegalArgumentException("RemoteDebuggerEngineProvider has to be used to start RemoteDebugger!");
        }
        if (statusDisplay == null) {
            statusDisplay = StatusDisplayer.getDefault();
        }
    }

    public void setStarting() {
        this.setState(STATE_STARTING);
    }

    public void setLoading() {
        this.setState(STATE_LOADING);
    }

    public Variable getVariable(Object object) {
        return null;
    }

    public void fireRemoteBreakpointEvent(RemoteBreakpoint remoteBreakpoint, RemoteBreakpointEvent remoteBreakpointEvent) {
        remoteBreakpoint.fireRemoteBreakpointChange(remoteBreakpointEvent);
    }

    public ArrayList getCallStack() {
        return this.callstack;
    }

    public synchronized CallStackFrame getCurrentCallStackFrame() {
        if (this.callstack.size() > 0) {
            if (this.currentCallStackFrame == null) {
                this.currentCallStackFrame = (CallStackFrame)this.callstack.get(0);
            }
        } else {
            this.currentCallStackFrame = null;
        }
        return this.currentCallStackFrame;
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2 = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (callStackFrame2 == callStackFrame) {
            return;
        }
        this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, callStackFrame2, callStackFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2;
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            if (callStackFrame == this.currentCallStackFrame) {
                return callStackFrame;
            }
            callStackFrame2 = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        return callStackFrame2;
    }

    private int getXScreenNumber() {
        try {
            AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)this.dobj.getPrimaryFile().getFileSystem();
            if (abstractNetworkFileSystem != null) {
                return abstractNetworkFileSystem.getXDisplayDeviceNumber();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return 0;
    }

    private boolean getUseXterm() {
        try {
            Boolean bl = (Boolean)this.dobj.getPrimaryFile().getAttribute("useXtermExecution");
            if (bl != null) {
                return bl;
            }
            AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)this.dobj.getPrimaryFile().getFileSystem();
            if (abstractNetworkFileSystem != null) {
                return abstractNetworkFileSystem.getUseXtermExecution();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return false;
    }

    public RemoteRuntimeType getRemoteRuntimeTypefromVMSDebugger() {
        block3: {
            try {
                AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)this.dobj.getPrimaryFile().getFileSystem();
                if (abstractNetworkFileSystem == null) break block3;
                if (abstractNetworkFileSystem.getRemoteRuntimeType() == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server  does not exist.\nPlease go to the Runtime Tab and create a connection", 2));
                    break block3;
                }
                return abstractNetworkFileSystem.getRemoteRuntimeType();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLocalVariables() {
        List list = this.currentLocals;
        synchronized (list) {
            return this.currentLocals;
        }
    }

    private void stackUpdate(DebugInfo debugInfo) {
        SourceDisplayInfo sourceDisplayInfo = debugInfo.getCurrentLine();
        if (sourceDisplayInfo == null) {
            this.callstack.clear();
        } else {
            String string = sourceDisplayInfo.getFileName();
            String string2 = FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
            FileObject[] fileObjectArray = RemoteFSUtils.fromFile((String)string2);
            File file = FileUtil.toFile((FileObject)fileObjectArray[0]);
            CallStackFrameImpl callStackFrameImpl = new CallStackFrameImpl(this, DEFAULT_DISPLAY, file.getName(), file.getAbsolutePath(), Integer.toString(sourceDisplayInfo.getLineNumber()), DEFAULT_DISPLAY);
            this.callstack.clear();
            this.callstack.add(callStackFrameImpl);
            this.setCurrentCallStackFrameNoFire(callStackFrameImpl);
        }
    }

    public static void showWatchesView(final DataObject dataObject) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RemoteDebugger.showWatchesView(new Node[]{dataObject.getNodeDelegate()});
            }
        });
    }

    public static void showWatchesView(Node[] nodeArray) {
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Actions/Window/Debug/com-hp-openvms-netbeans-debugsupport-action-RemoteWatchView.instance");
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            ActionEvent actionEvent = new ActionEvent(nodeArray, 0, "ADD_REMOTE_WATCH");
            ((Action)instanceCookie.instanceCreate()).actionPerformed(actionEvent);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private void registerEditorAnnotatorListener() {
        Watch watch = DebuggerManager.getDebuggerManager().createWatch(this.toString());
        watch.remove();
    }

    public static void dialogBox(String string) {
        remoteArguments = JOptionPane.showInputDialog(null, "Arguments for " + string, "Enter the arguments ", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDebugger() throws Exception {
        FileObject fileObject = this.dobj.getPrimaryFile();
        Object object = this.dobj.getPrimaryFile().getAttribute("Run as Foreign Command");
        this.bRunAsForeignCommand = (Boolean)this.dobj.getPrimaryFile().getAttribute("Run as Foreign Command");
        this.bPromptForArguments = (Boolean)this.dobj.getPrimaryFile().getAttribute("Prompt for Runtime Arguments");
        String string = fileObject.getNameExt();
        if (this.bRunAsForeignCommand == null) {
            this.bRunAsForeignCommand = new Boolean("false");
        }
        if (this.bPromptForArguments == null) {
            this.bPromptForArguments = new Boolean("false");
        }
        if (this.bRunAsForeignCommand.equals(new Boolean("true")) && this.bPromptForArguments.equals(new Boolean("true"))) {
            RemoteDebugger.dialogBox(string);
        } else if (this.bRunAsForeignCommand.equals(new Boolean("true")) && !this.bPromptForArguments.equals(new Boolean("true"))) {
            remoteArguments = (String)this.dobj.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
        }
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setStarting();
            if (!this.startDebugServer()) {
                this.finish();
                return;
            }
            this.registerEditorAnnotatorListener();
            RemoteDebugger.showWatchesView(this.dobj);
            DebugInfo debugInfo = this.run(this.localsViewListener != null);
            if (debugInfo.getCurrentLine() != null) {
                this.stackUpdate(debugInfo);
            }
            this.currentDebugInfo = debugInfo;
            this.localVarUpdate(debugInfo);
            this.setWatches();
            this.setLoading();
            this.setStopped();
        }
    }

    private void resetStack() {
        this.callstack.clear();
    }

    private void printDebugMsg(DebugInfo debugInfo) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
        if (debugInfo.getErrorMsg() != null) {
            inputOutput.getOut().println((Object)debugInfo.getErrorMsg());
        }
        if (debugInfo.getMsg() != null) {
            inputOutput.getOut().println(debugInfo.getMsg());
        }
    }

    private DebugInfo go(boolean bl, boolean bl2) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            this.setStatus(WAIT_DISPLAY);
            DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().go(bl, bl2);
            this.setStatus(DEFAULT_DISPLAY);
            this.printDebugMsg(debugInfo);
            return debugInfo;
        }
        catch (RemoteException remoteException) {
            ErrorManager.getDefault().notify((Throwable)remoteException);
            this.setStatus(DEFAULT_DISPLAY);
            return null;
        }
    }

    public void interrupt() {
        try {
            this.interruptRemoteDebugAPI.abort();
        }
        catch (RemoteException remoteException) {
            ErrorManager.getDefault().notify((Throwable)remoteException);
        }
    }

    private void stopRemoteDebugServer() {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
        if (remoteRuntimeType == null || remoteRuntimeType.getRemoteRuntime() == null) {
            return;
        }
        try {
            remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().stopServer();
            this.setStatus(DEFAULT_DISPLAY);
        }
        catch (RemoteException remoteException) {
            ErrorManager.getDefault().notify((Throwable)remoteException);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    public void finish() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", this.debuggerManagerListener);
        this.stopRemoteDebugServer();
        this.resetStack();
        this.setState(STATE_NONE);
        this.remoteDebuggerEngineProvider.getDestructor().killEngine();
        ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            DebugInfo debugInfo = this.go(false, this.localsViewListener != null);
            if (debugInfo == null) {
                return;
            }
            if (debugInfo.getCurrentLine() == null) {
                this.finish();
            } else {
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.localVarUpdate(debugInfo);
                this.setStopped();
            }
        }
    }

    private void localVarUpdate(DebugInfo debugInfo) {
        if (this.localsViewListener != null && debugInfo.getLocalVars() != null) {
            this.currentLocals = debugInfo.getLocalVars();
            this.updateLocalsModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localVarUpdate() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            if (this.currentDebugInfo != null) {
                try {
                    RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
                    this.setStatus(WAIT_DISPLAY);
                    DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().getLocalVars(this.currentDebugInfo);
                    this.setStatus(DEFAULT_DISPLAY);
                    this.currentLocals = debugInfo.getLocalVars();
                    this.updateLocalsModel();
                }
                catch (RemoteException remoteException) {
                    ErrorManager.getDefault().notify((Throwable)remoteException);
                    this.setStatus(DEFAULT_DISPLAY);
                }
            }
        }
    }

    private void watchUpdate(DebugInfo debugInfo) {
        List list = debugInfo.getMonitors();
        RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        Map map = remoteWatchListCookie.getExprWatchMap();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MonitorPacket monitorPacket = (MonitorPacket)iterator.next();
                if (!map.containsKey(monitorPacket.getOs_expression())) continue;
                map.put(monitorPacket.getOs_expression(), monitorPacket.getOs_value());
            }
            this.updateWatchesModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().stepOver(false, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.setStopped();
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().stepInto(false, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.setStopped();
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOut() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().stepOut(false, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.setStopped();
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    public void breakpointInsertCache(SourceDisplayInfo sourceDisplayInfo) {
        this.breakpointCache.add(sourceDisplayInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugInfo[] breakpointInsertFlushCache() {
        DebugInfo[] debugInfoArray = new DebugInfo[]{};
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            try {
                if (this.breakpointCache.size() > 0) {
                    RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
                    this.setStatus(WAIT_DISPLAY);
                    debugInfoArray = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().setBreakpoint(this.breakpointCache.toArray(new SourceDisplayInfo[0]));
                    this.setStatus(DEFAULT_DISPLAY);
                    this.breakpointCache.clear();
                }
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
        return debugInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugInfo breakpointInsert(SourceDisplayInfo sourceDisplayInfo) {
        DebugInfo debugInfo = null;
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            try {
                DebugInfo[] debugInfoArray = null;
                RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
                this.setStatus(WAIT_DISPLAY);
                debugInfoArray = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().setBreakpoint(new SourceDisplayInfo[]{sourceDisplayInfo});
                this.setStatus(DEFAULT_DISPLAY);
                debugInfo = debugInfoArray[0];
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
        return debugInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemove(LookupLinePacket lookupLinePacket) {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            try {
                RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
                this.setStatus(WAIT_DISPLAY);
                remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().removeBreakpoint(lookupLinePacket);
                this.setStatus(DEFAULT_DISPLAY);
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    private DebugInfo run(boolean bl) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
        DebugInfo debugInfo = null;
        try {
            InputOutput inputOutput;
            this.setStatus(WAIT_DISPLAY);
            this.interruptRemoteDebugAPI = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().getRemoteDebuggerInterruptAPI();
            debugInfo = this.bRunAsForeignCommand.equals(new Boolean("true")) & remoteArguments != null ? remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().run(this.vmsPath, remoteArguments, bl) : remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().run(this.vmsPath, DEFAULT_DISPLAY, bl);
            this.setStatus(DEFAULT_DISPLAY);
            if (debugInfo.getErrorMsg() != null) {
                inputOutput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
                inputOutput.getOut().println((Object)debugInfo.getErrorMsg());
            }
            if (debugInfo.getMsg() != null) {
                inputOutput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
                inputOutput.getOut().println(debugInfo.getMsg());
            }
        }
        catch (RemoteException remoteException) {
            ErrorManager.getDefault().notify((Throwable)remoteException);
            this.setStatus(DEFAULT_DISPLAY);
        }
        return debugInfo;
    }

    public static String getCurrentDirectory(DataObject dataObject) {
        File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile().getParent());
        String string = null;
        if (Utilities.isWindows()) {
            string = RemoteFSUtils._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)file.isDirectory(), (FileObject)dataObject.getPrimaryFile());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            string = RemoteFSUtils.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)file.isDirectory(), (FileObject)dataObject.getPrimaryFile());
        }
        return string;
    }

    private boolean startDebugServer() throws IOException {
        try {
            RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
            if (remoteRuntimeType == null) {
                return false;
            }
            String string = Utils.getIntendedHostAddress();
            int n = this.getXScreenNumber();
            boolean bl = this.getUseXterm();
            String string2 = RemoteDebugger.getCurrentDirectory(this.dobj);
            this.vmsPath = string2 + this.dobj.getPrimaryFile().getNameExt();
            this.setStatus(WAIT_DISPLAY);
            final RemoteProcess remoteProcess = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().connect(string, string2, n, bl);
            this.setStatus(DEFAULT_DISPLAY);
            final RemoteInputStream remoteInputStream = remoteProcess.getInputStream();
            final RemoteErrorStream remoteErrorStream = remoteProcess.getErrorStream();
            final InputOutput inputOutput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
            inputOutput.getOut().reset();
            inputOutput.select();
            inputOutput.setFocusTaken(true);
            inputOutput.setErrVisible(false);
            inputOutput.setErrSeparated(false);
            inputOutput.setInputVisible(true);
            if (remoteProcess != null) {
                inputOutput.getOut().println("Debug server started...");
            } else {
                inputOutput.getOut().println("Debug Server failed to start...");
            }
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(inputOutput.getIn());
                        while ((string = bufferedReader.readLine()) != null) {
                            RemoteDebugger.this.doCommand(string);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            });
            thread.start();
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    try {
                        byte[] byArray = new byte[64];
                        RemoteData remoteData = remoteInputStream.read(byArray, 0, 64);
                        while (remoteData.getReturn() > 0) {
                            inputOutput.getOut().print(new String(remoteData.getData(), 0, remoteData.getReturn()));
                            remoteData = remoteInputStream.read(byArray, 0, 64);
                        }
                        remoteProcess.destroy();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            });
            thread2.start();
            Thread thread3 = new Thread(new Runnable(){

                public void run() {
                    try {
                        byte[] byArray = new byte[64];
                        RemoteData remoteData = remoteErrorStream.read(byArray, 0, 64);
                        while (remoteData.getReturn() > 0) {
                            inputOutput.getOut().print(new String(remoteData.getData(), 0, remoteData.getReturn()));
                            remoteData = remoteErrorStream.read(byArray, 0, 64);
                        }
                        remoteProcess.destroy();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            });
            thread3.start();
            return true;
        }
        catch (Exception exception) {
            this.setStatus(DEFAULT_DISPLAY);
            return false;
        }
    }

    public void break_disable(int n) {
    }

    private void updateWatchMapSingle(DebugInfo debugInfo, String string, List list, Map map) {
        String string2 = ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_expression();
        if (!string2.equals(string)) {
            map.remove(string);
            list.remove(string);
            list.add(string2);
        }
        map.put(string2, ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_value());
    }

    private void updateWatchMapMultiple(DebugInfo debugInfo, List list, Map map, int n) {
        String string = ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_expression();
        if (!string.equals(list.get(n))) {
            map.remove(list.get(n));
            list.remove(n);
            list.add(n, string);
        }
        map.put(string, ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_value());
    }

    private void setWatches() {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
            List list = remoteWatchListCookie.getRemoteWatchList();
            Map map = remoteWatchListCookie.getExprWatchMap();
            this.setStatus(WAIT_DISPLAY);
            DebugInfo[] debugInfoArray = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().setWatches(list.toArray(new String[0]));
            this.setStatus(DEFAULT_DISPLAY);
            for (int i = 0; i < debugInfoArray.length; ++i) {
                this.printDebugMsg(debugInfoArray[i]);
                if (debugInfoArray[i].getMonitors() != null) {
                    this.updateWatchMapMultiple(debugInfoArray[i], list, map, i);
                    continue;
                }
                String string = debugInfoArray[i].getMsg();
                if (string == null) {
                    string = "Watchpoint could not be set.";
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
            }
            this.updateWatchesModel();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    public void setWatch(String string) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
            List list = remoteWatchListCookie.getRemoteWatchList();
            Map map = remoteWatchListCookie.getExprWatchMap();
            this.setStatus(WAIT_DISPLAY);
            DebugInfo[] debugInfoArray = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().setWatches(new String[]{string});
            this.setStatus(DEFAULT_DISPLAY);
            this.printDebugMsg(debugInfoArray[0]);
            if (debugInfoArray[0].getMonitors() != null) {
                this.updateWatchMapSingle(debugInfoArray[0], string, list, map);
            } else {
                String string2 = debugInfoArray[0].getMsg();
                if (string2 == null) {
                    string2 = "Watchpoint could not be set.";
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 1));
            }
            this.updateWatchesModel();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    public void cancelWatch(String string) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            this.setStatus(WAIT_DISPLAY);
            DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().cancelWatch(string);
            this.setStatus(DEFAULT_DISPLAY);
            this.printDebugMsg(debugInfo);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    private boolean isExitCommand(String string) {
        return string.toLowerCase().startsWith("exi") || string.toLowerCase().startsWith("quit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCommand(String string) {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = remoteRuntimeType.getRemoteRuntime().getRemoteDebuggerAPI().doCommand(string, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                if (debugInfo.getCurrentLine() != null) {
                    this.setStopped();
                } else {
                    this.finish();
                }
            }
            catch (RemoteException remoteException) {
                this.setStatus(DEFAULT_DISPLAY);
                if (this.isExitCommand(string)) {
                    this.finish();
                } else {
                    ErrorManager.getDefault().notify((Throwable)remoteException);
                }
                return false;
            }
            return true;
        }
    }

    public void updateWatchesModel() {
        RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        remoteWatchListCookie.updateRemoteWatchModel(this);
    }

    public String getExpressionValue(String string) {
        RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        Map map = remoteWatchListCookie.getExprWatchMap();
        if (map.containsKey(string)) {
            return (String)map.get(string);
        }
        return DEFAULT_DISPLAY;
    }

    public void registerLocalsModel(LocalsTreeModel localsTreeModel) {
        this.currentLocalsModel = localsTreeModel;
    }

    public void registerLocalsListener(ModelListener modelListener) {
        this.localsViewListener = modelListener;
        if (this.localsViewListener != null) {
            this.localVarUpdate();
        }
        this.updateLocalsModel();
    }

    public void updateLocalsModel() {
        if (this.localsViewListener == null) {
            return;
        }
        this.localsViewListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this.currentLocalsModel));
    }

    public void setVariableValue(String string, String string2) {
    }

    public String getVariableType(String string) {
        RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        if (remoteWatchListCookie == null) {
            return DEFAULT_DISPLAY;
        }
        Map map = remoteWatchListCookie.getExprWatchMap();
        if (map.containsKey(string)) {
            return "REMOTE";
        }
        return DEFAULT_DISPLAY;
    }

    public String getState() {
        return this.state;
    }

    public void setRunning() {
        this.setState(STATE_RUNNING);
    }

    public void setStopped() {
        this.setState(STATE_STOPPED);
    }

    private void setState(String string) {
        if (string == this.state) {
            return;
        }
        String string2 = this.state;
        this.state = string;
        this.firePropertyChange(PROP_STATE, string2, string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    private void setStatus(String string) {
        try {
            statusDisplay.setStatusText(string);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    class MyDebuggerManagerListener
    extends DebuggerManagerAdapter {
        List watches;

        public MyDebuggerManagerListener(DataObject dataObject) {
            RemoteWatchListCookie remoteWatchListCookie = (RemoteWatchListCookie)dataObject.getCookie(class$com$hp$openvms$netbeans$exesupport$RemoteWatchListCookie == null ? (class$com$hp$openvms$netbeans$exesupport$RemoteWatchListCookie = RemoteDebugger.class$("com.hp.openvms.netbeans.exesupport.RemoteWatchListCookie")) : class$com$hp$openvms$netbeans$exesupport$RemoteWatchListCookie);
            this.watches = remoteWatchListCookie.updateWatchList();
        }

        public void watchAdded(Watch watch) {
            if (!this.watches.contains(watch.getExpression())) {
                this.watches.add(watch);
                RemoteDebugger.this.setWatch(watch.getExpression());
            }
        }

        public void watchRemoved(Watch watch) {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            for (int i = 0; watchArray != null && i < watchArray.length; ++i) {
                if (!watch.getExpression().equals(watchArray[i].getExpression())) continue;
                return;
            }
            if (this.watches.contains(watch.getExpression())) {
                RemoteDebugger.this.cancelWatch(watch.getExpression());
            }
            this.watches.remove(watch.getExpression());
        }
    }
}

