/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContext;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private transient Object currentPC;
    private transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private RemoteDebugger currentDebugger;
    private HashMap stackAnnotations = new HashMap();
    private RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private List stackToAnnotate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CurrentThreadAnnotationListener() {
        this.updateCurrentDebugger();
        if (!$assertionsDisabled && this.currentDebugger != null && Boolean.getBoolean("gdb.assertions.enabled")) {
            throw new AssertionError();
        }
    }

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "currentEngine") {
            this.updateCurrentDebugger();
            this.annotate();
        } else if (propertyChangeEvent.getPropertyName() == "currentThread") {
            this.annotate();
        } else if (propertyChangeEvent.getPropertyName() == "currentCallStackFrame") {
            this.annotate();
        } else if (propertyChangeEvent.getPropertyName() == "state") {
            this.annotate();
        }
    }

    private void updateCurrentDebugger() {
        RemoteDebugger remoteDebugger = CurrentThreadAnnotationListener.getCurrentDebugger();
        if (this.currentDebugger == remoteDebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (remoteDebugger != null) {
            remoteDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.currentDebugger = remoteDebugger;
    }

    private static RemoteDebugger getCurrentDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (RemoteDebugger)debuggerEngine.lookupFirst(null, RemoteDebugger.class);
    }

    private void updateCurrentThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        if (this.currentDebugger == null) {
            return;
        }
        if (this.currentDebugger.getState() != "state_stopped") {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        ArrayList arrayList = this.currentDebugger.getCallStack();
        final CallStackFrame callStackFrame = this.currentDebugger.getCurrentCallStackFrame();
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string = session == null ? null : session.getCurrentLanguage();
        Object object = this.currentPCLock;
        synchronized (object) {
            this.currentPCSet = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (callStackFrame != null) {
                        EditorContextBridge.showSource(callStackFrame);
                    }
                }
            }
        });
        this.annotateCallStack(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Iterator iterator = CurrentThreadAnnotationListener.this.currentPCLock;
                        synchronized (iterator) {
                            if (CurrentThreadAnnotationListener.this.currentPCSet) {
                                return;
                            }
                            if (CurrentThreadAnnotationListener.this.currentPC != null) {
                                EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                            }
                            CurrentThreadAnnotationListener.this.currentPC = null;
                        }
                        iterator = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (iterator.hasNext()) {
                            EditorContextBridge.removeAnnotation(iterator.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations.clear();
                    }
                });
            }
        }
        this.taskRemove.schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(List list) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = list;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list;
                        Object object = CurrentThreadAnnotationListener.this.rp;
                        synchronized (object) {
                            if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                                return;
                            }
                            list = CurrentThreadAnnotationListener.this.stackToAnnotate;
                            CurrentThreadAnnotationListener.this.stackToAnnotate = null;
                        }
                        if (CurrentThreadAnnotationListener.this.currentPC != null) {
                            EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                        }
                        CurrentThreadAnnotationListener.this.currentPC = null;
                        object = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (object.hasNext()) {
                            EditorContextBridge.removeAnnotation(object.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations.clear();
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        String string = EditorContext.CURRENT_LINE_ANNOTATION_TYPE;
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            Object var7_8 = null;
                            CallStackFrame callStackFrame = (CallStackFrame)list.get(i);
                            int n2 = callStackFrame.getLineNumber();
                            String string2 = Integer.toString(n2);
                            if (hashMap.containsKey(string2)) continue;
                            Object object2 = EditorContextBridge.annotate(callStackFrame, string);
                            if (object2 != null) {
                                hashMap.put(string2, object2);
                            }
                            string = EditorContext.CALL_STACK_FRAME_ANNOTATION_TYPE;
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations = hashMap;
                    }
                });
            }
        }
        this.taskAnnotate.schedule(50);
    }

    static {
        $assertionsDisabled = !CurrentThreadAnnotationListener.class.desiredAssertionStatus();
    }
}

