/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

final class ProxyNode
extends AbstractNode {
    private Node[] original;
    private PropertyChangeListener pcl;

    public ProxyNode(Node[] nodeArray) {
        super(Children.LEAF);
        this.original = nodeArray;
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProxyNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)nodeArray[i]));
        }
    }

    public HelpCtx getHelpCtx() {
        for (int i = 0; i < this.original.length; ++i) {
            if (this.original[i].getHelpCtx() == HelpCtx.DEFAULT_HELP) continue;
            return this.original[i].getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new ProxyNode(this.original);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set[] setArray = this.computePropertySets();
        for (int i = 0; i < setArray.length; ++i) {
            sheet.put(setArray[i]);
        }
        return sheet;
    }

    Node[] getOriginalNodes() {
        return this.original;
    }

    private Sheet.Set[] computePropertySets() {
        if (this.original.length > 0) {
            Node.PropertySet[] propertySetArray = this.original[0].getPropertySets();
            HashSet<Node.PropertySet> hashSet = new HashSet<Node.PropertySet>(Arrays.asList(propertySetArray));
            for (int i = 1; i < this.original.length; ++i) {
                hashSet.retainAll(new HashSet<Node.PropertySet>(Arrays.asList(this.original[i].getPropertySets())));
            }
            ArrayList<Sheet.Set> arrayList = new ArrayList<Sheet.Set>(hashSet.size());
            for (int i = 0; i < propertySetArray.length; ++i) {
                if (!hashSet.contains(propertySetArray[i]) || propertySetArray[i].isHidden()) continue;
                Node.PropertySet propertySet = propertySetArray[i];
                Sheet.Set set = new Sheet.Set();
                set.setName(propertySet.getName());
                set.setDisplayName(propertySet.getDisplayName());
                set.setShortDescription(propertySet.getShortDescription());
                HashSet<Node.Property> hashSet2 = new HashSet<Node.Property>(Arrays.asList(propertySet.getProperties()));
                for (int j = 0; j < this.original.length; ++j) {
                    Node.PropertySet[] propertySetArray2 = this.original[j].getPropertySets();
                    for (int k = 0; k < propertySetArray2.length; ++k) {
                        Node.Property[] propertyArray = propertySetArray2[k].getProperties();
                        if (!propertySet.getName().equals(propertySetArray2[k].getName())) continue;
                        hashSet2.retainAll(new HashSet<Node.Property>(Arrays.asList(propertySetArray2[k].getProperties())));
                    }
                }
                Node.Property[] propertyArray = propertySet.getProperties();
                for (int j = 0; j < propertyArray.length; ++j) {
                    if (!hashSet2.contains(propertyArray[j]) || propertyArray[j].isHidden()) continue;
                    ProxyProperty proxyProperty = this.createProxyProperty(propertyArray[j].getName(), set.getName());
                    set.put((Node.Property)proxyProperty);
                }
                arrayList.add(set);
            }
            return arrayList.toArray(new Sheet.Set[arrayList.size()]);
        }
        return new Sheet.Set[0];
    }

    private ProxyProperty createProxyProperty(String string, String string2) {
        Node.Property[] propertyArray = new Node.Property[this.original.length];
        for (int i = 0; i < this.original.length; ++i) {
            Node.PropertySet[] propertySetArray = this.original[i].getPropertySets();
            for (int j = 0; j < propertySetArray.length; ++j) {
                if (!propertySetArray[j].getName().equals(string2)) continue;
                Node.Property[] propertyArray2 = propertySetArray[j].getProperties();
                for (int k = 0; k < propertyArray2.length; ++k) {
                    if (!propertyArray2[k].getName().equals(string)) continue;
                    propertyArray[i] = propertyArray2[k];
                }
            }
        }
        return new ProxyProperty(propertyArray);
    }

    static class DifferentValuesException
    extends RuntimeException {
        public DifferentValuesException() {
        }

        public DifferentValuesException(String string) {
            super(string);
        }
    }

    private static class ProxyProperty
    extends Node.Property {
        private Node.Property[] original;

        public ProxyProperty(Node.Property[] propertyArray) {
            super(propertyArray[0].getValueType());
            this.original = propertyArray;
            this.setName(propertyArray[0].getName());
            this.setDisplayName(propertyArray[0].getDisplayName());
            this.setShortDescription(propertyArray[0].getShortDescription());
        }

        public boolean canWrite() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canWrite()) continue;
                return false;
            }
            return true;
        }

        public boolean canRead() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canRead()) continue;
                return false;
            }
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object object = this.original[0].getValue();
            if (object == null) {
                return null;
            }
            for (int i = 0; i < this.original.length; ++i) {
                if (object.equals(this.original[i].getValue())) continue;
                throw new DifferentValuesException();
            }
            return object;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(object);
            }
        }

        public Object getValue(String string) {
            Object object = this.original[0].getValue(string);
            if (object == null) {
                return null;
            }
            for (int i = 0; i < this.original.length; ++i) {
                if (object.equals(this.original[i].getValue(string))) continue;
                ErrorManager.getDefault().notify(1, (Throwable)new DifferentValuesException("Different values in attribute " + string));
                return null;
            }
            return object;
        }

        public void setValue(String string, Object object) {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(string, object);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.original[0].getPropertyEditor();
        }

        public boolean supportsDefaultValue() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].supportsDefaultValue()) continue;
                return false;
            }
            return true;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].restoreDefaultValue();
            }
        }
    }
}

