/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.DefaultPropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyEditor;
import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.IndexedPropertyEditor;
import com.hp.openvms.netbeans.cppsupport.prop.NamesPanel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyDialogManager;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyEnv;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheetSettings;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyShow;
import com.hp.openvms.netbeans.cppsupport.prop.ProxyNode;
import com.hp.openvms.netbeans.cppsupport.prop.SheetButton;
import com.hp.openvms.netbeans.cppsupport.prop.SheetButtonListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PropertyPanel
extends JComponent
implements Accessible {
    public static final int PREF_READ_ONLY = 1;
    public static final int PREF_CUSTOM_EDITOR = 2;
    public static final int PREF_INPUT_STATE = 4;
    public static final String PROP_PREFERENCES = "preferences";
    public static final String PROP_MODEL = "model";
    public static final String PROP_PROPERTY_EDITOR = "propertyEditor";
    public static final String PROP_STATE = "state";
    private static final String PROP_CAN_EDIT_AS_TEXT = "canEditAsText";
    private static final PropertyModel EMPTY_MODEL = new EmptyModel();
    private int preferences;
    private PropertyModel model;
    private PropertyEditor editor;
    private PropertyEnv env;
    private FeatureDescriptor descriptor = new FeatureDescriptor();
    private int paintingStyle;
    private Color foregroundColor;
    private Color disabledColor;
    private boolean plastic;
    static ThreadLocal current = new ThreadLocal();
    private boolean canWrite = true;
    private boolean canRead = true;
    private SheetButton readComponent;
    private SheetButton textView;
    private PropertyShow propertyShow;
    private SheetButton paintView;
    private SheetButton customizeButton;
    private boolean isReadState;
    private boolean isWriteState;
    private boolean ignoreEvents;
    private boolean customDialogShown;
    private boolean differentValues;
    private JTextField textField;
    private JComboBox comboBox;
    private ReadComponentListener readComponentListener;
    private WriteComponentListener writeComponentListener;
    private PropertyChangeListener modelListener;
    private PropertyChangeListener editorListener;
    private PropertyChangeListener weakEditorListener;
    private SheetButtonListener sheetButtonListener;
    private VetoableChangeListener envListener;
    private static final WeakHashMap envCache = new WeakHashMap();
    private boolean changeImmediate = true;
    static /* synthetic */ Class class$java$lang$Object;

    public PropertyPanel() {
        this(EMPTY_MODEL, 0);
    }

    public PropertyPanel(Object object, String string, int n) {
        this(new DefaultPropertyModel(object, string), n);
    }

    public PropertyPanel(PropertyModel propertyModel, int n) {
        this.model = propertyModel;
        this.preferences = n;
        this.setLayout(new BorderLayout());
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.PropertyPanel$PropertySheetSettingsInvoker");
            Runnable runnable = (Runnable)clazz.newInstance();
            current.set(this);
            runnable.run();
        }
        catch (Exception exception) {
            bl = true;
        }
        catch (LinkageError linkageError) {
            bl = true;
        }
        if (bl) {
            this.paintingStyle = 3;
            this.plastic = false;
            this.disabledColor = UIManager.getColor("textInactiveText");
            this.foregroundColor = new Color(0, 0, 128);
        }
        propertyModel.addPropertyChangeListener(this.getModelListener());
        this.updateEditor();
        this.reset();
    }

    PropertyPanel(Node.Property property, Object[] objectArray) {
        this(new SimpleModel(property, objectArray), 0);
    }

    public int getPreferences() {
        return this.preferences;
    }

    public void setPreferences(int n) {
        int n2 = this.preferences;
        this.preferences = n;
        this.readComponent = null;
        this.reset();
        this.firePropertyChange(PROP_PREFERENCES, new Integer(n2), new Integer(n));
    }

    public PropertyModel getModel() {
        return this.model;
    }

    public void setModel(PropertyModel propertyModel) {
        PropertyModel propertyModel2 = this.model;
        this.model = propertyModel;
        propertyModel2.removePropertyChangeListener(this.getModelListener());
        propertyModel.addPropertyChangeListener(this.getModelListener());
        this.updateEditor();
        this.reset();
        this.firePropertyChange(PROP_MODEL, propertyModel2, propertyModel);
    }

    public final Object getState() {
        PropertyEnv propertyEnv = this.env;
        return propertyEnv == null ? PropertyEnv.STATE_VALID : propertyEnv.getState();
    }

    public void updateValue() {
        Component component;
        if (this.editor == null) {
            return;
        }
        PropertyEnv propertyEnv = this.env;
        if (propertyEnv != null && propertyEnv.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
            propertyEnv.setState(PropertyEnv.STATE_VALID);
        }
        if (this.editor.supportsCustomEditor() && (component = this.editor.getCustomEditor()) instanceof EnhancedCustomPropertyEditor) {
            try {
                Object object = ((EnhancedCustomPropertyEditor)component).getPropertyValue();
                this.editor.setValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                PropertyDialogManager.notify(illegalStateException);
            }
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public void setEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.setComponentEnabled(componentArray[i], bl);
            }
        }
        super.setEnabled(bl);
    }

    public boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    public void setChangeImmediate(boolean bl) {
        if (this.changeImmediate == bl) {
            return;
        }
        this.changeImmediate = bl;
        if (this.env != null) {
            this.env.setChangeImmediate(bl);
        }
        this.firePropertyChange("changeImmediate", bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    SheetButton getReadComponent() {
        return this.readComponent;
    }

    void setWriteState() {
        if (this.isWriteState) {
            return;
        }
        if ((this.preferences & 1) != 0) {
            return;
        }
        if ((this.preferences & 2) != 0) {
            return;
        }
        this.isReadState = false;
        this.isWriteState = false;
        this.removeAll();
        JComponent jComponent = this.getWriterComponent();
        jComponent.setToolTipText(this.getPanelToolTipText());
        this.add((Component)jComponent, "Center");
        this.updateNeighbourPanels();
        this.revalidate();
        this.repaint();
        Component component = PropertyPanel.getDefaultFocusComponent(jComponent);
        if (component != null) {
            WriteComponentListener writeComponentListener = this.getWriteComponentListener();
            component.requestFocus();
            component.removeFocusListener(writeComponentListener);
            component.removeKeyListener(writeComponentListener);
            component.addFocusListener(writeComponentListener);
            component.addKeyListener(writeComponentListener);
        }
        this.isReadState = false;
        this.isWriteState = true;
    }

    private static Component getDefaultFocusComponent(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component;
            if (componentArray[i].isFocusTraversable()) {
                return componentArray[i];
            }
            if (!(componentArray[i] instanceof JComponent) || ((JComponent)componentArray[i]).isManagingFocus() || (component = PropertyPanel.getDefaultFocusComponent((JComponent)componentArray[i])) == null) continue;
            return component;
        }
        return null;
    }

    void setPlastic(boolean bl) {
        this.plastic = bl;
        this.reset();
    }

    boolean getPlastic() {
        return this.plastic;
    }

    void setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.reset();
    }

    void setDisabledColor(Color color) {
        this.disabledColor = color;
        this.reset();
    }

    void setPaintingStyle(int n) {
        this.paintingStyle = n;
        this.reset();
    }

    void addSheetButtonListener(SheetButtonListener sheetButtonListener) {
        this.sheetButtonListener = sheetButtonListener;
        if (this.readComponent != null) {
            this.readComponent.addSheetButtonListener(sheetButtonListener);
        }
    }

    boolean isWriteState() {
        return this.isWriteState;
    }

    private void updateNeighbourPanels() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof NamesPanel); container = container.getParent()) {
        }
        if (container instanceof NamesPanel) {
            NamesPanel namesPanel = (NamesPanel)container;
            namesPanel.reset();
        }
    }

    private void updateEditor() {
        Object object;
        Object object2;
        if (this.model == EMPTY_MODEL) {
            return;
        }
        PropertyEditor propertyEditor = this.editor;
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.getEditorListener());
        }
        this.editor = null;
        if (this.env != null) {
            this.env.removePropertyChangeListener(this.getEditorListener());
        }
        this.env = null;
        if (this.model instanceof ExPropertyModel) {
            this.descriptor = ((ExPropertyModel)this.model).getFeatureDescriptor();
            if (this.descriptor instanceof Node.Property) {
                this.canWrite = ((Node.Property)this.descriptor).canWrite();
                this.canRead = ((Node.Property)this.descriptor).canRead();
                this.editor = ((Node.Property)this.descriptor).getPropertyEditor();
                if (this.editor == null && this.descriptor instanceof Node.IndexedProperty) {
                    this.editor = new IndexedPropertyEditor();
                    this.descriptor.setValue("changeImmediate", Boolean.FALSE);
                }
            }
        }
        if (this.editor == null && (object2 = this.model.getPropertyEditorClass()) != null) {
            try {
                object = ((Class)object2).getConstructor(new Class[0]);
                ((Constructor)object).setAccessible(true);
                this.editor = (PropertyEditor)((Constructor)object).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                PropertyDialogManager.notify(exception);
            }
        }
        if (this.editor == null && (object2 = this.model.getPropertyType()) != null) {
            this.editor = PropertyEditorManager.findEditor(object2);
        }
        if (this.editor != null) {
            if (this.editor instanceof ExPropertyEditor) {
                object2 = (Reference)envCache.get(this.editor);
                if (object2 != null) {
                    this.env = (PropertyEnv)((Reference)object2).get();
                }
                if (this.env == null) {
                    this.env = new PropertyEnv();
                    envCache.put(this.editor, new WeakReference<PropertyEnv>(this.env));
                }
                this.setChangeImmediate(true);
                if (this.model instanceof ExPropertyModel) {
                    object = (ExPropertyModel)this.model;
                    this.env.setFeatureDescriptor(object.getFeatureDescriptor());
                    this.env.setBeans(object.getBeans());
                }
                this.envListener = new VetoableChangeListener(){

                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        PropertyPanel.this.refresh();
                    }
                };
                this.env.addVetoableChangeListener(WeakListeners.vetoableChange((VetoableChangeListener)this.envListener, (Object)this.env));
                this.env.addPropertyChangeListener(this.getEditorListener());
                ((ExPropertyEditor)this.editor).attachEnv(this.env);
            }
            try {
                if (this.canRead) {
                    this.editor.setValue(this.model.getValue());
                }
            }
            catch (ProxyNode.DifferentValuesException differentValuesException) {
                this.differentValues = true;
            }
            catch (Exception exception) {
                this.processThrowable(exception);
            }
            if (this.canWrite) {
                this.editor.addPropertyChangeListener(this.getEditorListener());
            }
        }
        this.firePropertyChange(PROP_PROPERTY_EDITOR, propertyEditor, this.editor);
    }

    private void reset() {
        Component component;
        this.isWriteState = false;
        this.isReadState = false;
        if ((this.preferences & 4) != 0) {
            this.setWriteState();
            return;
        }
        if ((this.preferences & 2) != 0 && this.editor != null && (component = this.editor.getCustomEditor()) != null && component.getParent() != this) {
            this.removeAll();
            this.add(component, "Center");
            this.validate();
            return;
        }
        this.setReadState();
    }

    void refresh() {
        if (this.customDialogShown) {
            return;
        }
        if (this.isReadState) {
            // empty if block
        }
        if (this.isWriteState && (this.preferences & 4) == 0) {
            return;
        }
        this.reset();
    }

    void setReadState() {
        if (this.isReadState) {
            return;
        }
        if ((this.preferences & 4) != 0) {
            return;
        }
        if ((this.preferences & 2) != 0) {
            return;
        }
        this.isWriteState = false;
        this.isReadState = false;
        this.removeAll();
        this.readComponent = this.getReaderComponent();
        this.readComponent.addSheetButtonListener(this.getReadComponentListener());
        this.setComponentEnabled(this.readComponent, this.isEnabled());
        this.readComponent.setToolTipText(this.getPanelToolTipText());
        this.updateSheetButtonVisually();
        this.add((Component)this.readComponent, "Center");
        this.revalidate();
        this.repaint();
        this.isReadState = true;
        this.isWriteState = false;
    }

    private ReadComponentListener getReadComponentListener() {
        if (this.readComponentListener == null) {
            this.readComponentListener = new ReadComponentListener();
        }
        return this.readComponentListener;
    }

    private WriteComponentListener getWriteComponentListener() {
        if (this.writeComponentListener == null) {
            this.writeComponentListener = new WriteComponentListener();
        }
        return this.writeComponentListener;
    }

    private PropertyChangeListener getModelListener() {
        if (this.modelListener == null) {
            this.modelListener = new ModelListener();
        }
        return this.modelListener;
    }

    private PropertyChangeListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
            this.weakEditorListener = WeakListeners.propertyChange((PropertyChangeListener)this.editorListener, (Object)this.editor);
        }
        return this.weakEditorListener;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.updateSheetButtonVisually();
    }

    private SheetButton getReaderComponent() {
        String string = null;
        SheetButton sheetButton = null;
        if (this.editor == null) {
            return this.getTextView(NbBundle.getMessage((Class)PropertyPanel.class, (String)"CTL_No_property_editor"));
        }
        try {
            if (!this.differentValues && this.canRead) {
                string = this.editor.getAsText();
            }
            sheetButton = this.editor.isPaintable() && (this.paintingStyle == 3 || this.paintingStyle == 2 && string == null) ? (this.differentValues ? this.getTextView(NbBundle.getMessage((Class)PropertyPanel.class, (String)"CTL_Different_Values")) : this.getPaintView()) : (string == null ? (this.differentValues ? this.getTextView(NbBundle.getMessage((Class)PropertyPanel.class, (String)"CTL_Different_Values")) : this.getTextView(this.getTypeString(this.model.getPropertyType()))) : this.getTextView(string));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, PropertyPanel.getString("PS_ExcIn") + " " + this.editor.getClass().getName() + " " + PropertyPanel.getString("PS_Editor") + ".");
            sheetButton = this.getTextView(this.getExceptionString(exception));
        }
        if (sheetButton == null) {
            sheetButton = this.getTextView("null");
        }
        return sheetButton;
    }

    private SheetButton getTextView(String string) {
        this.textView = new PropertySheetButton(string, this.plastic, this.plastic);
        this.textView.setFocusTraversable(true);
        if (this.sheetButtonListener != null) {
            this.textView.addSheetButtonListener(this.sheetButtonListener);
        }
        if (this.env != null && this.env.getState() != PropertyEnv.STATE_NEEDS_VALIDATION && !this.customDialogShown) {
            Node.Property property;
            this.textView.setInvalidMark(this.env.getState() == PropertyEnv.STATE_INVALID);
            if (this.descriptor instanceof Node.Property && (property = (Node.Property)this.descriptor).supportsDefaultValue()) {
                this.textView.setModifiedMark(!property.isDefaultValue());
            }
        }
        if (this.canWrite) {
            this.textView.setActiveForeground(this.foregroundColor);
        } else {
            this.textView.setActiveForeground(this.disabledColor);
        }
        return this.textView;
    }

    private SheetButton getPaintView() {
        if (this.propertyShow == null) {
            this.propertyShow = new PropertyShow(this.editor);
        } else {
            this.propertyShow.setEditor(this.editor);
        }
        if (this.paintView == null) {
            this.paintView = new PropertySheetButton();
            this.paintView.add(this.propertyShow);
        }
        if (this.sheetButtonListener != null) {
            this.paintView.addSheetButtonListener(this.sheetButtonListener);
        }
        this.paintView.setLabel(this.editor.getAsText());
        this.paintView.setFocusTraversable(true);
        if (this.canWrite) {
            this.paintView.setActiveForeground(this.foregroundColor);
            this.propertyShow.setForeground(this.foregroundColor);
        } else {
            this.paintView.setActiveForeground(this.disabledColor);
            this.propertyShow.setForeground(this.disabledColor);
        }
        if (this.env != null && this.env.getState() != PropertyEnv.STATE_NEEDS_VALIDATION && !this.customDialogShown) {
            Node.Property property;
            this.paintView.setInvalidMark(this.env.getState() == PropertyEnv.STATE_INVALID);
            if (this.descriptor instanceof Node.Property && (property = (Node.Property)this.descriptor).supportsDefaultValue()) {
                this.paintView.setModifiedMark(!property.isDefaultValue());
            }
        }
        this.paintView.setPlastic(this.plastic);
        this.paintView.setToolTipText(this.getPanelToolTipText());
        return this.paintView;
    }

    private JComponent getWriterComponent() {
        Node.Property property;
        if (this.editor == null) {
            return this.getDisabledWriterComponent();
        }
        String string = null;
        boolean bl = true;
        Object object = this.descriptor.getValue(PROP_CAN_EDIT_AS_TEXT);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        try {
            if (this.canRead) {
                string = !this.differentValues ? this.editor.getAsText() : NbBundle.getMessage((Class)PropertyPanel.class, (String)"CTL_Different_Values");
            }
        }
        catch (Exception exception) {
            this.processThrowable(exception);
        }
        if (string == null && object == null) {
            bl = false;
        }
        this.getWriteComponentListener().setOldValue(this.editor.getValue());
        boolean bl2 = this.editor.supportsCustomEditor();
        if (this.editor instanceof EnhancedPropertyEditor && ((EnhancedPropertyEditor)this.editor).hasInPlaceCustomEditor()) {
            return this.getInput(this.getInPlace(), bl2);
        }
        if (this.descriptor instanceof Node.Property && !(property = (Node.Property)this.descriptor).canWrite()) {
            if (bl2) {
                return this.getInput(this.getDisabledWriterComponent(), true);
            }
            return this.getDisabledWriterComponent();
        }
        boolean bl3 = this.editor instanceof EnhancedPropertyEditor && ((EnhancedPropertyEditor)this.editor).supportsEditingTaggedValues();
        String[] stringArray = this.editor.getTags();
        if (stringArray != null) {
            return this.getInput(this.getInputTag(stringArray, string, bl3), bl2);
        }
        if (bl) {
            return this.getInput(this.getInputLine(string == null ? "???" : string, true), bl2);
        }
        if (bl2) {
            return this.getInput(this.getDisabledWriterComponent(), true);
        }
        return this.getDisabledWriterComponent();
    }

    private JComponent getDisabledWriterComponent() {
        SheetButton sheetButton = this.getReaderComponent();
        if (this.descriptor instanceof Node.Property && !((Node.Property)this.descriptor).canWrite()) {
            sheetButton.setActiveForeground(this.disabledColor);
        }
        sheetButton.addFocusListener(this.getWriteComponentListener());
        return sheetButton;
    }

    private JComponent getInputTag(String[] stringArray, String string, boolean bl) {
        this.comboBox = new PropertyComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.comboBox.setMaximumRowCount(stringArray.length <= 12 ? stringArray.length : 8);
        if (string != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.comboBox.setSelectedIndex(i);
                break;
            }
        }
        if (bl) {
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(string);
            this.comboBox.getEditor().setItem(string);
            this.comboBox.getEditor().getEditorComponent().addFocusListener(this.getWriteComponentListener());
            this.comboBox.getEditor().getEditorComponent().addKeyListener(this.getWriteComponentListener());
        }
        this.comboBox.addActionListener(this.getWriteComponentListener());
        this.comboBox.setToolTipText(this.getPanelToolTipText());
        return this.comboBox;
    }

    void tryToSelectNextTag() {
        if (this.comboBox == null) {
            return;
        }
        this.setWriteState();
        int n = this.comboBox.getSelectedIndex();
        if (++n >= this.comboBox.getItemCount()) {
            n = 0;
        }
        this.comboBox.setSelectedIndex(n);
    }

    private Component getInPlace() {
        Component component = ((EnhancedPropertyEditor)this.editor).getInPlaceCustomEditor();
        component.addFocusListener(this.getWriteComponentListener());
        component.addKeyListener(this.getWriteComponentListener());
        if (component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.getPanelToolTipText());
        }
        return component;
    }

    private JComponent getInputLine(String string, boolean bl) {
        this.textField = new PropertyTextField();
        this.textField.addActionListener(this.getWriteComponentListener());
        this.textField.addKeyListener(this.getWriteComponentListener());
        this.textField.addFocusListener(this.getWriteComponentListener());
        this.textField.setText(string);
        this.textField.setEditable(bl);
        this.textField.setToolTipText(this.getPanelToolTipText());
        if (!this.isWriteState) {
            this.textField.selectAll();
        }
        return this.textField;
    }

    private String getExceptionString(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        return "<" + throwable.getClass().getName() + ">";
    }

    private String getTypeString(Class clazz) {
        if (clazz == null) {
            return PropertyPanel.getString("CTL_NoPropertyEditor");
        }
        if (clazz.isArray()) {
            return "[" + PropertyPanel.getString("PS_ArrayOf") + " " + this.getTypeString(clazz.getComponentType()) + "]";
        }
        return "[" + clazz.getName() + "]";
    }

    private JComponent getInput(Component component, boolean bl) {
        JPanel jPanel = component == null && this.editor != null && this.editor.isPaintable() && this.paintingStyle != 1 ? new PropertyShow(this.editor) : new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (component != null) {
            jPanel.add(component, "Center");
        }
        if (bl) {
            jPanel.add((Component)this.getCustomizeButton(), "East");
        }
        jPanel.setToolTipText(this.getPanelToolTipText());
        jPanel.addFocusListener(this.getWriteComponentListener());
        jPanel.addKeyListener(this.getWriteComponentListener());
        return jPanel;
    }

    private SheetButton getCustomizeButton() {
        if (this.customizeButton == null) {
            this.customizeButton = new SheetButton("...", this.plastic, this.plastic);
            this.customizeButton.setFocusTraversable(true);
            Font font = this.customizeButton.getFont();
            this.customizeButton.setFont(new Font(font.getName(), font.getStyle() | 1, font.getSize()));
            this.customizeButton.addFocusListener(this.getWriteComponentListener());
            this.customizeButton.addSheetButtonListener(new CustomizeListener());
            this.customizeButton.setToolTipText(PropertyPanel.getString("CTL_ElipsisHint"));
        }
        if (this.canWrite) {
            this.customizeButton.setActiveForeground(this.foregroundColor);
        } else {
            this.customizeButton.setActiveForeground(this.disabledColor);
        }
        return this.customizeButton;
    }

    private void notifyExceptionWhileSettingProperty(Exception exception) {
        if (this.getPreferences() == 0 || this.getPreferences() == 4) {
            PropertyPanel.notifyUser(exception, this.descriptor.getDisplayName());
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    static void notifyUser(Exception exception, String string) {
        String string2 = PropertyPanel.extractLocalizedMessage(exception);
        if (string2 == null && exception instanceof InvocationTargetException) {
            string2 = PropertyPanel.extractLocalizedMessage(((InvocationTargetException)exception).getTargetException());
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        if (string2 != null) {
            errorManager.annotate((Throwable)exception, NbBundle.getMessage((Class)PropertyPanel.class, (String)"FMT_ErrorSettingProperty", (Object)string2, (Object)string));
            errorManager.notify(256, (Throwable)exception);
        } else {
            errorManager.notify(1, (Throwable)exception);
        }
    }

    private static String extractLocalizedMessage(Throwable throwable) {
        ErrorManager errorManager = ErrorManager.getDefault();
        ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations(throwable);
        String string = null;
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                String string2 = annotationArray[i].getLocalizedMessage();
                if (string2 == null) continue;
                string = string2;
                break;
            }
        }
        if (string == null) {
            string = throwable.getLocalizedMessage();
        }
        return string;
    }

    private void processThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.annotate(throwable, NbBundle.getMessage((Class)PropertyPanel.class, (String)"FMT_ErrorSettingProperty", (Object)throwable.getLocalizedMessage(), (Object)this.descriptor.getDisplayName()));
        errorManager.notify(throwable);
    }

    private void setComponentEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (Container.class.isAssignableFrom(component.getClass())) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(bl);
                this.setComponentEnabled(componentArray[i], bl);
            }
        }
    }

    private String getPanelToolTipText() {
        String string = this.getToolTipText();
        if (string != null) {
            return string;
        }
        if (this.editor == null) {
            return null;
        }
        if (this.differentValues) {
            return NbBundle.getMessage((Class)PropertyPanel.class, (String)"CTL_Desc_Different_Values");
        }
        if (this.canRead) {
            return this.editor.getAsText();
        }
        return null;
    }

    private void updateSheetButtonVisually() {
        boolean bl = false;
        Object object = this.getClientProperty("flat");
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (this.readComponent != null) {
            this.readComponent.setFlat(bl);
            this.readComponent.setBackground(this.getBackground());
        }
        if (this.propertyShow != null) {
            this.propertyShow.setBackground(this.getBackground());
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)PropertyPanel.class, (String)string);
    }

    public void requestFocus() {
        this.requestDefaultFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyPanel();
        }
        return this.accessibleContext;
    }

    private String getWriteComponentAccessibleName() {
        String string = this.getAccessibleContext().getAccessibleName();
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage((Class)PropertyPanel.class, (String)"ACS_PropertyPanelWriteComponent", (Object)string, (Object)(this.editor == null ? PropertyPanel.getString("CTL_No_value") : this.editor.getAsText()));
    }

    private String getWriteComponentAccessibleDescription() {
        String string = this.getAccessibleContext().getAccessibleDescription();
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage((Class)PropertyPanel.class, (String)"ACSD_PropertyPanelWriteComponent", (Object)string, (Object)this.getPanelToolTipText());
    }

    private class PropertySheetButton
    extends SheetButton {
        PropertySheetButton() {
        }

        PropertySheetButton(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertySheetButton();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertySheetButton
        extends SheetButton.AccessibleSheetButton {
            AccessiblePropertySheetButton() {
                super(PropertySheetButton.this);
            }

            public String getAccessibleName() {
                return this.getReadComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return this.getReadComponentAccessibleDescription();
            }

            private String getReadComponentAccessibleName() {
                String string = PropertyPanel.this.getAccessibleContext().getAccessibleName();
                if (string == null) {
                    return null;
                }
                return NbBundle.getMessage((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel = PropertyPanel.class$("com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel")) : class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel), (String)"ACS_PropertyPanelReadComponent", (Object)string, (Object)super.getAccessibleName());
            }

            private String getReadComponentAccessibleDescription() {
                Object[] objectArray;
                String string = PropertyPanel.this.getAccessibleContext().getAccessibleDescription();
                if (string == null) {
                    return null;
                }
                String string2 = null;
                int n = 0;
                if (PropertyPanel.this.model instanceof ExPropertyModel) {
                    objectArray = ((ExPropertyModel)PropertyPanel.this.model).getBeans();
                    String string3 = PropertyPanel.getString("ACSD_BeanListDelimiter");
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof Node)) continue;
                        Node node = (Node)objectArray[i];
                        string2 = (string2 == null ? "" : string2 + string3) + node.getDisplayName();
                        ++n;
                    }
                }
                objectArray = PropertyPanel.this.model.getPropertyType();
                return NbBundle.getMessage((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel = PropertyPanel.class$("com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel")) : class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel), (String)"ACSD_PropertyPanelReadComponent", (Object[])new Object[]{string, objectArray == null ? PropertyPanel.getString("CTL_No_type") : objectArray.getName(), new Integer(n), string2});
            }
        }
    }

    private class PropertyComboBox
    extends JComboBox {
        PropertyComboBox() {
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertyComboBox();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertyComboBox
        extends JComboBox.AccessibleJComboBox {
            AccessiblePropertyComboBox() {
                super(PropertyComboBox.this);
            }

            public String getAccessibleName() {
                return PropertyPanel.this.getWriteComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return PropertyPanel.this.getWriteComponentAccessibleDescription();
            }
        }
    }

    private class PropertyTextField
    extends JTextField {
        PropertyTextField() {
        }

        public void setDocument(Document document) {
            super.setDocument(document);
            if (document != null) {
                document.putProperty("filterNewlines", null);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertyTextField();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertyTextField
        extends JTextField.AccessibleJTextField {
            private AccessiblePropertyTextField() {
                super(PropertyTextField.this);
            }

            public String getAccessibleName() {
                return PropertyPanel.this.getWriteComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return PropertyPanel.this.getWriteComponentAccessibleDescription();
            }
        }
    }

    private class AccessiblePropertyPanel
    extends JComponent.AccessibleJComponent {
        AccessiblePropertyPanel() {
            super(PropertyPanel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                string = NbBundle.getMessage((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel = PropertyPanel.class$("com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel")) : class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel), (String)"ACS_PropertyPanel", (Object)featureDescriptor.getDisplayName());
            }
            return string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                string = NbBundle.getMessage((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel = PropertyPanel.class$("com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel")) : class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel), (String)"ACSD_PropertyPanel", (Object)featureDescriptor.getShortDescription());
            }
            return string;
        }
    }

    private class EditorListener
    implements PropertyChangeListener {
        EditorListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof PropertyEnv) {
                if (PropertyPanel.PROP_STATE.equals(propertyChangeEvent.getPropertyName())) {
                    PropertyPanel.this.firePropertyChange(PropertyPanel.PROP_STATE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
                return;
            }
            if (PropertyPanel.this.ignoreEvents) {
                return;
            }
            if (!PropertyPanel.this.isWriteState && !PropertyPanel.this.customDialogShown && PropertyPanel.this.preferences < 2) {
                return;
            }
            if (PropertyPanel.this.env != null && !PropertyPanel.this.env.isChangeImmediate() && PropertyPanel.this.customDialogShown) {
                return;
            }
            if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (PropertyPanel.this.editor != null) {
                try {
                    PropertyPanel.this.ignoreEvents = true;
                    Object object = PropertyPanel.this.editor.getValue();
                    Object object2 = null;
                    try {
                        if (PropertyPanel.this.canRead) {
                            object2 = PropertyPanel.this.model.getValue();
                        }
                    }
                    catch (ProxyNode.DifferentValuesException differentValuesException) {
                        // empty catch block
                    }
                    if (object != null && !object.equals(object2) || object == null && object2 != null) {
                        PropertyPanel.this.model.setValue(object);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyPanel.this.notifyExceptionWhileSettingProperty(invocationTargetException);
                    try {
                        if (PropertyPanel.this.canRead) {
                            PropertyPanel.this.editor.setValue(PropertyPanel.this.model.getValue());
                        }
                    }
                    catch (ProxyNode.DifferentValuesException differentValuesException) {
                    }
                    catch (Exception exception) {
                        PropertyDialogManager.notify(exception);
                    }
                }
                finally {
                    PropertyPanel.this.ignoreEvents = false;
                }
            }
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        ModelListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName()) && PropertyPanel.this.editor != null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            PropertyPanel.this.ignoreEvents = true;
                            PropertyPanel.this.differentValues = false;
                            Object object = PropertyPanel.this.model.getValue();
                            Object object2 = PropertyPanel.this.editor.getValue();
                            if (object != null && !object.equals(object2) || object == null && object2 != null) {
                                PropertyPanel.this.editor.setValue(object);
                            }
                            PropertyPanel.this.refresh();
                        }
                        catch (ProxyNode.DifferentValuesException differentValuesException) {
                            PropertyPanel.this.differentValues = true;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            PropertyPanel.this.notifyExceptionWhileSettingProperty(invocationTargetException);
                        }
                        finally {
                            PropertyPanel.this.ignoreEvents = false;
                        }
                    }
                });
            }
        }
    }

    private final class CustomizeListener
    implements SheetButtonListener {
        CustomizeListener() {
        }

        public void sheetButtonExited(ActionEvent actionEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sheetButtonClicked(ActionEvent actionEvent) {
            Object object;
            Object object2;
            String string = PropertyPanel.this.descriptor.getDisplayName();
            PropertyPanel.this.customDialogShown = true;
            if (PropertyPanel.this.textField != null) {
                try {
                    if (PropertyPanel.this.editor.getValue() == null || !PropertyPanel.this.textField.getText().equals(PropertyPanel.this.editor.getAsText())) {
                        PropertyPanel.this.editor.setAsText(PropertyPanel.this.textField.getText());
                    }
                }
                catch (ProxyNode.DifferentValuesException differentValuesException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            final Container container = PropertyPanel.this.getTopLevelAncestor();
            container.setCursor(Cursor.getPredefinedCursor(3));
            AWTEventListener aWTEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                    container.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            try {
                object2 = new PropertyDialogManager(NbBundle.getMessage((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel = PropertyPanel.class$("com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel")) : class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel), (String)"PS_EditorTitle", (Object)(string == null ? "" : string), (Object)PropertyPanel.this.model.getPropertyType()), true, PropertyPanel.this.editor, PropertyPanel.this.model, PropertyPanel.this.env);
                object = ((PropertyDialogManager)object2).getDialog();
                Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 1L);
                ((Window)object).show();
            }
            finally {
                Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
                container.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (PropertyPanel.this.canRead) {
                try {
                    PropertyPanel.this.ignoreEvents = true;
                    object2 = PropertyPanel.this.model.getValue();
                    object = PropertyPanel.this.editor.getValue();
                    if (object2 != null && !object2.equals(object) || object2 == null && object != null) {
                        PropertyPanel.this.editor.setValue(object2);
                    }
                }
                catch (ProxyNode.DifferentValuesException differentValuesException) {
                    PropertyPanel.this.differentValues = true;
                }
                catch (Exception exception) {
                    PropertyPanel.this.processThrowable(exception);
                }
                finally {
                    PropertyPanel.this.ignoreEvents = false;
                }
            }
            PropertyPanel.this.reset();
            PropertyPanel.this.requestFocus();
            PropertyPanel.this.customDialogShown = false;
        }

        public void sheetButtonEntered(ActionEvent actionEvent) {
        }
    }

    private final class ReadComponentListener
    implements SheetButtonListener {
        ReadComponentListener() {
        }

        public void sheetButtonExited(ActionEvent actionEvent) {
        }

        public void sheetButtonClicked(ActionEvent actionEvent) {
            if ("rightMouseActionCommand".equals(actionEvent.getActionCommand()) || PropertyPanel.this.isWriteState) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PropertyPanel.this.setWriteState();
                }
            });
        }

        public void sheetButtonEntered(ActionEvent actionEvent) {
        }
    }

    private final class WriteComponentListener
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private Object oldValue;
        private Runnable comboActionTask;
        private Runnable requestFocusTask;

        WriteComponentListener() {
        }

        private void setOldValue(Object object) {
            this.oldValue = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PropertyPanel.this.isWriteState) {
                return;
            }
            if (actionEvent.getSource() == PropertyPanel.this.comboBox) {
                SwingUtilities.invokeLater(this.getComboActionTask());
            } else {
                if (actionEvent.getSource() == PropertyPanel.this.textField) {
                    String string = PropertyPanel.this.textField.getText();
                    this.changeValue(string);
                }
                this.prepareReadState();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            if (keyEvent.getKeyCode() == 27) {
                if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isPopupVisible() && object instanceof Component && SwingUtilities.isDescendingFrom((Component)object, PropertyPanel.this.comboBox)) {
                    this.resetOldValue();
                } else if (object == PropertyPanel.this.textField) {
                    this.resetOldValue();
                    keyEvent.consume();
                }
                this.prepareReadState();
            } else if (keyEvent.getKeyCode() == 10 && PropertyPanel.this.comboBox != null && object instanceof Component && SwingUtilities.isDescendingFrom((Component)object, PropertyPanel.this.comboBox) && !PropertyPanel.this.comboBox.isEditable() && (PropertyPanel.this.preferences & 4) == 0) {
                this.changeValue((String)PropertyPanel.this.comboBox.getSelectedItem());
                this.prepareReadState();
            }
        }

        public void focusLost(final FocusEvent focusEvent) {
            boolean bl;
            if (!PropertyPanel.this.isWriteState) {
                return;
            }
            if (PropertyPanel.this.comboBox != null && focusEvent.isTemporary()) {
                return;
            }
            final boolean bl2 = PropertyPanel.this.differentValues && focusEvent.getSource().equals(PropertyPanel.this.textField) && NbBundle.getMessage((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel = PropertyPanel.class$("com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel")) : class$com$hp$openvms$netbeans$cppsupport$prop$PropertyPanel), (String)"CTL_Different_Values").equals(PropertyPanel.this.textField.getText());
            boolean bl3 = bl = PropertyPanel.this.editor != null && PropertyPanel.this.editor.supportsCustomEditor();
            if (bl || PropertyPanel.this.comboBox != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (focusEvent.getSource().equals(PropertyPanel.this.textField) && !bl2) {
                            WriteComponentListener.this.changeValue(PropertyPanel.this.textField.getText());
                            if (PropertyPanel.this.editor != null && !PropertyPanel.this.editor.getAsText().equals(PropertyPanel.this.textField.getText())) {
                                PropertyPanel.this.textField.setText(PropertyPanel.this.editor.getAsText());
                            }
                        }
                        if (SwingUtilities.findFocusOwner(PropertyPanel.this) == null && PropertyPanel.this.isWriteState) {
                            if (!bl2) {
                                WriteComponentListener.this.resetReadState(focusEvent);
                            } else {
                                PropertyPanel.this.setReadState();
                            }
                        }
                    }
                });
            } else if (!bl2) {
                this.resetReadState(focusEvent);
            } else {
                PropertyPanel.this.setReadState();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyPanel.this.textField) {
                PropertyPanel.this.textField.selectAll();
            } else if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isEditable()) {
                PropertyPanel.this.comboBox.getEditor().selectAll();
            }
        }

        public void changeValue(String string) {
            if (!(string == null || PropertyPanel.this.editor.getValue() != null && string.equals(PropertyPanel.this.editor.getAsText()) || this.setAsText(string))) {
                this.resetOldValue();
            }
        }

        private synchronized Runnable getComboActionTask() {
            if (this.comboActionTask == null) {
                this.comboActionTask = new Runnable(){

                    public void run() {
                        if (PropertyPanel.this.comboBox.isPopupVisible() || !PropertyPanel.this.isWriteState) {
                            return;
                        }
                        WriteComponentListener.this.changeValue((String)PropertyPanel.this.comboBox.getSelectedItem());
                        WriteComponentListener.this.prepareReadState();
                    }
                };
            }
            return this.comboActionTask;
        }

        private synchronized Runnable getRequestFocusTask() {
            if (this.requestFocusTask == null) {
                this.requestFocusTask = new Runnable(){

                    public void run() {
                        Component component = PropertyPanel.getDefaultFocusComponent(PropertyPanel.this);
                        if (component != null) {
                            component.requestFocus();
                        }
                    }
                };
            }
            return this.requestFocusTask;
        }

        private void prepareReadState() {
            boolean bl = SwingUtilities.findFocusOwner(PropertyPanel.this) != null;
            PropertyPanel.this.setReadState();
            if (bl) {
                SwingUtilities.invokeLater(this.getRequestFocusTask());
            }
        }

        private void resetReadState(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyPanel.this.customizeButton && PropertyPanel.this.textField != null) {
                this.changeValue(PropertyPanel.this.textField.getText());
            } else if (focusEvent.getSource() == PropertyPanel.this.textField) {
                this.changeValue(PropertyPanel.this.textField.getText());
            } else if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isEditable()) {
                this.changeValue((String)PropertyPanel.this.comboBox.getEditor().getItem());
            }
            PropertyPanel.this.setReadState();
        }

        private void resetOldValue() {
            try {
                if (!PropertyPanel.this.differentValues) {
                    PropertyPanel.this.editor.setValue(this.oldValue);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PropertyPanel.this.notifyExceptionWhileSettingProperty(illegalArgumentException);
            }
            catch (RuntimeException runtimeException) {
                PropertyPanel.this.processThrowable(runtimeException);
            }
        }

        private boolean setAsText(String string) {
            try {
                PropertyPanel.this.editor.setAsText(string);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PropertyPanel.this.notifyExceptionWhileSettingProperty(illegalArgumentException);
            }
            catch (RuntimeException runtimeException) {
                PropertyPanel.this.processThrowable(runtimeException);
            }
            return false;
        }
    }

    static class SimpleModel
    implements ExPropertyModel {
        private Node.Property prop;
        private Object[] beans;
        private PropertyChangeSupport sup = new PropertyChangeSupport(this);

        public SimpleModel(Node.Property property, Object[] objectArray) {
            this.prop = property;
            this.beans = objectArray;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.annotateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.annotateException(invocationTargetException);
            }
        }

        public void setValue(Object object) throws InvocationTargetException {
            try {
                this.prop.setValue(object);
                this.sup.firePropertyChange("value", null, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.annotateException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.annotateException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.annotateException(invocationTargetException);
            }
        }

        private InvocationTargetException annotateException(Exception exception) {
            if (exception instanceof InvocationTargetException) {
                return (InvocationTargetException)exception;
            }
            return new InvocationTargetException(exception);
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            PropertyEditor propertyEditor = this.prop.getPropertyEditor();
            if (propertyEditor != null) {
                return propertyEditor.getClass();
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.sup.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.sup.removePropertyChangeListener(propertyChangeListener);
        }

        public Object[] getBeans() {
            return this.beans;
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }

        void fireValueChanged() {
            this.sup.firePropertyChange("value", null, null);
        }
    }

    private static class EmptyModel
    implements PropertyModel {
        EmptyModel() {
        }

        public Object getValue() throws InvocationTargetException {
            return null;
        }

        public void setValue(Object object) throws InvocationTargetException {
        }

        public Class getPropertyType() {
            return class$java$lang$Object == null ? (class$java$lang$Object = PropertyPanel.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public Class getPropertyEditorClass() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    static class PropertySheetSettingsInvoker
    implements Runnable {
        PropertySheetSettingsInvoker() {
        }

        public void run() {
            PropertyPanel propertyPanel = (PropertyPanel)current.get();
            current.set(null);
            if (propertyPanel == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings propertySheetSettings = PropertySheetSettings.getDefault();
            propertyPanel.paintingStyle = propertySheetSettings.getPropertyPaintingStyle();
            propertyPanel.plastic = propertySheetSettings.getPlastic();
            propertyPanel.disabledColor = propertySheetSettings.getDisabledPropertyColor();
            propertyPanel.foregroundColor = propertySheetSettings.getValueColor();
        }
    }
}

