/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.editor.ccpp;

import com.hp.openvms.netbeans.cppsupport.editor.ccpp.CCTokenContext;
import com.hp.openvms.netbeans.cppsupport.editor.ccpp.JavaLayerTokenContext;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;

public class JavaDrawLayerFactory {
    public static final String JAVA_LAYER_NAME = "cc-layer";
    public static final int JAVA_LAYER_VISIBILITY = 1010;

    public static class LParenWatcher
    implements DocumentListener {
        NonWhitespaceBwdFinder nwFinder = new NonWhitespaceBwdFinder();

        private void check(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() instanceof BaseDocument) {
                BaseDocument baseDocument = (BaseDocument)documentEvent.getDocument();
                BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
                char[] cArray = baseDocumentEvent.getChars();
                if (cArray != null) {
                    int n;
                    boolean bl = false;
                    for (n = cArray.length - 1; n >= 0; --n) {
                        if (cArray[n] != '(') continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        n = documentEvent.getOffset();
                        int n2 = 0;
                        if (n > 0) {
                            try {
                                n2 = baseDocument.find((Finder)this.nwFinder, n - 1, 0);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            if (n2 < 0) {
                                n2 = 0;
                            }
                        }
                        baseDocument.repaintBlock(n2, n);
                    }
                }
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.check(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.check(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    public static class NonWhitespaceBwdFinder
    extends FinderFactory.GenericBwdFinder {
        private char foundChar;

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char c, boolean bl) {
            if (!Character.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return -1;
        }
    }

    static class NonWhitespaceFwdFinder
    extends FinderFactory.GenericFwdFinder {
        private char foundChar;

        NonWhitespaceFwdFinder() {
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char c, boolean bl) {
            if (!Character.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return 1;
        }
    }

    public static class JavaLayer
    extends DrawLayer.AbstractLayer {
        private int resolvedEndOffset;
        private boolean resolvedValue;
        private NonWhitespaceFwdFinder nwFinder = new NonWhitespaceFwdFinder();

        public JavaLayer() {
            super(JavaDrawLayerFactory.JAVA_LAYER_NAME);
        }

        public void init(DrawContext drawContext) {
            this.resolvedEndOffset = 0;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n = drawContext.getTokenOffset() + drawContext.getTokenLength();
            this.setNextActivityChangeOffset(n);
            return true;
        }

        protected Coloring getMethodColoring(DrawContext drawContext) {
            TokenContextPath tokenContextPath = drawContext.getTokenContextPath().replaceStart(JavaLayerTokenContext.contextPath);
            return drawContext.getEditorUI().getColoring(tokenContextPath.getFullTokenName((TokenCategory)JavaLayerTokenContext.METHOD));
        }

        private boolean isMethod(DrawContext drawContext) {
            int n = drawContext.getTokenOffset() + drawContext.getTokenLength();
            if (n > this.resolvedEndOffset) {
                this.resolvedEndOffset = n;
                int n2 = drawContext.getEndOffset();
                int n3 = drawContext.getBufferStartOffset();
                char[] cArray = drawContext.getBuffer();
                int n4 = Analyzer.findFirstNonWhite((char[])cArray, (int)(n - n3), (int)(n2 - n));
                if (n4 >= 0) {
                    this.resolvedValue = cArray[n4] == '(';
                } else {
                    try {
                        this.resolvedValue = drawContext.getEditorUI().getDocument().find((Finder)this.nwFinder, n2, -1) >= 0 && this.nwFinder.getFoundChar() == '(';
                    }
                    catch (BadLocationException badLocationException) {
                        this.resolvedValue = false;
                    }
                }
            }
            return this.resolvedValue;
        }

        public void updateContext(DrawContext drawContext) {
            Coloring coloring;
            if (drawContext.getTokenID() == CCTokenContext.IDENTIFIER && this.isMethod(drawContext) && (coloring = this.getMethodColoring(drawContext)) != null) {
                coloring.apply(drawContext);
            }
        }
    }
}

