/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.openide.ErrorManager;
import org.openide.compiler.ExternalCompiler;
import org.openide.filesystems.FileObject;

public final class RemoteOutputParser {
    private static RemoteOutputParser antOutputParser;

    public static synchronized RemoteOutputParser getDefault() {
        if (antOutputParser == null) {
            antOutputParser = new RemoteOutputParser();
        }
        return antOutputParser;
    }

    private RemoteOutputParser() {
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    private static RE getErrorPattern(ExternalCompiler.ErrorExpression errorExpression) {
        String string = errorExpression.getErrorExpression();
        try {
            RECompiler rECompiler = new RECompiler();
            REProgram rEProgram = rECompiler.compile(string);
            RE rE = new RE(rEProgram, 2);
            return rE;
        }
        catch (RESyntaxException rESyntaxException) {
            ErrorManager.getDefault().notify((Throwable)rESyntaxException);
            return null;
        }
    }

    public Result parse(String string, ExternalCompiler.ErrorExpression errorExpression, String string2, FileObject fileObject) {
        RE rE = RemoteOutputParser.getErrorPattern(errorExpression);
        ReaderCharacterIterator readerCharacterIterator = new ReaderCharacterIterator((Reader)new BufferedReader(new StringReader(string)));
        String string3 = null;
        int n = 0;
        if (rE.match((CharacterIterator)readerCharacterIterator, n)) {
            String string4;
            int n2;
            int n3;
            if (errorExpression.getFilePos() < 0) {
                return null;
            }
            int n4 = 0;
            int n5 = rE.getParenCount() - 1;
            String string5 = rE.getParen(errorExpression.getFilePos());
            if (errorExpression.getLinePos() < n4 || errorExpression.getLinePos() > n5) {
                n3 = 1;
            } else {
                try {
                    n3 = Integer.parseInt(rE.getParen(errorExpression.getLinePos()));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 1;
                }
            }
            if (n3 > 0) {
                --n3;
            }
            if (errorExpression.getColumnPos() < n4 || errorExpression.getColumnPos() > n5) {
                n2 = 1;
            } else {
                try {
                    n2 = Integer.parseInt(rE.getParen(errorExpression.getColumnPos()));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 1;
                }
            }
            string3 = errorExpression.getDescriptionPos() < n4 || errorExpression.getDescriptionPos() > n5 ? "" : ((string4 = rE.getParen(errorExpression.getDescriptionPos())) == null ? "" : string4.trim());
            String string6 = "";
            string4 = readerCharacterIterator.substring(n, rE.getParenStart(0));
            if (!string4.equals("")) {
                return null;
            }
            FileObject fileObject2 = null;
            if (!string2.equals("") && string2.equalsIgnoreCase(string5)) {
                fileObject2 = fileObject;
            } else {
                FileObject fileObject3 = fileObject2 = string5 != null ? this.findFO(string5) : null;
            }
            if (fileObject2 == null) {
                return null;
            }
            return new Result(fileObject2, string5, n3, n2, -1, -1, string3 + " " + string6);
        }
        return null;
    }

    private FileObject findFO(String string) {
        FileObject[] fileObjectArray;
        if (string.charAt(0) != '/') {
            string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
        }
        if ((fileObjectArray = RemoteFSUtils.fromFile((String)string)).length > 0) {
            return fileObjectArray[0];
        }
        return null;
    }

    public static final class Result {
        private FileObject fo;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private String fname;

        public Result(FileObject fileObject, String string, int n, int n2, int n3, int n4, String string2) {
            this.fo = fileObject;
            this.fname = string;
            this.line1 = n;
            this.col1 = n2;
            this.line2 = n3;
            this.col2 = n4;
            this.message = string2;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public String getFileName() {
            return this.fname;
        }

        public int getLineStart() {
            return this.line1;
        }

        public int getLineEnd() {
            return this.line2;
        }

        public int getColumnStart() {
            return this.col1;
        }

        public int getColumnEnd() {
            return this.col2;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

