/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.NewProjectWizard;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NewProject
extends BasicAction {
    private static final Icon ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/newProject.gif"));
    private static final String NAME = NbBundle.getMessage((Class)NewProject.class, (String)"LBL_NewProjectAction_Name");
    private boolean isPreselect = false;
    private RequestProcessor.Task bodyTask;

    public NewProject() {
        super(NAME, ICON);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newProject.gif");
        this.bodyTask = new RequestProcessor("NewProjectBody").create(new Runnable(){

            public void run() {
                NewProject.this.doPerform();
            }
        });
    }

    public static NewProject newSample() {
        NewProject np = new NewProject();
        np.setDisplayName("New Sample");
        np.isPreselect = true;
        return np;
    }

    public void actionPerformed(ActionEvent evt) {
        this.bodyTask.schedule(0);
        if ("waitFinished".equals(evt.getActionCommand())) {
            this.bodyTask.waitFinished();
        }
    }

    NewProjectWizard prepareWizardDescriptor(FileObject fo) {
        NewProjectWizard wizard = new NewProjectWizard(fo);
        if (this.isPreselect) {
            wizard.putProperty("PRESELECT_CATEGORY", this.getValue("PRESELECT_CATEGORY"));
            wizard.putProperty("PRESELECT_TEMPLATE", this.getValue("PRESELECT_TEMPLATE"));
        } else {
            wizard.putProperty("PRESELECT_CATEGORY", null);
            wizard.putProperty("PRESELECT_TEMPLATE", null);
        }
        FileObject folder = (FileObject)this.getValue("existingSourcesFolder");
        if (folder != null) {
            wizard.putProperty("existingSourcesFolder", folder);
        }
        return wizard;
    }

    private void doPerform() {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Project");
        final NewProjectWizard wizard = this.prepareWizardDescriptor(fo);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Set newObjects = wizard.instantiate();
                    Object mainProperty = wizard.getProperty("setAsMain");
                    boolean setFirstMain = true;
                    if (mainProperty instanceof Boolean) {
                        setFirstMain = (Boolean)mainProperty;
                    }
                    boolean setFirstMainFinal = setFirstMain;
                    ProjectManager.getDefault().clearNonProjectCache();
                    ProjectUtilities.WaitCursor.show();
                    if (newObjects != null && !newObjects.isEmpty()) {
                        LinkedList<DataObject> filesToOpen = new LinkedList<DataObject>();
                        LinkedList<Project> projectsToOpen = new LinkedList<Project>();
                        Iterator it = newObjects.iterator();
                        while (it.hasNext()) {
                            FileObject newFo;
                            DataObject newDo;
                            block18: {
                                Object obj = it.next();
                                if (obj instanceof DataObject) {
                                    newDo = (DataObject)obj;
                                    newFo = newDo.getPrimaryFile();
                                } else {
                                    if (obj instanceof FileObject) {
                                        newFo = (FileObject)obj;
                                        try {
                                            newDo = DataObject.find((FileObject)newFo);
                                            break block18;
                                        }
                                        catch (DataObjectNotFoundException e) {
                                            ErrorManager.getDefault().notify(1, (Throwable)e);
                                            continue;
                                        }
                                    }
                                    ErrorManager.getDefault().log(16, "Found unrecognized object " + obj + " in result set from instantiate()");
                                    continue;
                                }
                            }
                            if (newFo.isFolder()) {
                                try {
                                    Project p = ProjectManager.getDefault().findProject(newFo);
                                    if (p != null) {
                                        projectsToOpen.add(p);
                                        continue;
                                    }
                                    filesToOpen.add(newDo);
                                }
                                catch (IOException e) {
                                    ErrorManager.getDefault().notify(1, (Throwable)e);
                                }
                                continue;
                            }
                            filesToOpen.add(newDo);
                        }
                        Project lastProject = projectsToOpen.size() > 0 ? (Project)projectsToOpen.get(0) : null;
                        OpenProjectList.getDefault().open(projectsToOpen.toArray(new Project[0]), false, true);
                        if (setFirstMainFinal && lastProject != null) {
                            OpenProjectList.getDefault().setMainProject(lastProject);
                        }
                        ProjectUtilities.makeProjectTabVisible(true);
                        if (filesToOpen.isEmpty() && lastProject != null) {
                            ProjectUtilities.selectAndExpandProject(lastProject);
                        } else {
                            Iterator it2 = filesToOpen.iterator();
                            while (it2.hasNext()) {
                                ProjectUtilities.openAndSelectNewObject((DataObject)it2.next());
                            }
                        }
                    }
                    ProjectUtilities.WaitCursor.hide();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        });
    }
}

