/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

class ActionsUtil {
    public static LookupResultsCache lookupResultsCache;
    public static final ShortcutsManager SHORCUTS_MANAGER;
    public static HashMap pattern2format;

    ActionsUtil() {
    }

    public static Project[] getProjectsFromLookup(Lookup lookup, String command) {
        if (lookupResultsCache == null) {
            lookupResultsCache = new LookupResultsCache(new Class[]{Project.class, DataObject.class});
        }
        Project[] projectsArray = lookupResultsCache.getProjects(lookup);
        if (command != null) {
            for (int i = 0; i < projectsArray.length; ++i) {
                if (ActionsUtil.commandSupported(projectsArray[i], command, lookup)) continue;
                return new Project[0];
            }
        }
        return projectsArray;
    }

    public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        Collection dataObjects = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
        Iterator it = dataObjects.iterator();
        while (it.hasNext()) {
            DataObject dObj = (DataObject)it.next();
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null || !p.equals(project)) continue;
            result.add(fObj);
        }
        FileObject[] fos = new FileObject[result.size()];
        result.toArray(fos);
        return fos;
    }

    public static boolean commandSupported(Project project, String command, Lookup context) {
        List<String> commands;
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        return ap != null && (commands = Arrays.asList(ap.getSupportedActions())).contains(command) && (context == null || ap.isActionEnabled(command, context));
    }

    public static String formatProjectSensitiveName(String namePattern, Project[] projects) {
        if (projects == null || projects.length == 0) {
            return ActionsUtil.formatName(namePattern, 0, null);
        }
        return ActionsUtil.formatName(namePattern, projects.length, ProjectUtils.getInformation((Project)projects[0]).getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatName(String namePattern, int numberOfObjects, String firstObjectName) {
        MessageFormat mf = null;
        HashMap hashMap = pattern2format;
        synchronized (hashMap) {
            mf = (MessageFormat)pattern2format.get(namePattern);
            if (mf == null) {
                mf = new MessageFormat(namePattern);
                pattern2format.put(namePattern, mf);
            }
        }
        StringBuffer result = new StringBuffer();
        mf.format(new Object[]{new Integer(numberOfObjects), firstObjectName == null ? "" : firstObjectName}, result, (FieldPosition)null);
        return result.toString();
    }

    static {
        SHORCUTS_MANAGER = new ShortcutsManager();
        pattern2format = new HashMap();
    }

    private static class LookupResultsCache
    implements LookupListener {
        private Class[] watch;
        private Reference lruLookup;
        private List lruResults;
        private Project[] projects;

        LookupResultsCache(Class[] watch) {
            this.watch = watch;
        }

        public synchronized Project[] getProjects(Lookup lookup) {
            Lookup.Result result;
            Lookup lruLookupLocal;
            Lookup lookup2 = lruLookupLocal = this.lruLookup != null ? (Lookup)this.lruLookup.get() : null;
            if (lookup != lruLookupLocal) {
                if (this.lruResults != null) {
                    Iterator i = this.lruResults.iterator();
                    while (i.hasNext()) {
                        result = (Lookup.Result)((Reference)i.next()).get();
                        if (result == null) continue;
                        result.removeLookupListener((LookupListener)this);
                    }
                    this.lruResults = null;
                }
                this.makeDirty();
                lruLookupLocal = null;
            }
            if (lruLookupLocal == null) {
                lruLookupLocal = lookup;
                this.lruLookup = new CleanableWeakReference(lruLookupLocal);
                this.lruResults = new ArrayList();
                for (int i = 0; i < this.watch.length; ++i) {
                    result = lookup.lookup(new Lookup.Template(this.watch[i]));
                    result.allItems();
                    result.addLookupListener((LookupListener)this);
                    this.lruResults.add(new CleanableWeakReference(result));
                }
            }
            if (this.isDirty()) {
                HashSet<Project> result2 = new HashSet<Project>();
                Collection currentProjects = lruLookupLocal.lookup(new Lookup.Template(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ActionsUtil.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project)).allInstances();
                Iterator it = currentProjects.iterator();
                while (it.hasNext()) {
                    Project p = (Project)it.next();
                    result2.add(p);
                }
                Collection currentDataObjects = lruLookupLocal.lookup(new Lookup.Template(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ActionsUtil.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)).allInstances();
                Iterator it2 = currentDataObjects.iterator();
                while (it2.hasNext()) {
                    DataObject dObj = (DataObject)it2.next();
                    FileObject fObj = dObj.getPrimaryFile();
                    Project p = FileOwnerQuery.getOwner((FileObject)fObj);
                    if (p == null) continue;
                    result2.add(p);
                }
                this.projects = new Project[result2.size()];
                result2.toArray(this.projects);
            }
            return this.projects;
        }

        private boolean isDirty() {
            return this.projects == null;
        }

        private synchronized void makeDirty() {
            this.projects = null;
        }

        public void resultChanged(LookupEvent e) {
            this.makeDirty();
        }

        static /* synthetic */ Project[] access$202(LookupResultsCache x0, Project[] x1) {
            x0.projects = x1;
            return x1;
        }

        private class CleanableWeakReference
        extends WeakReference
        implements Runnable {
            public CleanableWeakReference(Object o) {
                super(o, Utilities.activeReferenceQueue());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LookupResultsCache lookupResultsCache = LookupResultsCache.this;
                synchronized (lookupResultsCache) {
                    LookupResultsCache.this.lruLookup = null;
                    LookupResultsCache.this.lruResults = null;
                    LookupResultsCache.access$202(LookupResultsCache.this, null);
                }
            }
        }
    }

    public static class ShortcutsManager {
        HashMap shorcuts = new HashMap();
        HashMap actions = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAction(String command, Action action) {
            ShortcutsManager shortcutsManager = this;
            synchronized (shortcutsManager) {
                Set commandActions = (Set)this.actions.get(command);
                if (commandActions == null) {
                    commandActions = new WeakSet();
                    this.actions.put(command, commandActions);
                }
                commandActions.add(action);
            }
            Object shorcut = this.getShortcut(command);
            if (shorcut != null) {
                action.putValue("AcceleratorKey", shorcut);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerShortcut(String command, Object shortcut) {
            HashSet actionsToChange = null;
            ShortcutsManager shortcutsManager = this;
            synchronized (shortcutsManager) {
                Object exShorcut = this.getShortcut(command);
                if (exShorcut != null && exShorcut.equals(shortcut) || exShorcut == null && shortcut == null) {
                    return;
                }
                this.shorcuts.put(command, shortcut);
                Set commandActions = (Set)this.actions.get(command);
                if (commandActions != null && !commandActions.isEmpty()) {
                    actionsToChange = new HashSet();
                    actionsToChange.addAll(commandActions);
                }
            }
            if (actionsToChange != null) {
                Iterator it = actionsToChange.iterator();
                while (it.hasNext()) {
                    Action a = (Action)it.next();
                    if (a == null) continue;
                    a.putValue("AcceleratorKey", shortcut);
                }
            }
        }

        public synchronized Object getShortcut(String command) {
            return this.shorcuts.get(command);
        }
    }
}

