/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.modules.masterfs.Cache;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ProvidedExtensionsProxy;
import org.netbeans.modules.masterfs.ProviderCall;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SyncSection;
import org.netbeans.modules.masterfs.Utils;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class MasterFileSystem
extends FileSystem
implements FileStatusListener {
    private static final long serialVersionUID = -97134851800761145L;
    private static transient MasterFileSystem instance;
    private final transient StatusImpl status = new StatusImpl();
    private static final Pattern lt;
    private static final Pattern gt;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$providers$AnnotationProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MasterFileSystem getDefault() {
        boolean init = false;
        Class clazz = MasterFileSystem.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new MasterFileSystem();
                init = true;
            }
        }
        if (init) {
            ProviderCall.init();
        }
        return instance;
    }

    public static MasterFileSystem settingsFactory(FileObject inst) {
        return MasterFileSystem.getDefault();
    }

    private MasterFileSystem() {
        this.init();
    }

    private Object writeReplace() {
        return new Replace();
    }

    private void init() {
        try {
            this.setSystemName(((Object)((Object)this)).getClass().getName());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.registerFileStatusListener();
    }

    private void registerFileStatusListener() {
        Enumeration en = MountTable.getDefault().geAllFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            fs.addNotify();
            fs.addFileStatusListener((FileStatusListener)this);
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)MasterFileSystem.class, (String)"LBL_this_computer");
    }

    public boolean isReadOnly() {
        return false;
    }

    public FileObject getRoot() {
        return Cache.getDefault().getOrCreate(ResourcePath.getRoot());
    }

    public FileObject findResource(String name) {
        ResourcePath resPath = new ResourcePath(name);
        MasterFileObject retVal = Cache.getDefault().get(resPath);
        if (Utilities.getOperatingSystem() == 16384) {
            if (retVal == null) {
                retVal = MasterFileSystem.getStepByStepVMS(resPath);
            }
        } else if (retVal == null) {
            retVal = this.getStepByStep(resPath);
        }
        return retVal;
    }

    private FileObject getStepByStep(ResourcePath resPath) {
        FileObject retVal = this.getRoot();
        Enumeration elems = resPath.getElements();
        while (elems.hasMoreElements()) {
            String nameExt = (String)elems.nextElement();
            if ((retVal = retVal.getFileObject(nameExt)) != null) continue;
            return null;
        }
        return retVal;
    }

    private static String findVMSRoot(String name) {
        if (name.length() > 0) {
            StringTokenizer stok = new StringTokenizer(name, "/");
            String rootName = "";
            while (stok.hasMoreTokens()) {
                if (!new File(rootName = rootName + "/" + stok.nextToken()).exists()) continue;
                return rootName;
            }
        }
        return null;
    }

    private static FileObject getRootForVMS(String name) {
        return Cache.getDefault().getOrCreate(new ResourcePath(name));
    }

    private static FileObject getStepByStepVMS(ResourcePath resPath) {
        String root = MasterFileSystem.findVMSRoot(resPath.getNormalizedPath());
        if (root == null) {
            return null;
        }
        FileObject retVal = MasterFileSystem.getRootForVMS(root);
        ResourcePath subPath = new ResourcePath(resPath.getNormalizedPath().substring(root.length()));
        Enumeration elems = subPath.getElements();
        while (elems.hasMoreElements()) {
            String nameExt = (String)elems.nextElement();
            if (nameExt.equals("000000") || (retVal = retVal.getFileObject(nameExt)) != null) continue;
            return null;
        }
        return retVal;
    }

    public void addNotify() {
    }

    public void removeNotify() {
        Cache.getDefault().clear();
    }

    public void refresh(boolean expected) {
        Enumeration en = MountTable.getDefault().geAllFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            fs.refresh(expected);
        }
    }

    public SystemAction[] getActions() {
        return this.getEmptyActions();
    }

    private SystemAction[] getEmptyActions() {
        return new SystemAction[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAction[] getActions(Set foSet) {
        SystemAction[] some = this.status.getActions(foSet);
        if (some != null) {
            return some;
        }
        SyncSection.getDefault().enterSection();
        try {
            MasterFileObject hfo = MasterFileSystem.getUniqueMasterFileObject(foSet);
            if (hfo == null) {
                SystemAction[] systemActionArray = this.getEmptyActions();
                return systemActionArray;
            }
            FileSystem firstFs = MasterFileSystem.getDelegateFileSystem(hfo.getDelegate().get());
            FileSystem secondFs = MasterFileSystem.getDelegateFileSystem(hfo.getDelegate().getPrefered());
            if (firstFs == null) {
                SystemAction[] systemActionArray = this.getEmptyActions();
                return systemActionArray;
            }
            if (secondFs != firstFs) {
                SystemAction[] systemActionArray = this.mergeActionsFromBothDelegates(foSet, firstFs, secondFs);
                return systemActionArray;
            }
            SystemAction[] systemActionArray = firstFs.getActions(Utils.transformToDelegates(foSet, false));
            return systemActionArray;
        }
        finally {
            SyncSection.getDefault().finishSection();
        }
    }

    private static FileSystem getDelegateFileSystem(FileObject foDel) {
        if (foDel == null) {
            return null;
        }
        FileSystem fsDel = null;
        try {
            fsDel = foDel.getFileSystem();
        }
        catch (FileStateInvalidException e) {
            return null;
        }
        return fsDel;
    }

    private static MasterFileObject getUniqueMasterFileObject(Set hfoSet) {
        MasterFileObject retVal = null;
        FileSystem lastFs = null;
        Iterator it = hfoSet.iterator();
        while (it.hasNext()) {
            FileSystem fs;
            Object o = it.next();
            if (!(o instanceof MasterFileObject)) {
                return null;
            }
            retVal = (MasterFileObject)((Object)o);
            FileObject deleg = retVal.getDelegate().get();
            if (deleg == null || (fs = MasterFileSystem.getDelegateFileSystem(deleg)) == null) continue;
            if (lastFs != null && lastFs != fs) {
                return null;
            }
            lastFs = fs;
        }
        return retVal;
    }

    private SystemAction[] mergeActionsFromBothDelegates(Set hfoSet, FileSystem firstFs, FileSystem secondFs) {
        HashSet<SystemAction> mergedActions = new HashSet<SystemAction>(hfoSet.size());
        Set firstSet = Utils.transformToDelegates(hfoSet, false);
        SystemAction[] firstActions = firstFs.getActions(firstSet);
        mergedActions.addAll(Arrays.asList(firstActions));
        Set secondSet = Utils.transformToDelegates(hfoSet, true);
        SystemAction[] secondActions = secondFs.getActions(secondSet);
        mergedActions.addAll(Arrays.asList(secondActions));
        return mergedActions.toArray(new SystemAction[mergedActions.size()]);
    }

    public void annotationChanged(final FileStatusEvent ev) {
        HashSet set = new HashSet(1){

            public boolean contains(Object o) {
                if (o instanceof MasterFileObject) {
                    MasterFileObject fo = (MasterFileObject)((Object)o);
                    FileObject deleg = fo.getDelegate().get();
                    return deleg != null && ev.hasChanged(deleg);
                }
                return false;
            }
        };
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, (Set)set, ev.isIconChange(), ev.isNameChange()));
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    final void fireFileStatus(FileStatusEvent event) {
        this.fireFileStatusChanged(event);
    }

    private static String htmlEncode(String name) {
        String retval = name;
        if (retval.indexOf(60) != -1) {
            retval = lt.matcher(retval).replaceAll("&lt;");
        }
        if (retval.indexOf(62) != -1) {
            retval = gt.matcher(retval).replaceAll("&gt;");
        }
        return retval;
    }

    static {
        lt = Pattern.compile("<");
        gt = Pattern.compile(">");
    }

    static final class LazySet
    implements Set {
        private Set obj_files;
        private boolean initialized = false;
        private Iterator it = null;

        LazySet(Set obj_files) {
            this.obj_files = obj_files;
        }

        private synchronized void lazyInitialization() {
            if (!this.initialized) {
                Set transformedSet;
                this.obj_files = transformedSet = Utils.transformSet(this.obj_files);
                this.initialized = true;
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            this.lazyInitialization();
            return this.obj_files.contains(o);
        }

        public boolean containsAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.containsAll(c);
        }

        public boolean isEmpty() {
            this.lazyInitialization();
            return this.obj_files.isEmpty();
        }

        public Iterator iterator() {
            this.it = this.initialized ? this.obj_files.iterator() : new Iterator(){
                private final Iterator originalIterator;
                {
                    this.originalIterator = LazySet.this.obj_files.iterator();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object next() {
                    MasterFileObject mfo = (MasterFileObject)((Object)this.originalIterator.next());
                    return mfo.getDelegate().get(true);
                }

                public boolean hasNext() {
                    return this.originalIterator.hasNext();
                }
            };
            return this.it;
        }

        public boolean remove(Object o) {
            this.lazyInitialization();
            return this.obj_files.remove(o);
        }

        public boolean removeAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.retainAll(c);
        }

        public int size() {
            this.lazyInitialization();
            return this.obj_files.size();
        }

        public Object[] toArray() {
            this.lazyInitialization();
            return this.obj_files.toArray();
        }

        public Object[] toArray(Object[] a) {
            this.lazyInitialization();
            return this.obj_files.toArray(a);
        }
    }

    private static final class Replace
    implements Serializable {
        static final long serialVersionUID = 50485340814380L;

        private Replace() {
        }

        public Object readResolve() {
            return MasterFileSystem.getDefault();
        }
    }

    static final class StatusImpl
    implements FileSystem.HtmlStatus,
    LookupListener,
    FileStatusListener {
        private Lookup.Result annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(class$org$netbeans$modules$masterfs$providers$AnnotationProvider == null ? (class$org$netbeans$modules$masterfs$providers$AnnotationProvider = MasterFileSystem.class$("org.netbeans.modules.masterfs.providers.AnnotationProvider")) : class$org$netbeans$modules$masterfs$providers$AnnotationProvider));
        private Collection previousProviders;

        StatusImpl() {
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public ProvidedExtensions getExtensions() {
            List c = this.previousProviders != null ? Collections.unmodifiableCollection(this.previousProviders) : Collections.EMPTY_LIST;
            return new ProvidedExtensionsProxy(c);
        }

        public void resultChanged(LookupEvent ev) {
            HashSet add;
            HashSet now = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                add = new HashSet(now);
                add.removeAll(this.previousProviders);
                HashSet toRemove = new HashSet(this.previousProviders);
                toRemove.removeAll(now);
                Iterator it = toRemove.iterator();
                while (it.hasNext()) {
                    AnnotationProvider ap = (AnnotationProvider)it.next();
                    ap.removeFileStatusListener(this);
                }
            } else {
                add = now;
            }
            Iterator it = add.iterator();
            while (it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                try {
                    ap.addFileStatusListener(this);
                }
                catch (TooManyListenersException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            this.previousProviders = now;
        }

        public SystemAction[] getActions(Set foSet) {
            Action[] retVal = null;
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.actions(foSet);
            }
            if (retVal != null) {
                SystemAction[] ret = new SystemAction[retVal.length];
                for (int i = 0; i < retVal.length; ++i) {
                    if (!(retVal[i] instanceof SystemAction)) continue;
                    ret[i] = (SystemAction)retVal[i];
                }
                return ret;
            }
            return null;
        }

        public void annotationChanged(FileStatusEvent ev) {
            if (ev.getSource() != MasterFileSystem.getDefault()) {
                return;
            }
            MasterFileSystem.getDefault().fireFileStatusChanged(ev);
        }

        private FileSystem getDelegateFileSystem(Set files) {
            FileSystem retVal = null;
            Iterator it = files.iterator();
            if (it.hasNext()) {
                MasterFileObject mfo = (MasterFileObject)((Object)it.next());
                retVal = mfo.getDelegateFileSystem();
            }
            return retVal;
        }

        public Image annotateIcon(Image icon, int iconType, Set files) {
            Image retVal = null;
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.annotateIcon(icon, iconType, files);
            }
            if (retVal != null) {
                return retVal;
            }
            retVal = icon;
            FileSystem fs = this.getDelegateFileSystem(files);
            if (fs != null) {
                LazySet transformedSet = new LazySet(files);
                retVal = fs.getStatus().annotateIcon(icon, iconType, (Set)transformedSet);
            }
            return retVal;
        }

        public String annotateName(String name, Set files) {
            String retVal = null;
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.annotateName(name, files);
            }
            if (retVal != null) {
                return retVal;
            }
            retVal = name;
            LazySet transformedSet = new LazySet(files);
            FileSystem fs = this.getDelegateFileSystem(files);
            if (fs != null) {
                retVal = fs.getStatus().annotateName(name, (Set)transformedSet);
            }
            return retVal;
        }

        public String annotateNameHtml(String name, Set files) {
            name = MasterFileSystem.htmlEncode(name);
            String retVal = null;
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.annotateNameHtml(name, files);
            }
            if (retVal == null) {
                retVal = name;
                FileSystem fs = this.getDelegateFileSystem(files);
                if (fs != null && fs != null && fs.getStatus() instanceof FileSystem.HtmlStatus) {
                    LazySet transformedSet = new LazySet(files);
                    retVal = ((FileSystem.HtmlStatus)fs.getStatus()).annotateNameHtml(name, (Set)transformedSet);
                }
            }
            return retVal;
        }
    }
}

