/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.remoteproject.MainFileProvider;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remoteproject.ClassPathProviderImpl;
import org.netbeans.modules.distributed.remoteproject.OpenVMSSources;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectCustomizer;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectLogicalView;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectSettingsImpl;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public final class RemoteProject
implements Project {
    public static final String KEY_MAINFILE = "main.file";
    public static final String KEY_VERSION = "nbpov.version";
    public static final float VALUE_VERSION = 1.0f;
    public static final String IMAGES_DIR = "images";
    public static final String NAME = "name";
    private final FileObject projectDir;
    private final MainFileProviderImpl mainFile = new MainFileProviderImpl();
    private String displayPrefix;
    private String localRootCache;
    private final ProjectState state;
    private final Lookup lookup;
    private List roots;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$remoteproject$RemoteProject;

    public RemoteProject(FileObject fileObject, ProjectState projectState) {
        this.projectDir = fileObject;
        this.state = projectState;
        this.lookup = this.createLookup();
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public ProjectState getProjectState() {
        return this.state;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup() {
        return Lookups.fixed((Object[])new Object[]{this, this.state, new RemoteProjectCustomizer(this), new DeleteProvider3GL(), new DataFilesProviderImpl(), new ActionProviderImpl(), new Info(), new PrivilegedTemplatesImpl(), new RemoteProjectLogicalView(this), new OpenVMSSources(this), new ClassPathProviderImpl(this.getSourceRoots()), new ProjectOpenedHookImpl(this), new RemoteProjectSettingsImpl(this)});
    }

    public List getRoots() {
        if (this.roots == null) {
            this.roots = Utils.findProjectRoots((Project)this);
        }
        return this.roots;
    }

    private FileObject[] getSourceRoots() {
        List list = this.getRoots();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((AbstractNetworkFileSystem)list.get(i)).getFSRoot());
        }
        return arrayList.toArray(new FileObject[0]);
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Remote Project/Empty.pov", "Templates/Remote Project/Empty.inc"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private final class ActionProviderImpl
    implements ActionProvider {
        private ActionProviderImpl() {
        }

        public String[] getSupportedActions() {
            return new String[]{"delete"};
        }

        public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
            if ("delete".equals(string)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)RemoteProject.this);
                return;
            }
        }

        public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
            return "delete".equals(string);
        }
    }

    private final class MainFileProviderImpl
    implements MainFileProvider {
        private FileObject mainFile = null;
        boolean checked = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MainFileProviderImpl() {
        }

        public FileObject getMainFile() {
            if (this.mainFile == null && !this.checked) {
                this.checked = true;
                Properties properties = (Properties)RemoteProject.this.getLookup().lookup(class$java$util$Properties == null ? (class$java$util$Properties = RemoteProject.class$("java.util.Properties")) : class$java$util$Properties);
                String string = properties.getProperty(RemoteProject.KEY_MAINFILE);
                if (string != null) {
                    this.mainFile = RemoteProject.this.projectDir.getFileObject(string);
                }
            }
            if (this.mainFile != null && !this.mainFile.isValid()) {
                return null;
            }
            return this.mainFile;
        }

        public void setMainFile(FileObject fileObject) {
            if (!($assertionsDisabled || fileObject != null && fileObject.getPath().startsWith(RemoteProject.this.getProjectDirectory().getPath()))) {
                throw new AssertionError((Object)"Main file not under project");
            }
            boolean bl = this.mainFile == null != (fileObject == null) || this.mainFile != null && !this.mainFile.equals(fileObject);
            this.mainFile = fileObject;
            if (bl) {
                RemoteProject.this.state.markModified();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$distributed$remoteproject$RemoteProject == null ? (class$org$netbeans$modules$distributed$remoteproject$RemoteProject = RemoteProject.class$("org.netbeans.modules.distributed.remoteproject.RemoteProject")) : class$org$netbeans$modules$distributed$remoteproject$RemoteProject).desiredAssertionStatus();
        }
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/systemFS.gif"));
        }

        public String getName() {
            return this.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties getPropertiesOrNull() {
            Properties properties = null;
            FileObject fileObject = RemoteProject.this.getProjectDirectory().getFileObject("nbproject/project.properties");
            if (fileObject == null && (fileObject = RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase() + "/" + "project.properties".toUpperCase())) == null) {
                fileObject = RemoteProject.this.getProjectDirectory().getFileObject("nbproject/" + "project.properties".toUpperCase());
            }
            if (fileObject != null) {
                try {
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        properties = new Properties();
                        properties.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            return properties;
        }

        public String getDisplayName() {
            Properties properties = this.getPropertiesOrNull();
            if (properties != null && properties.containsKey(RemoteProject.NAME)) {
                return properties.getProperty(RemoteProject.NAME);
            }
            return "???";
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return RemoteProject.this;
        }
    }

    private final class DeleteProvider3GL
    implements DeleteOperationImplementation {
        private DeleteProvider3GL() {
        }

        public void notifyDeleted() {
            List list = RemoteProject.this.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                OpenProjectList.getFsSet().remove((FileSystem)list.get(i));
            }
            RemoteProject.this.getProjectState().notifyDeleted();
            ProjectManager.getDefault().clearNonProjectCache();
        }

        public void notifyDeleting() {
            this.notifyDeleted();
        }

        public List getDataFiles() {
            return new ArrayList();
        }

        public List getMetadataFiles() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject") != null) {
                arrayList.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject"));
            } else if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()) != null) {
                arrayList.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()));
            }
            return arrayList;
        }
    }

    private final class DataFilesProviderImpl
    implements DataFilesProviderImplementation {
        private DataFilesProviderImpl() {
        }

        public List getDataFiles() {
            return new ArrayList();
        }

        public List getMetadataFiles() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject") != null) {
                arrayList.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject"));
            } else if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()) != null) {
                arrayList.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()));
            }
            return arrayList;
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private RemoteProject project;

        ProjectOpenedHookImpl(RemoteProject remoteProject2) {
            this.project = remoteProject2;
        }

        protected void projectOpened() {
            List list = RemoteProject.this.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                FileSystem fileSystem = (FileSystem)list.get(i);
                RemoteProject remoteProject = this.project;
                fileSystem.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    }
                });
                FileOwnerQuery.markExternalOwner((FileObject)fileSystem.getRoot(), (Project)this.project, (int)0);
            }
            Utils.writeDefault3GLXMLCompilerSettings((Project)this.project);
        }

        protected void projectClosed() {
            List list = RemoteProject.this.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                ((FileSystem)list.get(i)).removeNotify();
                OpenProjectList.getFsSet().remove((FileSystem)list.get(i));
            }
        }
    }

    private class ExtensibleMetadataProviderImpl
    implements AuxiliaryConfiguration {
        private ExtensibleMetadataProviderImpl() {
        }

        public Element getConfigurationFragment(String string, String string2, boolean bl) {
            return null;
        }

        public void putConfigurationFragment(Element element, boolean bl) throws IllegalArgumentException {
        }

        public boolean removeConfigurationFragment(String string, String string2, boolean bl) throws IllegalArgumentException {
            return false;
        }
    }
}

