/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.utils;

import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import org.openide.ErrorManager;

public class DCLExecutor {
    private static final int MAX_CMD_LEN = 234;
    public static final int DCL_EXECUTION_DECTERM = 0;
    public static final int DCL_EXECUTION_STDOUT = 1;

    private static String composeDCLCmd(int n, String string) {
        return "$ s" + n + " := " + "\"" + string + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDCLFile(String string, Vector vector) throws IOException {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            printWriter = new PrintWriter((Writer)bufferedWriter, true);
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println((String)vector.get(i));
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process execute(String string, int n) throws IOException {
        if (n == 0) {
            PrintWriter printWriter = null;
            File file = File.createTempFile("compilerparams", ".bat");
            file.deleteOnExit();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
                printWriter = new PrintWriter((Writer)bufferedWriter, true);
                printWriter.println("$ create/term/wait @" + FileUtilityLang.unixPathToOpenVMSPath((String)string, (boolean)false));
                printWriter.println("$ exit %X10000000");
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            return Runtime.getRuntime().exec(file.getAbsolutePath());
        }
        return Runtime.getRuntime().exec(string);
    }

    public static Vector preprocessDCLCmds(String[] stringArray, int n) {
        Vector<String> vector = new Vector<String>();
        if (stringArray.length > 0) {
            vector.add("$ set noon");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            DCLExecutor.preprocessDCLCmd(stringArray[i], vector);
        }
        if (n == 0) {
            DCLExecutor.preprocessDCLCmd("inquire/local check \"\"Press enter to exit\"\"", vector);
            vector.add("$ exit %X10000000");
        } else {
            vector.add("$ saved_severity = $severity");
            vector.add("$ saved_status = $status");
            vector.add("$ if (saved_severity .eq. 4) .or. (saved_severity .eq. 2) then goto done");
            vector.add("$ exit %X10000000");
            vector.add("$ done :");
            vector.add("$ exit saved_status");
        }
        return vector;
    }

    public static Process execute(String string, String[] stringArray, int n) throws IOException {
        Vector vector = DCLExecutor.preprocessDCLCmds(stringArray, n);
        try {
            DCLExecutor.createDCLFile(string, vector);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            throw new IOException(exception.toString());
        }
        return DCLExecutor.execute(string, n);
    }

    public static void preprocessDCLCmd(String string, Vector vector) {
        int n = (int)Math.ceil((double)string.length() / 234.0);
        String string2 = "$ ";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + 234 >= string.length() ? string.length() : n2 + 234;
            vector.add(DCLExecutor.composeDCLCmd(i, string.substring(n2, n3)));
            n2 += 234;
            string2 = string2 + "'" + "s" + i + "'";
        }
        vector.add("$ define/user/nolog sys$error sys$output");
        vector.add(string2);
    }
}

