/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrameImpl;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import com.hp.openvms.netbeans.debugsupport.model.AbstractVariable;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private static boolean verbose = false;
    private static final int ARRAY_CHILDREN_NESTED_LENGTH = 100;
    private RemoteDebugger debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private Map cachedLocals = new WeakHashMap();
    private Map cachedArrayChildren = new WeakHashMap();
    private ModelListener modelListener = null;

    public LocalsTreeModel(ContextProvider contextProvider) {
        this.debugger = (RemoteDebugger)contextProvider.lookupFirst(null, RemoteDebugger.class);
        this.debugger.registerLocalsModel(this);
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTableValueChangedChanged(propertyChangeEvent.getSource(), null);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray = this.getChildrenImpl(object, n, n2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Customizer)) continue;
            ((Customizer)objectArray[i]).addPropertyChangeListener(this);
        }
        return objectArray;
    }

    public Object[] getChildrenImpl(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            Object[] objectArray = this.getLocalVariables(n, n2);
            return objectArray;
        }
        if (object instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)object;
            return abstractVariable.getFields(n, n2);
        }
        return new Object[0];
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrameImpl == null) {
                return 1;
            }
            LocalVariable[] localVariableArray = callStackFrameImpl.visibleVariables();
            return localVariableArray.length;
        }
        if (object instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)object;
            return abstractVariable.getFieldsCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof AbstractVariable) {
            int n = ((AbstractVariable)object).getFieldsCount();
            return n <= 0;
        }
        if (object instanceof LocalVariable) {
            return true;
        }
        if (object.equals("NoInfo")) {
            return true;
        }
        if (object.equals("No current thread")) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.modelListener = modelListener;
        this.listeners.add(modelListener);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
        this.debugger.registerLocalsListener(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.debugger.registerLocalsListener(null);
        this.modelListener = null;
        this.listeners.remove(modelListener);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTableValueChangedChanged(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int n, int n2) {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrameImpl == null) {
                return new String[]{"No current thread"};
            }
            return callStackFrameImpl.getLocalVariables();
        }
    }

    LocalVariable[] getLocalVariables(CallStackFrameImpl callStackFrameImpl, int n, int n2) {
        LocalVariable[] localVariableArray = callStackFrameImpl.getLocalVariables();
        int n3 = localVariableArray.length;
        n2 = Math.min(n3, n2);
        if ((n = Math.min(n3, n)) != 0 || n2 != n3) {
            LocalVariable[] localVariableArray2 = new LocalVariable[n2 - n];
            for (int i = n; i < n2; ++i) {
                localVariableArray2[i - n] = localVariableArray[i];
            }
            localVariableArray = localVariableArray2;
        }
        return localVariableArray;
    }

    public Variable getVariable(String string) {
        return new AbstractVariable(this.debugger, string, null, null, null);
    }

    RemoteDebugger getDebugger() {
        return this.debugger;
    }

    private static class Listener
    implements PropertyChangeListener {
        private RemoteDebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel localsTreeModel, RemoteDebugger remoteDebugger) {
            this.debugger = remoteDebugger;
            this.model = new WeakReference<LocalsTreeModel>(localsTreeModel);
            remoteDebugger.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel localsTreeModel = (LocalsTreeModel)this.model.get();
            if (localsTreeModel == null) {
                this.destroy();
            }
            return localsTreeModel;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block9: {
                block8: {
                    if (propertyChangeEvent.getPropertyName() == "currentCallStackFrame") break block8;
                    if (propertyChangeEvent.getPropertyName() != "state") break block9;
                }
                if (this.debugger.getState() == "state_stopped") {
                    final LocalsTreeModel localsTreeModel = this.getModel();
                    if (localsTreeModel == null) {
                        return;
                    }
                    if (this.task != null) {
                        this.task.cancel();
                        if (verbose) {
                            System.out.println("LTM cancel old task " + this.task);
                        }
                        this.task = null;
                    }
                    this.task = RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            String string = Listener.this.debugger.getState();
                            Listener.this.debugger;
                            if (string != "state_stopped") {
                                if (verbose) {
                                    System.out.println("LTM cancel started task " + Listener.this.task);
                                }
                                return;
                            }
                            if (verbose) {
                                System.out.println("LTM do task " + Listener.this.task);
                            }
                            localsTreeModel.fireTreeChanged();
                        }
                    }, 500);
                    if (!verbose) return;
                    System.out.println("LTM  create task " + this.task);
                    return;
                }
            }
            if (propertyChangeEvent.getPropertyName() != "state") return;
            if (this.debugger.getState() == "state_stopped") return;
            if (this.task == null) return;
            this.task.cancel();
            if (verbose) {
                System.out.println("LTM cancel task " + this.task);
            }
            this.task = null;
        }
    }
}

