/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.SheetButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.UIManager;

class PropertyShow
extends JPanel {
    static final long serialVersionUID = -8663903931982719530L;
    private PropertyEditor propertyEditor;
    private Vector listeners = new Vector(1, 5);

    public PropertyShow(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.setDoubleBuffered(false);
        this.setOpaque(true);
    }

    public void setValue(Object object) {
        this.propertyEditor.setValue(object);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(4, 0, dimension.width - 4, dimension.height);
        graphics.setColor(this.getForeground());
        this.propertyEditor.paintValue(graphics, rectangle);
        graphics.setColor(color);
        if (this.hasFocus()) {
            graphics.setColor(UIManager.getColor("Button.focus"));
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        }
    }

    public void setEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    void fireSheetButtonClicked(ActionEvent actionEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((SheetButtonListener)vector.elementAt(i)).sheetButtonClicked(actionEvent);
        }
    }

    public void addSheetButtonListener(SheetButtonListener sheetButtonListener) {
        this.listeners.addElement(sheetButtonListener);
    }

    public void removeSheetButtonListener(SheetButtonListener sheetButtonListener) {
        this.listeners.removeElement(sheetButtonListener);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyShow();
        }
        return this.accessibleContext;
    }

    private class AccessiblePropertyShow
    extends JPanel.AccessibleJPanel {
        AccessiblePropertyShow() {
            super(PropertyShow.this);
        }

        public String getAccessibleName() {
            return PropertyShow.this.propertyEditor.getAsText();
        }
    }
}

