/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openide.util.Utilities;

public class AlphaVMSListQualifier
implements Serializable {
    private String[] items;
    private static final long serialVersionUID = -3168038106222542273L;

    public AlphaVMSListQualifier() {
    }

    public AlphaVMSListQualifier(String[] stringArray) {
        this.items = stringArray;
    }

    public AlphaVMSListQualifier(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("(")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith(")")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            arrayList.add(string2.trim());
        }
        this.items = arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AlphaVMSListQualifier)) {
            return false;
        }
        AlphaVMSListQualifier alphaVMSListQualifier = (AlphaVMSListQualifier)object;
        if (this.items == null && alphaVMSListQualifier.items == null) {
            return true;
        }
        if (this.items == null || alphaVMSListQualifier.items == null) {
            return false;
        }
        if (this.items.length != alphaVMSListQualifier.items.length) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].equalsIgnoreCase(alphaVMSListQualifier.items[i])) continue;
            return false;
        }
        return true;
    }

    public String getFileList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].startsWith("/")) {
                stringBuffer.append(FileUtilityLang.unixPathToOpenVMSPath((String)this.items[i], (boolean)true));
            } else {
                stringBuffer.append(this.items[i]);
            }
            if (i + 1 >= this.items.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getRemoteFileList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].startsWith("/")) {
                stringBuffer.append(FileUtilityLang.__unixPathToOpenVMSPath(this.items[i], true));
            } else if (Utilities.isWindows() && this.items[i].length() > 3 && this.items[i].substring(1, 3).equals(":\\")) {
                stringBuffer.append(FileUtilityLang.__winPathToOpenVMSPath(this.items[i], true));
            } else {
                stringBuffer.append(this.items[i]);
            }
            if (i + 1 >= this.items.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getPlainList() {
        if (this.items == null || this.items.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.items.length; ++i) {
            stringBuffer.append(this.items[i]);
            if (i + 1 >= this.items.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getPlainList();
    }
}

