/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteMultipleRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootJPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootPanel;
import org.openide.util.NbBundle;

public class RemoteRootVisualPanel
extends RemoteRootJPanel
implements PropertyChangeListener {
    private final RemoteRootPanel panel;

    public RemoteRootVisualPanel(RemoteRootPanel remoteRootPanel, FileSystemView fileSystemView) {
        super("Network Drive Root", "Remote Root", "Remote Directory:", fileSystemView);
        this.panel = remoteRootPanel;
        this.setName(NbBundle.getMessage((Class)RemoteRootJPanel.class, (String)"TITLE_remote_root"));
    }

    public RemoteRootVisualPanel(RemoteRootPanel remoteRootPanel) {
        super("Network Drive Root", "Remote Root", "Remote Directory:");
        this.panel = remoteRootPanel;
        this.setName(NbBundle.getMessage((Class)RemoteRootJPanel.class, (String)"TITLE_remote_root"));
    }

    public RemoteRootVisualPanel(RemoteMultipleRootPanel remoteMultipleRootPanel, boolean bl, boolean bl2) {
        super("Network Drive Root", "Remote Root", "Remote Directory:", bl, false, null);
        this.panel = remoteMultipleRootPanel;
        if (!bl2) {
            FileEditor.recursiveDisableComponentStatic(this, false);
        }
        this.setName(NbBundle.getMessage((Class)RemoteRootJPanel.class, (String)"TITLE_remote_root"));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string) || "SelectedFileChangedProperty".equals(string) || string.equals("ancestor")) {
            JFileChooser jFileChooser = this.getFileChooser();
            File file = "directoryChanged".equals(string) ? jFileChooser.getCurrentDirectory() : ("SelectedFileChangedProperty".equals(string) ? jFileChooser.getSelectedFile() : jFileChooser.getCurrentDirectory());
            if (file == null) {
                this.panel.fireChangeState();
                return;
            }
            this.getTextField().setText("");
            String string2 = this.panel.getRemoteDirectory(file.getAbsolutePath());
            if (!string2.equals("")) {
                this.getTextField().setText(string2);
            }
            this.panel.fireChangeState();
        }
    }

    public void createRemoteDirectory() {
        this.getFileChooser().addPropertyChangeListener(this);
        this.getTextField().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RemoteRootVisualPanel.this.panel.fireChangeState();
                    }
                });
            }
        });
    }
}

