/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootJPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootVisualPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class RemoteMultipleRootPanel
extends RemoteRootPanel
implements WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    protected ArrayList rootsHistory;
    private String projectDirectory;
    private String remoteDirectory;
    protected int panelIndex;
    private boolean editable;
    public static final String WIZARD_KEY_TARGET_FOLDER = "targetFolder";
    public static final String WIZARD_KEY_TARGET_NAME = "targetName";

    public RemoteMultipleRootPanel(String string, String string2, int n, boolean bl) {
        this.panelIndex = n;
        this.projectDirectory = string;
        this.editable = bl;
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteRootVisualPanel(this, false, this.editable);
        }
        return this.component;
    }

    public boolean hideFS() {
        return ((RemoteRootJPanel)this.component).isHideChecked();
    }

    public boolean isValid() {
        if (!((RemoteRootVisualPanel)this.getComponent()).getLocalDirectory().equals("") && !((RemoteRootVisualPanel)this.getComponent()).getRemoteDirectory().equals("")) {
            Enumeration enumeration = Repository.getDefault().getFileSystems();
            while (enumeration.hasMoreElements()) {
                String string;
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                if (!(fileSystem instanceof LocalFileSystem) || fileSystem instanceof NetworkFileSystem || !(string = ((LocalFileSystem)fileSystem).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(((RemoteRootVisualPanel)this.getComponent()).getLocalDirectory())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void readSettings(Object object) {
        super.readSettings(object);
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        if (!this.editable) {
            this.remoteDirectory = this.getRemoteDirectory(this.projectDirectory);
            ((RemoteRootVisualPanel)this.component).getFileChooser().setCurrentDirectory(new File(this.projectDirectory));
            ((RemoteRootVisualPanel)this.component).getTextField().setText(this.remoteDirectory);
            this.fireChangeState();
        }
        this.rootsHistory = (ArrayList)wizardDescriptor.getProperty("remotefs_list");
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("remote_directory", ((RemoteRootVisualPanel)this.component).getRemoteDirectory());
        hashMap.put("local_directory", ((RemoteRootVisualPanel)this.component).getLocalDirectory());
        if (this.isValid()) {
            ArrayList<HashMap<String, String>> arrayList = (ArrayList<HashMap<String, String>>)wizardDescriptor.getProperty("remotefs_list");
            if (arrayList == null) {
                arrayList = new ArrayList<HashMap<String, String>>();
                arrayList.add(this.panelIndex, hashMap);
                wizardDescriptor.putProperty("remotefs_list", arrayList);
                ProjectChooser.setProjectsFolder((File)new File(((RemoteRootVisualPanel)this.component).getLocalDirectory()));
            } else {
                if (this.panelIndex < arrayList.size() && arrayList.get(this.panelIndex) != null) {
                    arrayList.remove(this.panelIndex);
                }
                arrayList.add(this.panelIndex, hashMap);
                wizardDescriptor.putProperty("remotefs_list", arrayList);
            }
        }
    }

    public boolean isValidLocal() {
        String string = ((RemoteRootVisualPanel)this.component).getLocalDirectory();
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!new File(string).exists()) {
            return false;
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            String string2;
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (!(fileSystem instanceof LocalFileSystem && !(fileSystem instanceof AbstractNetworkFileSystem) ? (string2 = ((LocalFileSystem)fileSystem).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(string) : fileSystem instanceof AbstractNetworkFileSystem && (string2 = ((AbstractNetworkFileSystem)fileSystem).getLocalRoot()).equalsIgnoreCase(string))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidLocal(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return false;
        }
        if (string.length() < string2.length()) {
            if (string.charAt(string.length() - 1) == File.separatorChar) {
                string = string.substring(0, string.length() - 1);
            }
            if (string2.toUpperCase().indexOf(string.toUpperCase()) == 0 && string2.charAt(string.length()) == File.separatorChar) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidRemote(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return false;
        }
        if (string.length() < string2.length()) {
            if (string.indexOf(93) != -1) {
                string = string.substring(0, string.indexOf(93));
            }
            if (string2.toUpperCase().indexOf(string.toUpperCase()) == 0 && (string2.charAt(string.length()) == '.' || string2.charAt(string.length()) == ']')) {
                return false;
            }
        }
        return true;
    }

    public boolean isInRootsHistory(String string, String string2) {
        if (this.rootsHistory != null) {
            for (int i = 0; i < this.rootsHistory.size(); ++i) {
                if (i == this.panelIndex) continue;
                Map map = (Map)this.rootsHistory.get(i);
                String string3 = ((String)map.get("remote_directory")).toUpperCase();
                String string4 = ((String)map.get("local_directory")).toUpperCase();
                if (string3.trim().length() == 0 || string4.trim().length() == 0 || this.isValidRemote(string3, string) && this.isValidRemote(string, string3) && this.isValidLocal(string4, string2) && this.isValidLocal(string2, string4)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidPath() throws WizardValidationException {
        String string = ((RemoteRootVisualPanel)this.component).getLocalDirectory();
        String string2 = ((RemoteRootVisualPanel)this.component).getRemoteDirectory();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"));
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (!(fileSystem instanceof AbstractNetworkFileSystem)) continue;
            String string3 = ((AbstractNetworkFileSystem)fileSystem).getLocalRoot().toUpperCase();
            String string4 = ((AbstractNetworkFileSystem)fileSystem).getRemoteRoot().toUpperCase();
            if (this.isValidLocal(string3, string.toUpperCase()) && this.isValidRemote(string4, string2.toUpperCase())) continue;
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_PROJECT"));
        }
        if (this.isInRootsHistory(string2.toUpperCase(), string.toUpperCase())) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_PROJECT"));
        }
        return true;
    }

    public void validate() throws WizardValidationException {
        this.isValidPath();
    }

    public boolean isFinishPanel() {
        return this.editable;
    }
}

