/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.propertyeditor;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.remotefs.RemoteJarFileSystem;
import org.netbeans.modules.distributed.remotefs.property.RemoteJarRootProperty;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteJarRootEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteRootJPanel;

public class RemoteJarRootCustomEditor
extends RemoteRootJPanel
implements PropertyChangeListener {
    private RemoteJarRootEditor remoteJarRootEditor;

    public RemoteJarRootCustomEditor(RemoteJarRootEditor remoteJarRootEditor) {
        super("Local Archive File", "Remote Archive File", "Remote Archive:");
        this.remoteJarRootEditor = remoteJarRootEditor;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public Object getPropertyValue() throws IllegalStateException {
        RemoteJarRootProperty remoteJarRootProperty = (RemoteJarRootProperty)this.remoteJarRootEditor.getValue();
        RemoteJarFileSystem remoteJarFileSystem = remoteJarRootProperty.getNetworkJarFS();
        return new RemoteJarRootProperty(remoteJarFileSystem, this.getRemoteDirectory(), this.getLocalDirectory());
    }

    private void fireValueChanged() {
        if (this.remoteJarRootEditor != null) {
            this.remoteJarRootEditor.setValue(this.getPropertyValue());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string) || "SelectedFileChangedProperty".equals(string) || string.equals("ancestor")) {
            JFileChooser jFileChooser = this.getFileChooser();
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                file = jFileChooser.getCurrentDirectory();
            }
            this.getTextField().setText("");
            String string2 = this.remoteJarRootEditor.getRemoteJarFile(file.getAbsolutePath());
            if (!string2.equals("")) {
                this.getTextField().setText(string2);
            }
            this.fireValueChanged();
        }
    }

    public void createRemoteDirectory() {
        this.getFileChooser().addPropertyChangeListener(this);
        this.getTextField().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RemoteJarRootCustomEditor.this.fireValueChanged();
                    }
                });
            }
        });
    }
}

